/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.sis.internal.metadata.NameToIdentifier;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.referencing.ImmutableIdentifier;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.LocalName;
import org.opengis.util.NameFactory;
import org.opengis.util.NameSpace;
import org.opengis.util.ScopedName;

public class NamedIdentifier
extends ImmutableIdentifier
implements GenericName {
    private static final long serialVersionUID = -3982456534858346939L;
    private transient GenericName name;
    private transient boolean isNameSupplied;

    public NamedIdentifier(ReferenceIdentifier referenceIdentifier) {
        super(referenceIdentifier);
        if (referenceIdentifier instanceof GenericName) {
            this.name = (GenericName)((Object)referenceIdentifier);
            this.isNameSupplied = true;
        }
    }

    public NamedIdentifier(GenericName genericName) {
        super(genericName instanceof ReferenceIdentifier ? (ReferenceIdentifier)((Object)genericName) : new NameToIdentifier(genericName));
        this.name = genericName;
        this.isNameSupplied = true;
    }

    public NamedIdentifier(Map<String, ?> map) throws IllegalArgumentException {
        super(map);
        this.name = (GenericName)map.get("name");
        this.isNameSupplied = this.name != null;
    }

    public NamedIdentifier(Citation citation, CharSequence charSequence) {
        super(citation, Citations.toCodeSpace(citation), NamedIdentifier.toString(charSequence));
        if (charSequence instanceof InternationalString) {
            this.name = NamedIdentifier.createName(citation, super.getCodeSpace(), charSequence);
            this.isNameSupplied = true;
        }
    }

    public NamedIdentifier(Citation citation, String string, CharSequence charSequence, String string2, InternationalString internationalString) {
        super(citation, string, NamedIdentifier.toString(charSequence), string2, internationalString);
        if (charSequence instanceof InternationalString) {
            this.name = NamedIdentifier.createName(citation, string, charSequence);
            this.isNameSupplied = true;
        }
    }

    private static String toString(CharSequence charSequence) {
        ArgumentChecks.ensureNonNull("code", charSequence);
        String string = charSequence instanceof InternationalString ? ((InternationalString)charSequence).toString(Locale.ROOT) : charSequence.toString();
        if (string != null) {
            return string;
        }
        throw new IllegalArgumentException(Errors.format((short)42, "code", charSequence.getClass()));
    }

    private synchronized GenericName getName() {
        if (this.name == null) {
            this.name = NamedIdentifier.createName(super.getAuthority(), super.getCodeSpace(), super.getCode());
        }
        return this.name;
    }

    private static GenericName createName(Citation citation, String string, CharSequence charSequence) {
        if (string == null) {
            string = Citations.toCodeSpace(citation);
        }
        NameFactory nameFactory = DefaultFactories.forBuildin(NameFactory.class);
        if (string != null) {
            return nameFactory.createGenericName(null, string, charSequence);
        }
        return nameFactory.createLocalName(null, charSequence);
    }

    public static NamedIdentifier castOrCopy(ReferenceIdentifier referenceIdentifier) {
        if (referenceIdentifier == null || referenceIdentifier instanceof NamedIdentifier) {
            return (NamedIdentifier)referenceIdentifier;
        }
        return new NamedIdentifier(referenceIdentifier);
    }

    public static NamedIdentifier castOrCopy(GenericName genericName) {
        if (genericName == null || genericName instanceof NamedIdentifier) {
            return (NamedIdentifier)genericName;
        }
        return new NamedIdentifier(genericName);
    }

    @Override
    public LocalName tip() {
        return this.getName().tip();
    }

    @Override
    public LocalName head() {
        return this.getName().head();
    }

    @Override
    public NameSpace scope() {
        return this.getName().scope();
    }

    @Override
    public int depth() {
        return this.getName().depth();
    }

    @Override
    public List<? extends LocalName> getParsedNames() {
        return this.getName().getParsedNames();
    }

    @Override
    public ScopedName push(GenericName genericName) {
        return this.getName().push(genericName);
    }

    @Override
    public GenericName toFullyQualifiedName() {
        return this.getName().toFullyQualifiedName();
    }

    @Override
    public InternationalString toInternationalString() {
        return this.getName().toInternationalString();
    }

    @Override
    public String toString() {
        return this.getName().toString();
    }

    @Override
    public int compareTo(GenericName genericName) {
        return this.getName().compareTo(genericName);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            if (!this.isNameSupplied) {
                return true;
            }
            NamedIdentifier namedIdentifier = (NamedIdentifier)object;
            return Objects.equals(this.getName(), namedIdentifier.getName());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return ~super.hashCode();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.isNameSupplied ? this.name : null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.name = (GenericName)objectInputStream.readObject();
        this.isNameSupplied = this.name != null;
    }
}

