/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import javax.measure.IncommensurableException;
import javax.measure.Unit;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.jaxb.metadata.replace.ServiceParameter;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.measure.Range;
import org.apache.sis.parameter.DefaultParameterDescriptor;
import org.apache.sis.parameter.FilteredParameters;
import org.apache.sis.parameter.ParameterFormat;
import org.apache.sis.parameter.UnmodifiableParameterValueGroup;
import org.apache.sis.parameter.Verifier;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ObjectConverters;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.InvalidParameterNameException;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.MemberName;

@XmlTransient
public abstract class Parameters
implements ParameterValueGroup,
Cloneable {
    protected Parameters() {
    }

    public static boolean isUnmodifiable(ParameterValueGroup parameterValueGroup) {
        return parameterValueGroup instanceof UnmodifiableParameterValueGroup;
    }

    public static Parameters unmodifiable(ParameterValueGroup parameterValueGroup) {
        return UnmodifiableParameterValueGroup.create(parameterValueGroup);
    }

    public static Parameters unmodifiable(ParameterValueGroup parameterValueGroup, Predicate<? super GeneralParameterDescriptor> predicate) {
        return FilteredParameters.create(UnmodifiableParameterValueGroup.create(parameterValueGroup), predicate);
    }

    public static Parameters castOrWrap(ParameterValueGroup parameterValueGroup) {
        if (parameterValueGroup == null || parameterValueGroup instanceof Parameters) {
            return (Parameters)parameterValueGroup;
        }
        return new Wrapper(parameterValueGroup);
    }

    public static <T> ParameterDescriptor<T> cast(ParameterDescriptor<?> parameterDescriptor, Class<T> clazz) throws ClassCastException {
        Class<?> clazz2;
        ArgumentChecks.ensureNonNull("valueClass", clazz);
        if (parameterDescriptor != null && !clazz.equals(clazz2 = parameterDescriptor.getValueClass())) {
            throw new ClassCastException(Resources.format((short)23, Verifier.getDisplayName(parameterDescriptor), clazz2));
        }
        return parameterDescriptor;
    }

    public static <T> ParameterValue<T> cast(ParameterValue<?> parameterValue, Class<T> clazz) throws ClassCastException {
        GeneralParameterDescriptor generalParameterDescriptor;
        Class clazz2;
        ArgumentChecks.ensureNonNull("valueClass", clazz);
        if (parameterValue != null && !clazz.equals(clazz2 = (generalParameterDescriptor = parameterValue.getDescriptor()).getValueClass())) {
            throw new ClassCastException(Resources.format((short)23, Verifier.getDisplayName(generalParameterDescriptor), clazz2));
        }
        return parameterValue;
    }

    public static GeneralParameterDescriptor[] getDescriptors(GeneralParameterValue ... generalParameterValueArray) {
        if (generalParameterValueArray == null) {
            return null;
        }
        GeneralParameterDescriptor[] generalParameterDescriptorArray = new GeneralParameterDescriptor[generalParameterValueArray.length];
        for (int i = 0; i < generalParameterValueArray.length; ++i) {
            GeneralParameterValue generalParameterValue = generalParameterValueArray[i];
            if (generalParameterValue == null) continue;
            generalParameterDescriptorArray[i] = generalParameterValue.getDescriptor();
        }
        return generalParameterDescriptorArray;
    }

    public static MemberName getMemberName(ParameterDescriptor<?> parameterDescriptor) {
        return ServiceParameter.getMemberName(parameterDescriptor);
    }

    public static Range<?> getValueDomain(ParameterDescriptor<?> parameterDescriptor) {
        if (parameterDescriptor != null) {
            if (parameterDescriptor instanceof DefaultParameterDescriptor) {
                return ((DefaultParameterDescriptor)parameterDescriptor).getValueDomain();
            }
            Class<Object> clazz = parameterDescriptor.getValueClass();
            Comparable<?> comparable = parameterDescriptor.getMinimumValue();
            Comparable<?> comparable2 = parameterDescriptor.getMaximumValue();
            if (clazz == null && (clazz = Classes.findCommonClass(Classes.getClass(comparable), Classes.getClass(comparable2))) == null) {
                clazz = Object.class;
            }
            if ((comparable == null || clazz.isInstance(comparable)) && (comparable2 == null || clazz.isInstance(comparable2))) {
                if (Number.class.isAssignableFrom(clazz)) {
                    Unit<?> unit = parameterDescriptor.getUnit();
                    if (unit != null) {
                        return new MeasurementRange<Number>(clazz, (Number)((Object)comparable), true, (Number)((Object)comparable2), true, unit);
                    }
                    if (comparable != null || comparable2 != null) {
                        return new NumberRange<Number>(clazz, (Number)((Object)comparable), true, (Number)((Object)comparable2), true);
                    }
                } else if (comparable != null || comparable2 != null) {
                    return new Range(clazz, comparable, true, comparable2, true);
                }
            }
        }
        return null;
    }

    private String getName(GeneralParameterDescriptor generalParameterDescriptor) {
        Citation citation;
        String string;
        ReferenceIdentifier referenceIdentifier;
        ParameterDescriptorGroup parameterDescriptorGroup = this.getDescriptor();
        if (parameterDescriptorGroup != null && (referenceIdentifier = parameterDescriptorGroup.getName()) != null && ((string = IdentifiedObjects.getName(generalParameterDescriptor, citation = referenceIdentifier.getAuthority())) != null || citation == null)) {
            return string;
        }
        return IdentifiedObjects.getName(generalParameterDescriptor, null);
    }

    ParameterValue<?> parameterIfExist(String string) throws ParameterNotFoundException {
        Object object;
        Object object2;
        int n = 0;
        int n2 = 0;
        ParameterValue parameterValue = null;
        ParameterValue parameterValue2 = null;
        List<GeneralParameterValue> list = this.values();
        int n3 = list.size();
        for (int i = 0; i < n3; ++i) {
            object2 = list.get(i);
            if (!(object2 instanceof ParameterValue) || !IdentifiedObjects.isHeuristicMatchForName((object = (ParameterValue)object2).getDescriptor(), string)) continue;
            if (parameterValue == null) {
                parameterValue = object;
                n = i;
                continue;
            }
            parameterValue2 = object;
            n2 = i;
        }
        if (parameterValue2 == null || !this.isKnownImplementation()) {
            return parameterValue;
        }
        GeneralParameterDescriptor generalParameterDescriptor = parameterValue.getDescriptor();
        object = generalParameterDescriptor == (object2 = parameterValue2.getDescriptor()) ? Errors.format((short)173, string, n, n2) : Errors.format((short)1, IdentifiedObjects.toString(generalParameterDescriptor.getName()), IdentifiedObjects.toString(object2.getName()), string);
        throw new ParameterNotFoundException((String)object, string);
    }

    ParameterValue<?> getParameter(ParameterDescriptor<?> parameterDescriptor) throws ParameterNotFoundException {
        ArgumentChecks.ensureNonNull("parameter", parameterDescriptor);
        String string = this.getName(parameterDescriptor);
        ParameterValue<?> parameterValue = this.parameterIfExist(string);
        if (parameterValue == null || this.isKnownImplementation()) {
            return parameterValue;
        }
        return this.parameter(string);
    }

    boolean isKnownImplementation() {
        return false;
    }

    public <T> T getValue(ParameterDescriptor<T> parameterDescriptor) throws ParameterNotFoundException {
        ParameterValue<?> parameterValue = this.getParameter(parameterDescriptor);
        if (parameterValue != null) {
            Class<T> clazz = parameterDescriptor.getValueClass();
            Unit<?> unit = parameterDescriptor.getUnit();
            Object object = parameterValue.getValue();
            if (object != null) {
                if (unit != null) {
                    object = clazz.isArray() ? (Object)parameterValue.doubleValueList(unit) : Double.valueOf(parameterValue.doubleValue(unit));
                }
                return ObjectConverters.convert(object, clazz);
            }
        }
        return parameterDescriptor.getDefaultValue();
    }

    public <T> T getMandatoryValue(ParameterDescriptor<T> parameterDescriptor) throws ParameterNotFoundException {
        ParameterValue<?> parameterValue = this.getParameter(parameterDescriptor);
        if (parameterValue != null) {
            Class<T> clazz = parameterDescriptor.getValueClass();
            Unit<?> unit = parameterDescriptor.getUnit();
            Object object = unit == null ? parameterValue.getValue() : (clazz.isArray() ? (Object)parameterValue.doubleValueList(unit) : Double.valueOf(parameterValue.doubleValue(unit)));
            T t = object != null ? ObjectConverters.convert(object, clazz) : parameterDescriptor.getDefaultValue();
            if (t != null) {
                return t;
            }
        }
        throw new IllegalStateException(Resources.format((short)44, Verifier.getDisplayName(parameterDescriptor)));
    }

    private static <T> T defaultValue(ParameterDescriptor<T> parameterDescriptor) throws IllegalStateException {
        T t = parameterDescriptor.getDefaultValue();
        if (t != null) {
            return t;
        }
        throw new IllegalStateException(Resources.format((short)44, Verifier.getDisplayName(parameterDescriptor)));
    }

    public boolean booleanValue(ParameterDescriptor<Boolean> parameterDescriptor) throws ParameterNotFoundException {
        ParameterValue<?> parameterValue = this.getParameter(parameterDescriptor);
        return parameterValue != null ? parameterValue.booleanValue() : Parameters.defaultValue(parameterDescriptor).booleanValue();
    }

    public int intValue(ParameterDescriptor<? extends Number> parameterDescriptor) throws ParameterNotFoundException {
        ParameterValue<?> parameterValue = this.getParameter(parameterDescriptor);
        return parameterValue != null ? parameterValue.intValue() : Parameters.defaultValue(parameterDescriptor).intValue();
    }

    public int[] intValueList(ParameterDescriptor<int[]> parameterDescriptor) throws ParameterNotFoundException {
        ParameterValue<?> parameterValue = this.getParameter(parameterDescriptor);
        return parameterValue != null ? parameterValue.intValueList() : Parameters.defaultValue(parameterDescriptor);
    }

    public double doubleValue(ParameterDescriptor<? extends Number> parameterDescriptor) throws ParameterNotFoundException {
        ParameterValue<?> parameterValue = this.getParameter(parameterDescriptor);
        if (parameterValue != null) {
            Unit<?> unit = parameterDescriptor.getUnit();
            return unit != null ? parameterValue.doubleValue(unit) : parameterValue.doubleValue();
        }
        return Parameters.defaultValue(parameterDescriptor).doubleValue();
    }

    public double doubleValue(ParameterDescriptor<? extends Number> parameterDescriptor, Unit<?> unit) throws ParameterNotFoundException {
        ArgumentChecks.ensureNonNull("unit", unit);
        ParameterValue<?> parameterValue = this.getParameter(parameterDescriptor);
        if (parameterValue != null) {
            return parameterValue.doubleValue(unit);
        }
        double d = Parameters.defaultValue(parameterDescriptor).doubleValue();
        Unit<?> unit2 = parameterDescriptor.getUnit();
        if (unit2 != null) {
            try {
                d = unit2.getConverterToAny(unit).convert(d);
            }
            catch (IncommensurableException incommensurableException) {
                throw new IllegalArgumentException(Errors.format((short)66, unit2, unit), incommensurableException);
            }
        }
        return d;
    }

    public double[] doubleValueList(ParameterDescriptor<double[]> parameterDescriptor) throws ParameterNotFoundException {
        ParameterValue<?> parameterValue = this.getParameter(parameterDescriptor);
        if (parameterValue != null) {
            Unit<?> unit = parameterDescriptor.getUnit();
            return unit != null ? parameterValue.doubleValueList(unit) : parameterValue.doubleValueList();
        }
        return Parameters.defaultValue(parameterDescriptor);
    }

    public String stringValue(ParameterDescriptor<? extends CharSequence> parameterDescriptor) throws ParameterNotFoundException {
        ParameterValue<?> parameterValue = this.getParameter(parameterDescriptor);
        return parameterValue != null ? parameterValue.stringValue() : Parameters.defaultValue(parameterDescriptor).toString();
    }

    public <T> ParameterValue<T> getOrCreate(ParameterDescriptor<T> parameterDescriptor) throws ParameterNotFoundException {
        return Parameters.cast(this.parameter(this.getName(parameterDescriptor)), parameterDescriptor.getValueClass());
    }

    @Override
    public Parameters clone() {
        try {
            return (Parameters)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }

    public static void copy(ParameterValueGroup parameterValueGroup, ParameterValueGroup parameterValueGroup2) throws InvalidParameterNameException, InvalidParameterValueException {
        Integer n = 0;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (GeneralParameterValue generalParameterValue : parameterValueGroup.values()) {
            Object object;
            String string = generalParameterValue.getDescriptor().getName().getCode();
            int n2 = hashMap.getOrDefault(string, n);
            if (generalParameterValue instanceof ParameterValueGroup) {
                object = parameterValueGroup2.groups(string);
                Parameters.copy((ParameterValueGroup)generalParameterValue, n2 < object.size() ? (ParameterValueGroup)object.get(n2) : parameterValueGroup2.addGroup(string));
            } else {
                ParameterValue parameterValue;
                object = (ParameterValue)generalParameterValue;
                if (n2 == 0) {
                    try {
                        parameterValue = parameterValueGroup2.parameter(string);
                    }
                    catch (ParameterNotFoundException parameterNotFoundException) {
                        throw (InvalidParameterNameException)new InvalidParameterNameException(Errors.format((short)140, string), string).initCause(parameterNotFoundException);
                    }
                } else {
                    parameterValue = (ParameterValue)Parameters.getOrCreate(parameterValueGroup2, string, n2);
                }
                Object t = object.getValue();
                Unit<?> unit = object.getUnit();
                if (unit == null) {
                    parameterValue.setValue(t);
                } else if (t instanceof Number) {
                    parameterValue.setValue(((Number)t).doubleValue(), unit);
                } else if (t instanceof double[]) {
                    parameterValue.setValue((double[])t, unit);
                } else if (t != parameterValue.getValue()) {
                    throw new InvalidParameterValueException(Errors.format((short)45, string, t), string, t);
                }
            }
            hashMap.put(string, n2 + 1);
        }
    }

    private static GeneralParameterValue getOrCreate(ParameterValueGroup parameterValueGroup, String string, int n) {
        for (GeneralParameterValue generalParameterValue : parameterValueGroup.values()) {
            if (!string.equals(generalParameterValue.getDescriptor().getName().getCode()) || --n >= 0) continue;
            return generalParameterValue;
        }
        if (n == 0) {
            GeneralParameterValue generalParameterValue = parameterValueGroup.getDescriptor().descriptor(string).createValue();
            parameterValueGroup.values().add(generalParameterValue);
            return generalParameterValue;
        }
        throw new IndexOutOfBoundsException(string);
    }

    public String toString() {
        return ParameterFormat.sharedFormat(this);
    }

    public void print() {
        ParameterFormat.print(this);
    }

    private static final class Wrapper
    extends Parameters
    implements Serializable {
        private static final long serialVersionUID = -5491790565456920471L;
        private final ParameterValueGroup delegate;

        Wrapper(ParameterValueGroup parameterValueGroup) {
            this.delegate = parameterValueGroup;
        }

        @Override
        public ParameterDescriptorGroup getDescriptor() {
            return this.delegate.getDescriptor();
        }

        @Override
        public List<GeneralParameterValue> values() {
            return this.delegate.values();
        }

        @Override
        public ParameterValue<?> parameter(String string) {
            return this.delegate.parameter(string);
        }

        @Override
        public List<ParameterValueGroup> groups(String string) {
            return this.delegate.groups(string);
        }

        @Override
        public ParameterValueGroup addGroup(String string) {
            return this.delegate.addGroup(string);
        }

        @Override
        public Parameters clone() {
            return new Wrapper(this.delegate.clone());
        }
    }
}

