/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.quality;

import java.util.List;
import javax.measure.Unit;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.metadata.iso.quality.AbstractResult;
import org.opengis.metadata.quality.QuantitativeResult;
import org.opengis.util.InternationalString;
import org.opengis.util.Record;
import org.opengis.util.RecordType;

@XmlType(name="DQ_QuantitativeResult_Type", propOrder={"values", "valueType", "valueUnit", "errorStatistic"})
@XmlRootElement(name="DQ_QuantitativeResult")
public class DefaultQuantitativeResult
extends AbstractResult
implements QuantitativeResult {
    private static final long serialVersionUID = -403671810118461829L;
    private List<Record> values;
    private RecordType valueType;
    private Unit<?> valueUnit;
    @Deprecated
    private InternationalString errorStatistic;

    public DefaultQuantitativeResult() {
    }

    public DefaultQuantitativeResult(QuantitativeResult quantitativeResult) {
        super(quantitativeResult);
        if (quantitativeResult != null) {
            this.valueType = quantitativeResult.getValueType();
            this.valueUnit = quantitativeResult.getValueUnit();
            this.errorStatistic = quantitativeResult.getErrorStatistic();
            this.values = this.copyList(quantitativeResult.getValues(), Record.class);
        }
    }

    public static DefaultQuantitativeResult castOrCopy(QuantitativeResult quantitativeResult) {
        if (quantitativeResult == null || quantitativeResult instanceof DefaultQuantitativeResult) {
            return (DefaultQuantitativeResult)quantitativeResult;
        }
        return new DefaultQuantitativeResult(quantitativeResult);
    }

    @XmlElement(name="value", required=true)
    public List<Record> getValues() {
        this.values = this.nonNullList(this.values, Record.class);
        return this.values;
    }

    public void setValues(List<? extends Record> list) {
        this.values = this.writeList(list, this.values, Record.class);
    }

    @Override
    @XmlElement(name="valueRecordType")
    public RecordType getValueType() {
        RecordType recordType = this.valueType;
        if (recordType == null && this.values != null) {
            for (Record record : this.values) {
                if (record == null) continue;
                RecordType recordType2 = record.getRecordType();
                if (recordType2 == null) {
                    return null;
                }
                if (recordType == null) {
                    recordType = recordType2;
                    continue;
                }
                if (recordType == recordType2) continue;
                return null;
            }
        }
        return recordType;
    }

    public void setValueType(RecordType recordType) {
        this.checkWritePermission(this.valueType);
        this.valueType = recordType;
    }

    @Override
    @XmlElement(name="valueUnit")
    public Unit<?> getValueUnit() {
        return this.valueUnit;
    }

    public void setValueUnit(Unit<?> unit) {
        this.checkWritePermission(this.valueUnit);
        this.valueUnit = unit;
    }

    @Override
    @Deprecated
    @XmlElement(name="errorStatistic", namespace="http://www.isotc211.org/2005/gmd")
    public InternationalString getErrorStatistic() {
        return FilterByVersion.LEGACY_METADATA.accept() ? this.errorStatistic : null;
    }

    @Deprecated
    public void setErrorStatistic(InternationalString internationalString) {
        this.checkWritePermission(this.errorStatistic);
        this.errorStatistic = internationalString;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && this.errorStatistic == null;
    }
}

