/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.lineage;

import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.lineage.Algorithm;
import org.opengis.metadata.lineage.Processing;
import org.opengis.util.InternationalString;

@XmlType(name="LE_Processing_Type", propOrder={"identifier", "softwareReferences", "procedureDescription", "documentations", "runTimeParameters", "algorithms"})
@XmlRootElement(name="LE_Processing")
public class DefaultProcessing
extends ISOMetadata
implements Processing {
    private static final long serialVersionUID = 5698533358975632857L;
    private Collection<Citation> softwareReferences;
    private InternationalString procedureDescription;
    private Collection<Citation> documentations;
    private InternationalString runTimeParameters;
    private Collection<Algorithm> algorithms;

    public DefaultProcessing() {
    }

    public DefaultProcessing(Processing processing) {
        super(processing);
        if (processing != null) {
            this.identifiers = this.singleton(processing.getIdentifier(), Identifier.class);
            this.softwareReferences = this.copyCollection(processing.getSoftwareReferences(), Citation.class);
            this.procedureDescription = processing.getProcedureDescription();
            this.documentations = this.copyCollection(processing.getDocumentations(), Citation.class);
            this.runTimeParameters = processing.getRunTimeParameters();
            this.algorithms = this.copyCollection(processing.getAlgorithms(), Algorithm.class);
        }
    }

    public static DefaultProcessing castOrCopy(Processing processing) {
        if (processing == null || processing instanceof DefaultProcessing) {
            return (DefaultProcessing)processing;
        }
        return new DefaultProcessing(processing);
    }

    @Override
    @XmlElement(name="identifier", required=true)
    public Identifier getIdentifier() {
        return super.getIdentifier();
    }

    @Override
    public void setIdentifier(Identifier identifier) {
        super.setIdentifier(identifier);
    }

    @XmlElement(name="softwareReference")
    public Collection<Citation> getSoftwareReferences() {
        this.softwareReferences = this.nonNullCollection(this.softwareReferences, Citation.class);
        return this.softwareReferences;
    }

    public void setSoftwareReferences(Collection<? extends Citation> collection) {
        this.softwareReferences = this.writeCollection(collection, this.softwareReferences, Citation.class);
    }

    @Override
    @XmlElement(name="procedureDescription")
    public InternationalString getProcedureDescription() {
        return this.procedureDescription;
    }

    public void setProcedureDescription(InternationalString internationalString) {
        this.checkWritePermission(this.procedureDescription);
        this.procedureDescription = internationalString;
    }

    @XmlElement(name="documentation")
    public Collection<Citation> getDocumentations() {
        this.documentations = this.nonNullCollection(this.documentations, Citation.class);
        return this.documentations;
    }

    public void setDocumentations(Collection<? extends Citation> collection) {
        this.documentations = this.writeCollection(collection, this.documentations, Citation.class);
    }

    @Override
    @XmlElement(name="runTimeParameters")
    public InternationalString getRunTimeParameters() {
        return this.runTimeParameters;
    }

    public void setRunTimeParameters(InternationalString internationalString) {
        this.checkWritePermission(this.runTimeParameters);
        this.runTimeParameters = internationalString;
    }

    @XmlElement(name="algorithm")
    public Collection<Algorithm> getAlgorithms() {
        this.algorithms = this.nonNullCollection(this.algorithms, Algorithm.class);
        return this.algorithms;
    }

    public void setAlgorithms(Collection<? extends Algorithm> collection) {
        this.algorithms = this.writeCollection(collection, this.algorithms, Algorithm.class);
    }
}

