/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.extent;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.metadata.iso.DefaultIdentifier;
import org.apache.sis.metadata.iso.extent.AbstractGeographicExtent;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.iso.Types;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.GeographicDescription;
import org.opengis.util.InternationalString;

@XmlType(name="EX_GeographicDescription_Type")
@XmlRootElement(name="EX_GeographicDescription")
public class DefaultGeographicDescription
extends AbstractGeographicExtent
implements GeographicDescription {
    private static final long serialVersionUID = 7876194854687370299L;
    private Identifier geographicIdentifier;

    public DefaultGeographicDescription() {
    }

    public DefaultGeographicDescription(Citation citation, String string) {
        super(true);
        if (citation != null || string != null) {
            this.geographicIdentifier = new DefaultIdentifier(citation, string);
        }
    }

    public DefaultGeographicDescription(CharSequence charSequence) {
        super(true);
        if (charSequence != null) {
            DefaultIdentifier defaultIdentifier = new DefaultIdentifier();
            if (CharSequences.isUnicodeIdentifier(charSequence)) {
                defaultIdentifier.setCode(charSequence.toString());
                if (charSequence instanceof InternationalString) {
                    defaultIdentifier.setDescription((InternationalString)charSequence);
                }
            } else {
                defaultIdentifier.setCode(CharSequences.camelCaseToAcronym(charSequence).toString());
                defaultIdentifier.setDescription(Types.toInternationalString(charSequence));
            }
            this.geographicIdentifier = defaultIdentifier;
        }
    }

    public DefaultGeographicDescription(GeographicDescription geographicDescription) {
        super(geographicDescription);
        if (geographicDescription != null) {
            this.geographicIdentifier = geographicDescription.getGeographicIdentifier();
        }
    }

    public static DefaultGeographicDescription castOrCopy(GeographicDescription geographicDescription) {
        if (geographicDescription == null || geographicDescription instanceof DefaultGeographicDescription) {
            return (DefaultGeographicDescription)geographicDescription;
        }
        return new DefaultGeographicDescription(geographicDescription);
    }

    @Override
    @XmlElement(name="geographicIdentifier", required=true)
    public Identifier getGeographicIdentifier() {
        return this.geographicIdentifier;
    }

    public void setGeographicIdentifier(Identifier identifier) {
        this.checkWritePermission(this.geographicIdentifier);
        this.geographicIdentifier = identifier;
    }
}

