/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.internal.netcdf.Convention;
import org.apache.sis.internal.netcdf.Dimension;
import org.apache.sis.internal.netcdf.Variable;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArraysExt;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;

public final class GridAdjustment {
    private double[] gridToDataIndices;
    final Map<Dimension, Dimension> gridToVariable = new HashMap<Dimension, Dimension>();

    GridAdjustment() {
    }

    boolean mapLabelToGridDimensions(Variable variable, List<Variable> list, Map<Object, Dimension> map, Convention convention) {
        HashSet<Dimension> hashSet = new HashSet<Dimension>();
        String[] stringArray = convention.namesOfAxisVariables(variable);
        for (Variable variable2 : list) {
            boolean bl = ArraysExt.containsIgnoreCase(stringArray, variable2.getName());
            List<Dimension> list2 = variable2.getGridDimensions();
            int n = list2.size();
            while (--n >= 0) {
                boolean bl2;
                String string;
                Dimension dimension = list2.get(n);
                if (!map.containsKey(dimension) || (string = convention.nameOfDimension(variable2, n)) == null) continue;
                if (this.gridToDataIndices == null) {
                    this.gridToDataIndices = new double[list.size()];
                }
                this.gridToDataIndices[n] = convention.gridToDataIndices(variable2);
                boolean bl3 = bl2 = bl && hashSet.add(dimension);
                Dimension dimension2 = map.put(string, dimension);
                if (dimension2 == null || dimension2.equals(dimension) || bl2) continue;
                if (!bl && hashSet.contains(dimension)) {
                    map.put(string, dimension2);
                    continue;
                }
                variable.error(Variable.class, "getGridGeometry", null, (short)25, string);
                return true;
            }
        }
        return false;
    }

    final double[] dataToGridIndices() {
        double[] dArray = null;
        if (this.gridToDataIndices != null) {
            int n = this.gridToDataIndices.length;
            while (--n >= 0) {
                double d = this.gridToDataIndices[n];
                if (d > 0.0 && d != Double.POSITIVE_INFINITY) {
                    if (dArray == null) {
                        dArray = new double[n + 1];
                    }
                    dArray[n] = 1.0 / d;
                    continue;
                }
                dArray = null;
            }
        }
        return dArray;
    }

    static GridGeometry scale(GridGeometry gridGeometry, GridExtent gridExtent, PixelInCell pixelInCell, double[] dArray) {
        MathTransform mathTransform = gridGeometry.getGridToCRS(pixelInCell);
        LinearTransform linearTransform = MathTransforms.scale(dArray);
        mathTransform = MathTransforms.concatenate(linearTransform, mathTransform);
        return new GridGeometry(gridExtent, pixelInCell, mathTransform, gridGeometry.isDefined(1) ? gridGeometry.getCoordinateReferenceSystem() : null);
    }
}

