/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.metadata.legacy;

import java.time.Instant;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

public final class TemporalToDate
extends AbstractCollection<Date> {
    private final Collection<? extends Temporal> source;

    public TemporalToDate(Collection<? extends Temporal> collection) {
        this.source = collection;
    }

    @Override
    public int size() {
        return this.source.size();
    }

    @Override
    public Iterator<Date> iterator() {
        final Iterator<? extends Temporal> iterator = this.source.iterator();
        return new Iterator<Date>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Date next() {
                Temporal temporal = (Temporal)iterator.next();
                if (temporal == null) {
                    return null;
                }
                if (temporal instanceof Instant) {
                    return Date.from((Instant)temporal);
                }
                return new Date(Math.multiplyExact(temporal.getLong(ChronoField.INSTANT_SECONDS), 1000L));
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }
}

