/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.metadata.replace;

import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.sis.internal.jaxb.gco.GO_GenericName;
import org.apache.sis.internal.jaxb.metadata.replace.Parameter;
import org.apache.sis.internal.jaxb.metadata.replace.RS_Identifier;
import org.apache.sis.internal.metadata.ReferencingServices;
import org.apache.sis.metadata.ModifiableMetadata;
import org.apache.sis.metadata.iso.quality.DefaultMeasureDescription;
import org.apache.sis.util.Classes;
import org.apache.sis.util.iso.Names;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.Matrix;
import org.opengis.util.InternationalString;
import org.opengis.util.TypeName;

@XmlType(name="DQM_Parameter_Type", namespace="http://standards.iso.org/iso/19157/-2/dqm/1.0", propOrder={"code", "definition", "description", "valueType"})
@XmlRootElement(name="DQM_Parameter", namespace="http://standards.iso.org/iso/19157/-2/dqm/1.0")
public final class QualityParameter
extends Parameter {
    @XmlElement(name="name", required=true)
    String code;
    @XmlElement(required=true)
    InternationalString definition;
    @XmlElement
    DefaultMeasureDescription description;
    @XmlElement(required=true)
    @XmlJavaTypeAdapter(value=GO_GenericName.class)
    TypeName valueType;

    QualityParameter() {
    }

    private QualityParameter(ParameterDescriptor<?> parameterDescriptor) {
        super(parameterDescriptor);
        ReferenceIdentifier referenceIdentifier = parameterDescriptor.getName();
        if (referenceIdentifier != null) {
            this.code = referenceIdentifier.getCode();
        }
        this.valueType = ReferencingServices.getInstance().getValueType(parameterDescriptor);
    }

    public static QualityParameter castOrCopy(ParameterDescriptor<?> parameterDescriptor) {
        if (parameterDescriptor == null || parameterDescriptor instanceof QualityParameter) {
            return (QualityParameter)parameterDescriptor;
        }
        return new QualityParameter(parameterDescriptor);
    }

    @Override
    public int getMinimumOccurs() {
        return 0;
    }

    @Override
    public int getMaximumOccurs() {
        return 1;
    }

    @Override
    public synchronized ReferenceIdentifier getName() {
        if (this.name == null && this.code != null) {
            RS_Identifier rS_Identifier = new RS_Identifier(null, this.code, null);
            rS_Identifier.setDescription(this.definition);
            rS_Identifier.transitionTo(ModifiableMetadata.State.FINAL);
            this.name = rS_Identifier;
        }
        return this.name;
    }

    @Override
    public Class<?> getValueClass() {
        Class<Object> clazz = super.getValueClass();
        if (clazz == null) {
            clazz = Names.toClass(this.valueType);
        }
        return clazz;
    }

    @Override
    public TypeName getValueType() {
        return this.valueType;
    }

    public static TypeName getValueType(Class<?> clazz) {
        if (clazz.isArray()) {
            clazz = clazz.getComponentType();
        } else if (Iterable.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz)) {
            clazz = Classes.boundOfParameterizedDeclaration(clazz);
        } else if (Matrix.class.isAssignableFrom(clazz)) {
            clazz = Double.class;
        }
        return Names.createTypeName(clazz);
    }
}

