/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Objects;
import org.apache.sis.geometry.AbstractDirectPosition;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GeneralDirectPosition
extends AbstractDirectPosition
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -1775358214919832302L;
    private static volatile Field coordinatesField;
    public final double[] coordinates;
    private CoordinateReferenceSystem crs;

    public GeneralDirectPosition(CoordinateReferenceSystem coordinateReferenceSystem) {
        this(coordinateReferenceSystem.getCoordinateSystem().getDimension());
        this.crs = coordinateReferenceSystem;
    }

    public GeneralDirectPosition(int n) throws NegativeArraySizeException {
        this.coordinates = new double[n];
    }

    public GeneralDirectPosition(double ... dArray) {
        this.coordinates = dArray;
    }

    public GeneralDirectPosition(DirectPosition directPosition) {
        this.coordinates = directPosition.getCoordinate();
        this.crs = directPosition.getCoordinateReferenceSystem();
        ArgumentChecks.ensureDimensionMatches("crs", this.coordinates.length, this.crs);
    }

    public GeneralDirectPosition(CharSequence charSequence) throws IllegalArgumentException {
        this.coordinates = GeneralDirectPosition.parse(charSequence);
        if (this.coordinates == null) {
            throw new IllegalArgumentException(Errors.format((short)154, "POINT", charSequence));
        }
    }

    @Override
    public final int getDimension() {
        return this.coordinates.length;
    }

    @Override
    public final CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem coordinateReferenceSystem) throws MismatchedDimensionException {
        ArgumentChecks.ensureDimensionMatches("crs", this.getDimension(), coordinateReferenceSystem);
        this.crs = coordinateReferenceSystem;
    }

    @Override
    public final double[] getCoordinate() {
        return (double[])this.coordinates.clone();
    }

    public void setCoordinate(double ... dArray) throws MismatchedDimensionException {
        if (dArray == null) {
            Arrays.fill(this.coordinates, Double.NaN);
        } else {
            ArgumentChecks.ensureDimensionMatches("coordinates", this.coordinates.length, dArray);
            System.arraycopy(dArray, 0, this.coordinates, 0, dArray.length);
        }
    }

    @Override
    public final double getOrdinate(int n) throws IndexOutOfBoundsException {
        return this.coordinates[n];
    }

    @Override
    public void setOrdinate(int n, double d) throws IndexOutOfBoundsException {
        this.coordinates[n] = d;
    }

    @Override
    public void setLocation(DirectPosition directPosition) throws MismatchedDimensionException {
        if (directPosition == null) {
            Arrays.fill(this.coordinates, Double.NaN);
        } else {
            ArgumentChecks.ensureDimensionMatches("position", this.coordinates.length, directPosition);
            this.setCoordinateReferenceSystem(directPosition.getCoordinateReferenceSystem());
            for (int i = 0; i < this.coordinates.length; ++i) {
                this.coordinates[i] = directPosition.getOrdinate(i);
            }
        }
    }

    @Override
    public String toString() {
        return GeneralDirectPosition.toString(this, ArraysExt.isSinglePrecision(this.coordinates));
    }

    static Field getCoordinatesField(Class<?> clazz) throws NoSuchFieldException {
        Field field = clazz.getDeclaredField("coordinates");
        field.setAccessible(true);
        return field;
    }

    public GeneralDirectPosition clone() {
        try {
            Field field = coordinatesField;
            if (field == null) {
                coordinatesField = field = GeneralDirectPosition.getCoordinatesField(GeneralDirectPosition.class);
            }
            GeneralDirectPosition generalDirectPosition = (GeneralDirectPosition)super.clone();
            field.set(generalDirectPosition, this.coordinates.clone());
            return generalDirectPosition;
        }
        catch (CloneNotSupportedException | ReflectiveOperationException exception) {
            throw new AssertionError((Object)exception);
        }
    }

    @Override
    public int hashCode() {
        int n = Arrays.hashCode(this.coordinates) + Objects.hashCode(this.getCoordinateReferenceSystem());
        assert (n == super.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof GeneralDirectPosition) {
            GeneralDirectPosition generalDirectPosition = (GeneralDirectPosition)object;
            return Arrays.equals(this.coordinates, generalDirectPosition.coordinates) && Objects.equals(this.crs, generalDirectPosition.crs);
        }
        return super.equals(object);
    }
}

