/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter;

import java.util.Arrays;
import java.util.List;
import javax.measure.IncommensurableException;
import javax.measure.Unit;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.Filter;
import org.apache.sis.filter.FilterNode;
import org.apache.sis.filter.LeafExpression;
import org.apache.sis.filter.Optimization;
import org.apache.sis.internal.feature.AttributeConvention;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.feature.GeometryWrapper;
import org.apache.sis.internal.feature.SpatialOperationContext;
import org.apache.sis.internal.geoapi.filter.Literal;
import org.apache.sis.internal.geoapi.filter.ValueReference;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

abstract class BinaryGeometryFilter<R, G>
extends FilterNode<R>
implements Optimization.OnFilter<R> {
    private static final long serialVersionUID = -7205680763469213064L;
    protected final Expression<? super R, GeometryWrapper<G>> expression1;
    protected final Expression<? super R, GeometryWrapper<G>> expression2;
    protected final SpatialOperationContext context;

    protected BinaryGeometryFilter(Geometries<G> geometries, Expression<? super R, ?> expression, Expression<? super R, ?> expression2, Unit<?> unit) {
        int n;
        GeometryWrapper<G> geometryWrapper;
        Literal literal;
        ArgumentChecks.ensureNonNull("expression1", expression);
        ArgumentChecks.ensureNonNull("expression2", expression2);
        Expression<Object, GeometryWrapper<G>> expression3 = BinaryGeometryFilter.toGeometryWrapper(geometries, expression);
        Expression<Object, GeometryWrapper<G>> expression4 = BinaryGeometryFilter.toGeometryWrapper(geometries, expression2);
        if (expression2 instanceof Literal) {
            literal = (Literal)expression2;
            geometryWrapper = expression4.apply((Object)null);
            n = 1;
        } else if (expression instanceof Literal) {
            literal = (Literal)expression;
            geometryWrapper = expression3.apply((Object)null);
            n = 0;
        } else {
            literal = null;
            geometryWrapper = null;
            n = -1;
        }
        try {
            GeometryWrapper<G> geometryWrapper2;
            this.context = new SpatialOperationContext(null, geometryWrapper, unit, n);
            if (geometryWrapper != null && (geometryWrapper2 = this.context.transform(geometryWrapper)) != geometryWrapper) {
                LeafExpression.Transformed<? super R, GeometryWrapper<G>> transformed = new LeafExpression.Transformed<R, GeometryWrapper<G>>(geometryWrapper2, literal);
                switch (n) {
                    case 0: {
                        expression3 = transformed;
                        break;
                    }
                    case 1: {
                        expression4 = transformed;
                        break;
                    }
                    default: {
                        throw new AssertionError(n);
                    }
                }
            }
        }
        catch (IncommensurableException | TransformException | FactoryException exception) {
            throw new IllegalArgumentException(exception);
        }
        this.expression1 = expression3;
        this.expression2 = expression4;
    }

    protected abstract BinaryGeometryFilter<R, G> recreate(Expression<? super R, ?> var1, Expression<? super R, ?> var2);

    protected static <R, G> Expression<? super R, ?> original(Expression<R, GeometryWrapper<G>> expression) {
        Expression<R, ?> expression2 = BinaryGeometryFilter.unwrap(expression);
        if (expression2 instanceof LeafExpression.Transformed) {
            expression2 = ((LeafExpression.Transformed)expression2).original;
        }
        return expression2;
    }

    @Override
    public List<Expression<? super R, ?>> getExpressions() {
        return Arrays.asList(BinaryGeometryFilter.original(this.expression1), BinaryGeometryFilter.original(this.expression2));
    }

    @Override
    public final Filter<? super R> optimize(Optimization optimization) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        Literal literal;
        Expression<Object, GeometryWrapper<G>> expression;
        Literal literal2;
        Expression<? super R, ?> expression2 = BinaryGeometryFilter.unwrap(this.expression1);
        Expression<? super R, ?> expression3 = BinaryGeometryFilter.unwrap(this.expression2);
        Literal literal3 = optimization.apply(expression2);
        Literal literal4 = optimization.apply(expression3);
        if (literal4 instanceof Literal) {
            literal2 = literal3;
            expression = this.expression2;
            literal = literal4;
            bl3 = literal3 instanceof Literal;
        } else if (literal3 instanceof Literal) {
            literal2 = literal4;
            expression = this.expression1;
            literal = literal3;
            bl3 = false;
        } else {
            return this;
        }
        boolean bl4 = bl2 = literal.getValue() == null;
        if (bl2) {
            bl = this.negativeResult();
        } else {
            Object object;
            DefaultFeatureType defaultFeatureType = optimization.getFeatureType();
            if (defaultFeatureType != null && literal2 instanceof ValueReference) {
                try {
                    GeometryWrapper<G> geometryWrapper;
                    GeometryWrapper<G> geometryWrapper2;
                    object = AttributeConvention.getCRSCharacteristic(defaultFeatureType, defaultFeatureType.getProperty(((ValueReference)((Object)literal2)).getXPath()));
                    if (object != null && (geometryWrapper2 = expression.apply((Object)null)) != (geometryWrapper = geometryWrapper2.transform((CoordinateReferenceSystem)object))) {
                        literal = (Literal)Optimization.literal(geometryWrapper);
                        if (literal == literal3) {
                            literal3 = literal;
                        } else {
                            literal4 = literal;
                        }
                    }
                }
                catch (IllegalArgumentException | TransformException exception) {
                    this.warning(exception, true);
                }
            }
            object = this;
            if (literal3 != expression2 || literal4 != expression3) {
                object = this.recreate(literal3, literal4);
            }
            if (!bl3) {
                return object;
            }
            bl = object.test(null);
        }
        return bl ? Filter.include() : Filter.exclude();
    }

    protected abstract boolean negativeResult();
}

