/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.util;

import com.mchange.v2.c3p0.AbstractConnectionTester;
import com.mchange.v2.c3p0.impl.DefaultConnectionTester;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import java.sql.Connection;
import java.sql.SQLException;

public abstract class IsValidOnlyConnectionTester
extends AbstractConnectionTester {
    static final MLogger logger = MLog.getLogger(IsValidOnlyConnectionTester.class);
    volatile boolean warned = false;

    private void checkWarn(String string) {
        if (string != null && !this.warned) {
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "preferredTestQuery or automaticTestTable has been set, which " + this.getClass().getSimpleName() + " does not support. preferredTestQuery and/or automaticTestTable will be ignored.");
            }
            this.warned = true;
        }
    }

    protected abstract int getIsValidTimeout();

    @Override
    public int activeCheckConnection(Connection connection, String string, Throwable[] throwableArray) {
        this.checkWarn(string);
        try {
            int n = this.getIsValidTimeout();
            boolean bl = connection.isValid(n);
            if (bl) {
                return 0;
            }
            if (throwableArray != null) {
                throwableArray[0] = new SQLException("Connection.isValid(" + n + ") returned false.");
            }
            return -1;
        }
        catch (SQLException sQLException) {
            if (throwableArray != null) {
                throwableArray[0] = sQLException;
            }
            boolean bl = DefaultConnectionTester.probableInvalidDb(sQLException);
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "SQL State '" + sQLException.getSQLState() + "' of Exception tested by activeCheckConnection(...) implies that the database is invalid, and the pool should refill itself with fresh Connections.", sQLException);
            }
            return bl ? -8 : -1;
        }
        catch (Exception exception) {
            if (throwableArray != null) {
                throwableArray[0] = exception;
            }
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "Unexpected non-SQLException thrown in Connection test. Reporting Connection invalid.", exception);
            }
            return -1;
        }
    }

    @Override
    public int statusOnException(Connection connection, Throwable throwable, String string, Throwable[] throwableArray) {
        this.checkWarn(string);
        try {
            if (throwable instanceof SQLException) {
                if (DefaultConnectionTester.probableInvalidDb((SQLException)throwable)) {
                    if (logger.isLoggable(MLevel.WARNING)) {
                        logger.log(MLevel.WARNING, "SQL State of SQLException tested by statusOnException() implies that the database is invalid, and the pool should refill itself with fresh Connections.", throwable);
                    }
                    return -8;
                }
                return this.activeCheckConnection(connection, string, throwableArray);
            }
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Connection test failed because test-provoking Throwable is an unexpected, non-SQLException.", throwable);
            }
            if (throwableArray != null) {
                throwableArray[0] = throwable;
            }
            return -1;
        }
        catch (Exception exception) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Connection " + connection + " failed Connection test with an Exception!", exception);
            }
            if (throwableArray != null) {
                throwableArray[0] = exception;
            }
            return -1;
        }
    }
}

