/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util.reflect;

import java.io.PrintStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import ucar.nc2.dt.grid.GeoGrid;

public class PublicInterfaceGenerator {
    static void generate(Class c, boolean doAllMethods, PrintStream out) throws SecurityException {
        Class sc = c.getSuperclass();
        out.print("public class " + PublicInterfaceGenerator.makeClassName(c));
        if (sc != Object.class) {
            out.print(" extends " + PublicInterfaceGenerator.makeClassName(sc));
        }
        out.println(" {");
        ArrayList allMethods = new ArrayList();
        PublicInterfaceGenerator.addAllMethods(allMethods, c, doAllMethods);
        Collections.sort(allMethods, new MethodComparator());
        for (int i = 0; i < allMethods.size(); ++i) {
            PublicInterfaceGenerator.genMethod((Method)allMethods.get(i), out);
        }
        out.println("}");
    }

    private static void addAllMethods(ArrayList allMethods, Class c, boolean doAllMethods) {
        if (c == null) {
            return;
        }
        if (c == Object.class) {
            return;
        }
        Method[] methodsArray = doAllMethods ? c.getMethods() : c.getDeclaredMethods();
        allMethods.addAll(Arrays.asList(methodsArray));
    }

    static void genMethod(Method m4, PrintStream out) throws SecurityException {
        int mods = m4.getModifiers();
        if (Modifier.isPrivate(mods) || Modifier.isProtected(mods)) {
            return;
        }
        out.print("  " + Modifier.toString(mods));
        out.print(" " + PublicInterfaceGenerator.makeClassName(m4.getReturnType()));
        out.print(" " + m4.getName() + "(");
        Class<?>[] params = m4.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                out.print(", ");
            }
            out.print(PublicInterfaceGenerator.makeClassName(params[i]) + " p" + i);
        }
        out.print(")");
        Class<?>[] ex = m4.getExceptionTypes();
        if (ex.length > 0) {
            out.print(" throws ");
            for (int i = 0; i < ex.length; ++i) {
                if (i > 0) {
                    out.print(", ");
                }
                out.print(ex[i].getName());
            }
        }
        out.println(";");
    }

    static String makeClassName(Class c) {
        if (c.isArray()) {
            return PublicInterfaceGenerator.makeClassName(c.getComponentType()) + "[]";
        }
        String name = c.getName();
        Package p = c.getPackage();
        if (p == null) {
            return name;
        }
        String packageName = p.getName();
        return name.substring(packageName.length() + 1);
    }

    public static void showMethods(Class c, PrintStream out) {
        out.println("Methods for class " + c.getName());
        Method[] methodsArray = c.getDeclaredMethods();
        for (int i = 0; i < methodsArray.length; ++i) {
            Method m4 = methodsArray[i];
            System.out.println(" " + m4.getName());
        }
    }

    public static void main(String[] args) throws SecurityException {
        PublicInterfaceGenerator.generate(GeoGrid.class, false, System.out);
    }

    public static class MethodComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Method t1 = (Method)o1;
            Method t2 = (Method)o2;
            return t1.getName().compareTo(t2.getName());
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this;
        }
    }
}

