/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp;

import java.io.IOException;
import ucar.unidata.io.RandomAccessFile;

public class BitReader {
    private static final int BIT_LENGTH = 8;
    private static final int BYTE_BITMASK = 255;
    private static final long LONG_BITMASK = Long.MAX_VALUE;
    private RandomAccessFile raf = null;
    private long startPos;
    private byte[] data;
    private int dataPos;
    private byte bitBuf = 0;
    private int bitPos = 0;

    public BitReader(byte[] test) {
        this.data = test;
        this.dataPos = 0;
    }

    public BitReader(RandomAccessFile raf, long startPos) throws IOException {
        this.raf = raf;
        this.startPos = startPos;
        raf.seek(startPos);
    }

    public void incrByte() {
        this.bitPos = 0;
    }

    public void setBitOffset(int bitOffset) throws IOException {
        if (bitOffset % 8 == 0) {
            this.raf.seek(this.startPos + (long)(bitOffset / 8));
            this.bitPos = 0;
            this.bitBuf = 0;
        } else {
            this.raf.seek(this.startPos + (long)(bitOffset / 8));
            this.bitPos = 8 - bitOffset % 8;
            this.bitBuf = (byte)this.raf.read();
            this.bitBuf = (byte)(this.bitBuf & 255 >> 8 - this.bitPos);
        }
    }

    public long getPos() throws IOException {
        if (this.raf != null) {
            return this.raf.getFilePointer();
        }
        return this.dataPos;
    }

    public long bits2UInt(int nb) throws IOException {
        assert (nb <= 64);
        assert (nb >= 0);
        long result = 0L;
        int bitsLeft = nb;
        while (bitsLeft > 0) {
            if (this.bitPos == 0) {
                this.bitBuf = this.nextByte();
                this.bitPos = 8;
            }
            int size = Math.min(bitsLeft, this.bitPos);
            int myBits = this.bitBuf >> this.bitPos - size;
            myBits &= 0xFF;
            myBits &= ~(255 << size);
            int shift = bitsLeft - size;
            assert (shift >= 0);
            result |= (long)(myBits << shift);
            bitsLeft -= size;
            this.bitPos -= size;
        }
        return result;
    }

    public long bits2SInt(int nb) throws IOException {
        long result = this.bits2UInt(nb);
        if (BitReader.getBit(result, nb)) {
            result = BitReader.setBit(result, nb, false);
            result = (result ^ 0xFFFFFFFFFFFFFFFFL) & Long.MAX_VALUE;
            ++result;
        }
        return result;
    }

    private byte nextByte() throws IOException {
        if (this.raf != null) {
            return (byte)this.raf.read();
        }
        return this.data[this.dataPos++];
    }

    public static long setBit(long decimal, int N2, boolean value) {
        return value ? decimal | (long)(1 << N2 - 1) : decimal & (long)(~(1 << N2 - 1));
    }

    public static boolean getBit(long decimal, int N2) {
        int constant = 1 << N2 - 1;
        return (decimal & (long)constant) > 0L;
    }
}

