/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArrayStructure;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;
import ucar.nc2.CDMNode;
import ucar.nc2.Dimension;
import ucar.nc2.EnumTypedef;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.ProxyReader;
import ucar.nc2.ReduceReader;
import ucar.nc2.SectionReader;
import ucar.nc2.SliceReader;
import ucar.nc2.Structure;
import ucar.nc2.VariableIF;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.iosp.IospHelper;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.Indent;
import ucar.nc2.util.rc.RC;

public class Variable
extends CDMNode
implements VariableIF,
ProxyReader,
AttributeContainer {
    public static final int defaultSizeToCache = 4000;
    public static final int defaultCoordsSizeToCache = 40000;
    protected static boolean debugCaching = false;
    private static Logger log = LoggerFactory.getLogger(Variable.class);
    protected NetcdfFile ncfile;
    protected int[] shape = new int[0];
    protected Section shapeAsSection;
    protected DataType dataType;
    protected int elementSize;
    protected List<Dimension> dimensions = new ArrayList<Dimension>(5);
    protected List<Attribute> attributes = new ArrayList<Attribute>();
    protected boolean isVariableLength = false;
    protected boolean isMetadata = false;
    protected Cache cache = new Cache();
    protected int sizeToCache = -1;
    protected ProxyReader proxyReader = this;
    private EnumTypedef enumTypedef;
    private static boolean showSize = false;
    protected int hashCode = 0;
    protected Object spiObject;

    public static String getDAPName(String name, Variable context) {
        Group xg;
        if (RC.getUseGroups() && !(xg = context.getParentGroup()).isRoot()) {
            List<Group> path = Group.collectPath(xg);
            Formatter dapname = new Formatter();
            for (int i = 1; i < path.size(); ++i) {
                Group g2 = path.get(i);
                dapname.format("/%s", g2.getShortName());
            }
            dapname.format("/%s", name);
            name = dapname.toString();
        }
        return name;
    }

    public static String getDAPName(Variable v) {
        return Variable.getDAPName(v.getShortName(), v);
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public int[] getShape() {
        int[] result = new int[this.shape.length];
        System.arraycopy(this.shape, 0, result, 0, this.shape.length);
        return result;
    }

    public int getShape(int index) {
        return this.shape[index];
    }

    @Override
    public long getSize() {
        long size = 1L;
        for (int aShape : this.shape) {
            if (aShape < 0) continue;
            size *= (long)aShape;
        }
        return size;
    }

    @Override
    public int getElementSize() {
        return this.elementSize;
    }

    @Override
    public int getRank() {
        return this.shape.length;
    }

    @Override
    public Group getParentGroup() {
        Group g2 = super.getParentGroup();
        if (g2 == null) {
            g2 = this.ncfile.getRootGroup();
            super.setParentGroup(g2);
        }
        assert (g2 != null);
        return g2;
    }

    @Override
    public boolean isMetadata() {
        return this.isMetadata;
    }

    @Override
    public boolean isScalar() {
        return this.getRank() == 0;
    }

    @Override
    public boolean isVariableLength() {
        return this.isVariableLength;
    }

    @Override
    public boolean isUnsigned() {
        Attribute att = this.findAttributeIgnoreCase("_Unsigned");
        return att != null && att.getStringValue().equalsIgnoreCase("true");
    }

    public void setUnsigned(boolean b) {
        Attribute att = this.findAttributeIgnoreCase("_Unsigned");
        if (att == null && !b) {
            return;
        }
        att = new Attribute("_Unsigned", b ? "true" : "false");
        this.addAttribute(att);
    }

    @Override
    public boolean isUnlimited() {
        for (Dimension d : this.dimensions) {
            if (!d.isUnlimited()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Dimension> getDimensions() {
        return this.dimensions;
    }

    @Override
    public Dimension getDimension(int i) {
        if (i < 0 || i >= this.getRank()) {
            return null;
        }
        return this.dimensions.get(i);
    }

    public String getDimensionsString() {
        return Dimension.makeDimensionsString(this.dimensions);
    }

    @Override
    public int findDimensionIndex(String name) {
        for (int i = 0; i < this.dimensions.size(); ++i) {
            Dimension d = this.dimensions.get(i);
            if (!name.equals(d.getShortName())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public List<Attribute> getAttributes() {
        return this.immutable ? this.attributes : Collections.unmodifiableList(this.attributes);
    }

    @Override
    public Attribute findAttribute(String name) {
        for (Attribute a : this.attributes) {
            if (!name.equals(a.getShortName())) continue;
            return a;
        }
        return null;
    }

    @Override
    public Attribute findAttributeIgnoreCase(String name) {
        for (Attribute a : this.attributes) {
            if (!name.equalsIgnoreCase(a.getShortName())) continue;
            return a;
        }
        return null;
    }

    @Override
    public String getDescription() {
        String desc = null;
        Attribute att = this.findAttributeIgnoreCase("long_name");
        if (att != null && att.isString()) {
            desc = att.getStringValue();
        }
        if (desc == null && (att = this.findAttributeIgnoreCase("description")) != null && att.isString()) {
            desc = att.getStringValue();
        }
        if (desc == null && (att = this.findAttributeIgnoreCase("title")) != null && att.isString()) {
            desc = att.getStringValue();
        }
        if (desc == null && (att = this.findAttributeIgnoreCase("standard_name")) != null && att.isString()) {
            desc = att.getStringValue();
        }
        return desc;
    }

    @Override
    public String getUnitsString() {
        String units = null;
        Attribute att = this.findAttribute("units");
        if (att == null) {
            att = this.findAttributeIgnoreCase("units");
        }
        if (att != null && att.isString() && (units = att.getStringValue()) != null) {
            units = units.trim();
        }
        return units;
    }

    @Override
    public List<Range> getRanges() {
        return this.getShapeAsSection().getRanges();
    }

    @Override
    public Section getShapeAsSection() {
        if (this.shapeAsSection == null) {
            try {
                ArrayList<Range> list = new ArrayList<Range>();
                for (Dimension d : this.dimensions) {
                    int len = d.getLength();
                    if (len > 0) {
                        list.add(new Range(d.getShortName(), 0, len - 1));
                        continue;
                    }
                    if (len == 0) {
                        list.add(Range.EMPTY);
                        continue;
                    }
                    assert (d.isVariableLength());
                    list.add(Range.VLEN);
                }
                this.shapeAsSection = new Section(list).makeImmutable();
            }
            catch (InvalidRangeException e) {
                log.error("Bad shape in variable " + this.getFullName(), e);
                throw new IllegalStateException(e.getMessage());
            }
        }
        return this.shapeAsSection;
    }

    public ProxyReader getProxyReader() {
        return this.proxyReader;
    }

    public void setProxyReader(ProxyReader proxyReader) {
        this.proxyReader = proxyReader;
    }

    @Override
    public Variable section(List<Range> ranges) throws InvalidRangeException {
        return this.section(new Section(ranges, this.shape).makeImmutable());
    }

    public Variable section(Section subsection) throws InvalidRangeException {
        subsection = Section.fill(subsection, this.shape);
        Variable sectionV = this.copy();
        sectionV.setProxyReader(new SectionReader(this, subsection));
        sectionV.shape = subsection.getShape();
        sectionV.createNewCache();
        sectionV.setCaching(false);
        sectionV.dimensions = new ArrayList<Dimension>();
        for (int i = 0; i < this.getRank(); ++i) {
            Dimension oldD = this.getDimension(i);
            Dimension newD = oldD.getLength() == sectionV.shape[i] ? oldD : new Dimension(oldD.getShortName(), sectionV.shape[i], false);
            newD.setUnlimited(oldD.isUnlimited());
            sectionV.dimensions.add(newD);
        }
        sectionV.resetShape();
        return sectionV;
    }

    public Variable slice(int dim, int value) throws InvalidRangeException {
        if (dim < 0 || dim >= this.shape.length) {
            throw new InvalidRangeException("Slice dim invalid= " + dim);
        }
        boolean recordSliceOk = false;
        if (dim == 0 && value == 0) {
            Dimension d = this.getDimension(0);
            recordSliceOk = d.isUnlimited();
        }
        if (!(recordSliceOk || value >= 0 && value < this.shape[dim])) {
            throw new InvalidRangeException("Slice value invalid= " + value + " for dimension " + dim);
        }
        Variable sliceV = this.copy();
        Section slice = new Section(this.getShapeAsSection());
        slice.replaceRange(dim, new Range(value, value)).makeImmutable();
        sliceV.setProxyReader(new SliceReader(this, dim, slice));
        sliceV.createNewCache();
        sliceV.setCaching(false);
        sliceV.dimensions.remove(dim);
        sliceV.resetShape();
        return sliceV;
    }

    public Variable reduce(List<Dimension> dims) throws InvalidRangeException {
        ArrayList<Integer> dimIdx = new ArrayList<Integer>(dims.size());
        for (Dimension d : dims) {
            assert (this.dimensions.contains(d));
            assert (d.getLength() == 1);
            dimIdx.add(this.dimensions.indexOf(d));
        }
        Variable sliceV = this.copy();
        sliceV.setProxyReader(new ReduceReader(this, dimIdx));
        sliceV.createNewCache();
        sliceV.setCaching(false);
        for (Dimension d : dims) {
            sliceV.dimensions.remove(d);
        }
        sliceV.resetShape();
        return sliceV;
    }

    protected Variable copy() {
        return new Variable(this);
    }

    protected NetcdfFile getNetcdfFile() {
        return this.ncfile;
    }

    public String lookupEnumString(int val) {
        if (!this.dataType.isEnum()) {
            throw new UnsupportedOperationException("Can only call Variable.lookupEnumVal() on enum types");
        }
        return this.enumTypedef.lookupEnumString(val);
    }

    public void setEnumTypedef(EnumTypedef enumTypedef) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        if (!this.dataType.isEnum()) {
            throw new UnsupportedOperationException("Can only call Variable.setEnumTypedef() on enum types");
        }
        this.enumTypedef = enumTypedef;
    }

    @Override
    public EnumTypedef getEnumTypedef() {
        return this.enumTypedef;
    }

    @Override
    public Array read(int[] origin, int[] shape) throws IOException, InvalidRangeException {
        if (origin == null && shape == null) {
            return this.read();
        }
        if (origin == null) {
            return this.read(new Section(shape));
        }
        if (shape == null) {
            return this.read(new Section(origin, this.shape));
        }
        return this.read(new Section(origin, shape));
    }

    @Override
    public Array read(String sectionSpec) throws IOException, InvalidRangeException {
        return this.read(new Section(sectionSpec));
    }

    public Array read(List<Range> ranges) throws IOException, InvalidRangeException {
        if (null == ranges) {
            return this._read();
        }
        return this.read(new Section(ranges));
    }

    @Override
    public Array read(Section section) throws IOException, InvalidRangeException {
        return section == null ? this._read() : this._read(Section.fill(section, this.shape));
    }

    @Override
    public Array read() throws IOException {
        return this._read();
    }

    @Override
    public byte readScalarByte() throws IOException {
        Array data = this.getScalarData();
        return data.getByte(Index.scalarIndexImmutable);
    }

    @Override
    public short readScalarShort() throws IOException {
        Array data = this.getScalarData();
        return data.getShort(Index.scalarIndexImmutable);
    }

    @Override
    public int readScalarInt() throws IOException {
        Array data = this.getScalarData();
        return data.getInt(Index.scalarIndexImmutable);
    }

    @Override
    public long readScalarLong() throws IOException {
        Array data = this.getScalarData();
        return data.getLong(Index.scalarIndexImmutable);
    }

    @Override
    public float readScalarFloat() throws IOException {
        Array data = this.getScalarData();
        return data.getFloat(Index.scalarIndexImmutable);
    }

    @Override
    public double readScalarDouble() throws IOException {
        Array data = this.getScalarData();
        return data.getDouble(Index.scalarIndexImmutable);
    }

    @Override
    public String readScalarString() throws IOException {
        Array data = this.getScalarData();
        if (this.dataType == DataType.STRING) {
            return (String)data.getObject(Index.scalarIndexImmutable);
        }
        if (this.dataType == DataType.CHAR) {
            ArrayChar dataC = (ArrayChar)data;
            return dataC.getString();
        }
        throw new IllegalArgumentException("readScalarString not STRING or CHAR " + this.getFullName());
    }

    protected Array getScalarData() throws IOException {
        Array scalarData = this.cache.data != null ? this.cache.data : this.read();
        if ((scalarData = scalarData.reduce()).getRank() == 0 || scalarData.getRank() == 1 && this.dataType == DataType.CHAR) {
            return scalarData;
        }
        throw new UnsupportedOperationException("not a scalar variable =" + this);
    }

    protected Array _read() throws IOException {
        if (this.cache.data != null) {
            if (debugCaching) {
                System.out.println("got data from cache " + this.getFullName());
            }
            return this.cache.data.copy();
        }
        Array data = this.proxyReader.reallyRead(this, null);
        if (this.isCaching()) {
            this.setCachedData(data);
            if (debugCaching) {
                System.out.println("cache " + this.getFullName());
            }
            return this.cache.data.copy();
        }
        return data;
    }

    @Override
    public Array reallyRead(Variable client, CancelTask cancelTask) throws IOException {
        if (this.isMemberOfStructure()) {
            ArrayList<String> memList = new ArrayList<String>();
            memList.add(this.getShortName());
            Structure s2 = this.getParentStructure().select(memList);
            ArrayStructure as = (ArrayStructure)s2.read();
            return as.extractMemberArray(as.findMember(this.getShortName()));
        }
        try {
            return this.ncfile.readData(this, this.getShapeAsSection());
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
    }

    protected Array _read(Section section) throws IOException, InvalidRangeException {
        if (null == section || section.computeSize() == this.getSize()) {
            return this._read();
        }
        if (this.isCaching()) {
            if (this.cache.data == null) {
                this.setCachedData(this._read());
                if (debugCaching) {
                    System.out.println("cache " + this.getFullName());
                }
            }
            if (debugCaching) {
                System.out.println("got data from cache " + this.getFullName());
            }
            return this.cache.data.sectionNoReduce(section.getRanges()).copy();
        }
        return this.proxyReader.reallyRead(this, section, null);
    }

    @Override
    public Array reallyRead(Variable client, Section section, CancelTask cancelTask) throws IOException, InvalidRangeException {
        if (this.isMemberOfStructure()) {
            throw new UnsupportedOperationException("Cannot directly read section of Member Variable=" + this.getFullName());
        }
        return this.ncfile.readData(this, section);
    }

    public long readToByteChannel(Section section, WritableByteChannel wbc) throws IOException, InvalidRangeException {
        if (this.ncfile == null || this.hasCachedData()) {
            return IospHelper.copyToByteChannel(this.read(section), wbc);
        }
        return this.ncfile.readToByteChannel(this, section, wbc);
    }

    public long readToStream(Section section, OutputStream out) throws IOException, InvalidRangeException {
        if (this.ncfile == null || this.hasCachedData()) {
            return IospHelper.copyToOutputStream(this.read(section), out);
        }
        return this.ncfile.readToOutputStream(this, section, out);
    }

    public String getNameAndDimensions() {
        Formatter buf = new Formatter();
        this.getNameAndDimensions(buf, true, false);
        return buf.toString();
    }

    public String getNameAndDimensions(boolean strict) {
        Formatter buf = new Formatter();
        this.getNameAndDimensions(buf, false, strict);
        return buf.toString();
    }

    public void getNameAndDimensions(StringBuilder buf) {
        this.getNameAndDimensions(buf, true, false);
    }

    public void getNameAndDimensions(StringBuffer buf) {
        Formatter proxy = new Formatter();
        this.getNameAndDimensions(proxy, true, false);
        buf.append(proxy.toString());
    }

    public void getNameAndDimensions(StringBuilder buf, boolean useFullName, boolean strict) {
        Formatter proxy = new Formatter();
        this.getNameAndDimensions(proxy, useFullName, strict);
        buf.append(proxy.toString());
    }

    @Override
    public void getNameAndDimensions(Formatter buf, boolean useFullName, boolean strict) {
        String name;
        useFullName = useFullName && !strict;
        String string = name = useFullName ? this.getFullName() : this.getShortName();
        if (strict) {
            name = NetcdfFile.makeValidCDLName(this.getShortName());
        }
        buf.format("%s", name);
        if (this.shape != null) {
            if (this.getRank() > 0) {
                buf.format("(", new Object[0]);
            }
            for (int i = 0; i < this.dimensions.size(); ++i) {
                Dimension myd = this.dimensions.get(i);
                String dimName = myd.getShortName();
                if (dimName != null && strict) {
                    dimName = NetcdfFile.makeValidCDLName(dimName);
                }
                if (i != 0) {
                    buf.format(", ", new Object[0]);
                }
                if (myd.isVariableLength()) {
                    buf.format("*", new Object[0]);
                    continue;
                }
                if (myd.isShared()) {
                    if (!strict) {
                        buf.format("%s=%d", dimName, myd.getLength());
                        continue;
                    }
                    buf.format("%s", dimName);
                    continue;
                }
                if (dimName != null) {
                    buf.format("%s=", dimName);
                }
                buf.format("%d", myd.getLength());
            }
            if (this.getRank() > 0) {
                buf.format(")", new Object[0]);
            }
        }
    }

    public String toString() {
        return this.writeCDL(false, false);
    }

    public String writeCDL(boolean useFullName, boolean strict) {
        Formatter buf = new Formatter();
        this.writeCDL(buf, new Indent(2), useFullName, strict);
        return buf.toString();
    }

    protected void writeCDL(Formatter buf, Indent indent, boolean useFullName, boolean strict) {
        buf.format("%s", indent);
        if (this.dataType == null) {
            buf.format("Unknown", new Object[0]);
        } else if (this.dataType.isEnum()) {
            if (this.enumTypedef == null) {
                buf.format("enum UNKNOWN", new Object[0]);
            } else {
                buf.format("enum %s", NetcdfFile.makeValidCDLName(this.enumTypedef.getShortName()));
            }
        } else {
            buf.format("%s", this.dataType.toString());
        }
        buf.format(" ", new Object[0]);
        this.getNameAndDimensions(buf, useFullName, strict);
        buf.format(";", new Object[0]);
        if (!strict) {
            buf.format(this.extraInfo(), new Object[0]);
        }
        buf.format("%n", new Object[0]);
        indent.incr();
        for (Attribute att : this.getAttributes()) {
            buf.format("%s", indent);
            if (strict) {
                buf.format(NetcdfFile.makeValidCDLName(this.getShortName()), new Object[0]);
            }
            buf.format(":", new Object[0]);
            att.writeCDL(buf, strict);
            buf.format(";", new Object[0]);
            if (!strict && att.getDataType() != DataType.STRING) {
                buf.format(" // %s", new Object[]{att.getDataType()});
            }
            buf.format("%n", new Object[0]);
        }
        indent.decr();
    }

    @Override
    public String toStringDebug() {
        Formatter f = new Formatter();
        f.format("Variable %s", this.getFullName());
        if (this.ncfile != null) {
            f.format(" in file %s", this.getDatasetLocation());
            String extra = this.ncfile.toStringDebug(this);
            if (extra != null) {
                f.format(" %s", extra);
            }
        }
        return f.toString();
    }

    protected String extraInfo() {
        return showSize ? " // " + this.getElementSize() + " " + this.getSize() : "";
    }

    public String getDatasetLocation() {
        if (this.ncfile != null) {
            return this.ncfile.getLocation();
        }
        return "N/A";
    }

    public boolean equals(Object oo) {
        if (this == oo) {
            return true;
        }
        if (!(oo instanceof Variable)) {
            return false;
        }
        Variable o = (Variable)oo;
        if (!this.getShortName().equals(o.getShortName())) {
            return false;
        }
        if (this.isScalar() != o.isScalar()) {
            return false;
        }
        if (this.getDataType() != o.getDataType()) {
            return false;
        }
        if (!this.getParentGroup().equals(o.getParentGroup())) {
            return false;
        }
        if (this.getParentStructure() != null && !this.getParentStructure().equals(o.getParentStructure())) {
            return false;
        }
        if (this.isVariableLength() != o.isVariableLength()) {
            return false;
        }
        if (this.dimensions.size() != o.getDimensions().size()) {
            return false;
        }
        for (int i = 0; i < this.dimensions.size(); ++i) {
            if (this.getDimension(i).equals(o.getDimension(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 37 * result + this.getShortName().hashCode();
            if (this.isScalar()) {
                ++result;
            }
            result = 37 * result + this.getDataType().hashCode();
            result = 37 * result + this.getParentGroup().hashCode();
            if (this.getParentStructure() != null) {
                result = 37 * result + this.getParentStructure().hashCode();
            }
            if (this.isVariableLength) {
                ++result;
            }
            this.hashCode = result = 37 * result + this.dimensions.hashCode();
        }
        return this.hashCode;
    }

    @Override
    public void hashCodeShow(Indent indent) {
        System.out.printf("%sVar hash = %d%n", indent, this.hashCode());
        System.out.printf("%s shortName %s = %d%n", indent, this.getShortName(), this.getShortName().hashCode());
        System.out.printf("%s isScalar %s%n", indent, this.isScalar());
        System.out.printf("%s dataType %s%n", new Object[]{indent, this.getDataType()});
        System.out.printf("%s parentGroup %s = %d%n", indent, this.getParentGroup(), this.getParentGroup().hashCode());
        System.out.printf("%s isVariableLength %s%n", indent, this.isVariableLength);
        System.out.printf("%s dimensions %d len=%d%n", indent, this.dimensions.hashCode(), this.dimensions.size());
        indent.incr();
        for (Dimension d : this.dimensions) {
            d.hashCodeShow(indent);
        }
        indent.decr();
        if (this.getParentStructure() != null) {
            System.out.printf("%s parentStructure %d%n", indent, this.getParentStructure().hashCode());
            this.getParentStructure().hashCodeShow(indent.incr());
            indent.decr();
        }
    }

    @Override
    public int compareTo(VariableSimpleIF o) {
        return this.getShortName().compareTo(o.getShortName());
    }

    protected Variable() {
    }

    public Variable(NetcdfFile ncfile, Group group, Structure parent, String shortName) {
        super(shortName);
        this.ncfile = ncfile;
        if (parent == null) {
            this.setParentGroup(group == null ? ncfile.getRootGroup() : group);
        } else {
            this.setParentStructure(parent);
        }
    }

    public Variable(NetcdfFile ncfile, Group group, Structure parent, String shortName, DataType dtype, String dims) {
        this(ncfile, group, parent, shortName);
        this.setDataType(dtype);
        this.setDimensions(dims);
    }

    public Variable(Variable from) {
        super(from.getShortName());
        this.attributes = new ArrayList<Attribute>(from.attributes);
        this.cache = from.cache;
        this.setDataType(from.getDataType());
        this.dimensions = new ArrayList<Dimension>(from.dimensions);
        this.elementSize = from.getElementSize();
        this.enumTypedef = from.enumTypedef;
        this.setParentGroup(from.group);
        this.setParentStructure(from.getParentStructure());
        this.isMetadata = from.isMetadata;
        this.isVariableLength = from.isVariableLength;
        this.ncfile = from.ncfile;
        this.shape = from.getShape();
        this.sizeToCache = from.sizeToCache;
        this.spiObject = from.spiObject;
    }

    public void setDataType(DataType dataType) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.dataType = dataType;
        this.elementSize = this.getDataType().getSize();
    }

    public String setName(String shortName) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.setShortName(shortName);
        return this.getShortName();
    }

    @Override
    public void setParentGroup(Group group) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        super.setParentGroup(group);
    }

    public void setElementSize(int elementSize) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.elementSize = elementSize;
    }

    @Override
    public Attribute addAttribute(Attribute att) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        if (att == null) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < this.attributes.size(); ++i) {
            Attribute a = this.attributes.get(i);
            if (!att.getShortName().equals(a.getShortName())) continue;
            this.attributes.set(i, att);
            return att;
        }
        this.attributes.add(att);
        return att;
    }

    @Override
    public void addAll(Iterable<Attribute> atts) {
        for (Attribute att : atts) {
            this.addAttribute(att);
        }
    }

    public boolean remove(Attribute a) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        return a != null && this.attributes.remove(a);
    }

    public boolean removeAttribute(String attName) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        Attribute att = this.findAttribute(attName);
        return att != null && this.attributes.remove(att);
    }

    public boolean removeAttributeIgnoreCase(String attName) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        Attribute att = this.findAttributeIgnoreCase(attName);
        return att != null && this.attributes.remove(att);
    }

    public void setDimensions(List<Dimension> dims) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.dimensions = dims == null ? new ArrayList<Dimension>() : new ArrayList<Dimension>(dims);
        this.resetShape();
    }

    public void resetShape() {
        this.shape = new int[this.dimensions.size()];
        for (int i = 0; i < this.dimensions.size(); ++i) {
            Dimension dim = this.dimensions.get(i);
            this.shape[i] = dim.getLength();
            if (!dim.isVariableLength()) continue;
            this.isVariableLength = true;
        }
        this.shapeAsSection = null;
    }

    public void setDimensions(String dimString) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        try {
            this.dimensions = Dimension.makeDimensionsList(this.getParentGroup(), dimString);
            this.resetShape();
        }
        catch (IllegalStateException e) {
            throw new IllegalArgumentException("Variable " + this.getFullName() + " setDimensions = '" + dimString + "' FAILED: " + e.getMessage() + " file = " + this.getDatasetLocation());
        }
    }

    public void resetDimensions() {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        ArrayList<Dimension> newDimensions = new ArrayList<Dimension>();
        for (Dimension dim : this.dimensions) {
            if (dim.isShared()) {
                Dimension newD = this.getParentGroup().findDimension(dim.getShortName());
                if (newD == null) {
                    throw new IllegalArgumentException("Variable " + this.getFullName() + " resetDimensions  FAILED, dim doesnt exist in parent group=" + dim);
                }
                newDimensions.add(newD);
                continue;
            }
            newDimensions.add(dim);
        }
        this.dimensions = newDimensions;
        this.resetShape();
    }

    public void setDimensionsAnonymous(int[] shape) throws InvalidRangeException {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.dimensions = new ArrayList<Dimension>();
        for (int i = 0; i < shape.length; ++i) {
            Dimension anon;
            if (shape[i] < 1 && shape[i] != -1) {
                throw new InvalidRangeException("shape[" + i + "]=" + shape[i] + " must be > 0");
            }
            if (shape[i] == -1) {
                anon = Dimension.VLEN;
                this.isVariableLength = true;
            } else {
                anon = new Dimension(null, shape[i], false, false, false);
            }
            this.dimensions.add(anon);
        }
        this.resetShape();
    }

    public void setIsScalar() {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.dimensions = new ArrayList<Dimension>();
        this.resetShape();
    }

    public void setDimension(int idx, Dimension dim) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.dimensions.set(idx, dim);
        this.resetShape();
    }

    public Variable setImmutable() {
        super.setImmutable(true);
        this.dimensions = Collections.unmodifiableList(this.dimensions);
        this.attributes = Collections.unmodifiableList(this.attributes);
        return this;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public Object getSPobject() {
        return this.spiObject;
    }

    public void setSPobject(Object spiObject) {
        this.spiObject = spiObject;
    }

    public int getSizeToCache() {
        if (this.sizeToCache >= 0) {
            return this.sizeToCache;
        }
        return this.isCoordinateVariable() ? 40000 : 4000;
    }

    public void setSizeToCache(int sizeToCache) {
        this.sizeToCache = sizeToCache;
    }

    public void setCaching(boolean caching) {
        this.cache.isCaching = caching;
        this.cache.cachingSet = true;
    }

    public boolean isCaching() {
        if (!this.cache.cachingSet) {
            this.cache.isCaching = !this.isVariableLength && this.getSize() * (long)this.getElementSize() < (long)this.getSizeToCache();
            this.cache.cachingSet = true;
        }
        return this.cache.isCaching;
    }

    public void invalidateCache() {
        this.cache.data = null;
    }

    public void setCachedData(Array cacheData) {
        this.setCachedData(cacheData, false);
    }

    public void setCachedData(Array cacheData, boolean isMetadata) {
        if (cacheData != null && cacheData.getElementType() != this.getDataType().getPrimitiveClassType()) {
            throw new IllegalArgumentException("setCachedData type=" + cacheData.getElementType() + " incompatible with variable type=" + (Object)((Object)this.getDataType()));
        }
        this.cache.data = cacheData;
        this.isMetadata = isMetadata;
        this.cache.cachingSet = true;
        this.cache.isCaching = true;
    }

    public void createNewCache() {
        this.cache = new Cache();
    }

    public boolean hasCachedData() {
        return null != this.cache.data;
    }

    public void setValues(int npts, double start, double incr) {
        if ((long)npts != this.getSize()) {
            throw new IllegalArgumentException("bad npts = " + npts + " should be " + this.getSize());
        }
        Array data = Array.makeArray(this.getDataType(), npts, start, incr);
        if (this.getRank() != 1) {
            data = data.reshape(this.getShape());
        }
        this.setCachedData(data, true);
    }

    public void setValues(List<String> values) throws IllegalArgumentException {
        Array data = Array.makeArray(this.getDataType(), this.isUnsigned(), values);
        if (data.getSize() != this.getSize()) {
            throw new IllegalArgumentException("Incorrect number of values specified for the Variable " + this.getFullName() + " needed= " + this.getSize() + " given=" + data.getSize());
        }
        if (this.getRank() != 1) {
            data = data.reshape(this.getShape());
        }
        this.setCachedData(data, true);
    }

    @Override
    public List<Dimension> getDimensionsAll() {
        ArrayList<Dimension> dimsAll = new ArrayList<Dimension>();
        this.addDimensionsAll(dimsAll, this);
        return dimsAll;
    }

    private void addDimensionsAll(List<Dimension> result, Variable v) {
        if (v.isMemberOfStructure()) {
            this.addDimensionsAll(result, v.getParentStructure());
        }
        for (int i = 0; i < v.getRank(); ++i) {
            result.add(v.getDimension(i));
        }
    }

    public int[] getShapeAll() {
        if (this.getParentStructure() == null) {
            return this.getShape();
        }
        List<Dimension> dimAll = this.getDimensionsAll();
        int[] shapeAll = new int[dimAll.size()];
        for (int i = 0; i < dimAll.size(); ++i) {
            shapeAll[i] = dimAll.get(i).getLength();
        }
        return shapeAll;
    }

    @Override
    public boolean isCoordinateVariable() {
        Dimension firstd;
        if (this.dataType == DataType.STRUCTURE || this.isMemberOfStructure()) {
            return false;
        }
        int n = this.getRank();
        if (n == 1 && this.dimensions.size() == 1) {
            firstd = this.dimensions.get(0);
            if (this.getShortName().equals(firstd.getShortName())) {
                return true;
            }
        }
        return n == 2 && this.dimensions.size() == 2 && this.shortName.equals((firstd = this.dimensions.get(0)).getShortName()) && this.getDataType() == DataType.CHAR;
    }

    public boolean isUnknownLength() {
        return this.isVariableLength;
    }

    protected static class Cache {
        public Array data;
        public boolean isCaching = false;
        public boolean cachingSet = false;
    }
}

