/*
 * Decompiled with CFR 0.152.
 */
package ucar.coord;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.featurecollection.FeatureCollectionConfig;
import ucar.coord.Coordinate;
import ucar.coord.CoordinateBuilder;
import ucar.coord.CoordinateBuilderImpl;
import ucar.coord.CoordinateEns;
import ucar.coord.CoordinateND;
import ucar.coord.CoordinateRuntime;
import ucar.coord.CoordinateTime;
import ucar.coord.CoordinateTime2D;
import ucar.coord.CoordinateTimeAbstract;
import ucar.coord.CoordinateTimeIntv;
import ucar.coord.CoordinateVert;
import ucar.nc2.grib.TimeCoord;
import ucar.nc2.grib.collection.GribCollection;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarPeriod;

public class CoordinateUnionizer<T> {
    private static Logger logger = LoggerFactory.getLogger(CoordinateUnionizer.class);
    FeatureCollectionConfig.GribIntvFilter intvFilter;
    int varId;
    List<Coordinate> unionCoords = new ArrayList<Coordinate>();
    CoordinateND<GribCollection.Record> result;
    CoordinateBuilder runtimeBuilder;
    CoordinateBuilder timeBuilder;
    CoordinateBuilder timeIntvBuilder;
    CoordinateBuilder vertBuilder;
    CoordinateBuilder ensBuilder;
    Time2DUnionBuilder time2DBuilder;

    public CoordinateUnionizer(int varId, FeatureCollectionConfig.GribIntvFilter intvFilter) {
        this.intvFilter = intvFilter;
        this.varId = varId;
    }

    public void addCoords(List<Coordinate> coords) {
        Coordinate runtime = null;
        for (Coordinate coord : coords) {
            switch (coord.getType()) {
                case runtime: {
                    CoordinateRuntime rtime = (CoordinateRuntime)coord;
                    if (this.runtimeBuilder == null) {
                        this.runtimeBuilder = new CoordinateRuntime.Builder2(rtime.getTimeUnits());
                    }
                    this.runtimeBuilder.addAll(coord);
                    runtime = coord;
                    break;
                }
                case time: {
                    CoordinateTime time = (CoordinateTime)coord;
                    if (this.timeBuilder == null) {
                        this.timeBuilder = new CoordinateTime.Builder2(coord.getCode(), time.getTimeUnit(), time.getRefDate());
                    }
                    this.timeBuilder.addAll(coord);
                    break;
                }
                case timeIntv: {
                    CoordinateTimeIntv timeIntv = (CoordinateTimeIntv)coord;
                    if (this.timeIntvBuilder == null) {
                        this.timeIntvBuilder = new CoordinateTimeIntv.Builder2(null, coord.getCode(), timeIntv.getTimeUnit(), timeIntv.getRefDate());
                    }
                    this.timeIntvBuilder.addAll(this.intervalFilter((CoordinateTimeIntv)coord));
                    break;
                }
                case time2D: {
                    CoordinateTime2D time2D = (CoordinateTime2D)coord;
                    if (this.time2DBuilder == null) {
                        this.time2DBuilder = new Time2DUnionBuilder(time2D.isTimeInterval(), time2D.getTimeUnit(), coord.getCode());
                    }
                    this.time2DBuilder.addAll(time2D);
                    CoordinateRuntime runtimeFrom2D = time2D.getRuntimeCoordinate();
                    if (runtimeFrom2D.equals(runtime)) break;
                    logger.warn("HEY CoordinateUnionizer runtimes not equal");
                    break;
                }
                case vert: {
                    if (this.vertBuilder == null) {
                        this.vertBuilder = new CoordinateVert.Builder2(coord.getCode());
                    }
                    this.vertBuilder.addAll(coord);
                    break;
                }
                case ens: {
                    if (this.ensBuilder == null) {
                        this.ensBuilder = new CoordinateEns.Builder2(coord.getCode());
                    }
                    this.ensBuilder.addAll(coord);
                }
            }
        }
    }

    private List<TimeCoord.Tinv> intervalFilter(CoordinateTimeIntv coord) {
        if (this.intvFilter == null) {
            return coord.getTimeIntervals();
        }
        ArrayList<TimeCoord.Tinv> result = new ArrayList<TimeCoord.Tinv>();
        for (TimeCoord.Tinv tinv : coord.getTimeIntervals()) {
            if (!this.intvFilter.filterOk(this.varId, tinv.getIntervalSize(), 0)) continue;
            result.add(tinv);
        }
        return result;
    }

    public List<Coordinate> finish() {
        if (this.runtimeBuilder != null) {
            this.unionCoords.add(this.runtimeBuilder.finish());
        } else {
            logger.warn("HEY CoordinateUnionizer missing runtime");
        }
        if (this.timeBuilder != null) {
            this.unionCoords.add(this.timeBuilder.finish());
        } else if (this.timeIntvBuilder != null) {
            this.unionCoords.add(this.timeIntvBuilder.finish());
        } else if (this.time2DBuilder != null) {
            this.unionCoords.add(this.time2DBuilder.finish());
        } else {
            logger.warn("HEY CoordinateUnionizer missing time");
        }
        if (this.vertBuilder != null) {
            this.unionCoords.add(this.vertBuilder.finish());
        }
        if (this.ensBuilder != null) {
            this.unionCoords.add(this.ensBuilder.finish());
        }
        this.result = new CoordinateND(this.unionCoords);
        return this.unionCoords;
    }

    private class Time2DUnionBuilder
    extends CoordinateBuilderImpl<T> {
        boolean isTimeInterval;
        CalendarPeriod timeUnit;
        int code;
        SortedMap<CalendarDate, CoordinateTimeAbstract> timeMap = new TreeMap<CalendarDate, CoordinateTimeAbstract>();

        public Time2DUnionBuilder(boolean isTimeInterval, CalendarPeriod timeUnit, int code) {
            this.isTimeInterval = isTimeInterval;
            this.timeUnit = timeUnit;
            this.code = code;
        }

        @Override
        public void addAll(Coordinate coord) {
            CoordinateTime2D coordT2D = (CoordinateTime2D)coord;
            for (int runIdx = 0; runIdx < coordT2D.getNruns(); ++runIdx) {
                CoordinateTimeAbstract times = coordT2D.getTimeCoordinate(runIdx);
                this.timeMap.put(coordT2D.getRefDate(runIdx), times);
            }
        }

        @Override
        public Object extract(T gr) {
            throw new RuntimeException();
        }

        @Override
        public Coordinate makeCoordinate(List<Object> values) {
            ArrayList<CalendarDate> runtimes = new ArrayList<CalendarDate>();
            ArrayList<Coordinate> times = new ArrayList<Coordinate>();
            for (CalendarDate cd2 : this.timeMap.keySet()) {
                runtimes.add(cd2);
                times.add((Coordinate)this.timeMap.get(cd2));
            }
            CoordinateTimeAbstract maxCoord = this.testOrthogonal(this.timeMap.values());
            if (maxCoord != null) {
                return new CoordinateTime2D(this.code, this.timeUnit, new CoordinateRuntime(runtimes, this.timeUnit), maxCoord, times);
            }
            List<Coordinate> regCoords = this.testIsRegular();
            if (regCoords != null) {
                return new CoordinateTime2D(this.code, this.timeUnit, new CoordinateRuntime(runtimes, this.timeUnit), regCoords, times);
            }
            return new CoordinateTime2D(this.code, this.timeUnit, null, new CoordinateRuntime(runtimes, this.timeUnit), times);
        }

        private List<Coordinate> testIsRegular() {
            TreeMap<Integer, ArrayList<CoordinateTimeAbstract>> hourMap = new TreeMap<Integer, ArrayList<CoordinateTimeAbstract>>();
            for (CoordinateTimeAbstract coord : this.timeMap.values()) {
                CalendarDate runDate = coord.getRefDate();
                int hour = runDate.getHourOfDay();
                ArrayList<CoordinateTimeAbstract> hg = (ArrayList<CoordinateTimeAbstract>)hourMap.get(hour);
                if (hg == null) {
                    hg = new ArrayList<CoordinateTimeAbstract>();
                    hourMap.put(hour, hg);
                }
                hg.add(coord);
            }
            ArrayList<Coordinate> result = new ArrayList<Coordinate>();
            Iterator i$ = hourMap.keySet().iterator();
            while (i$.hasNext()) {
                int hour = (Integer)i$.next();
                List hg = (List)hourMap.get(hour);
                CoordinateTimeAbstract maxCoord = this.testOrthogonal(hg);
                if (maxCoord == null) {
                    return null;
                }
                result.add(maxCoord);
            }
            return result;
        }

        private CoordinateTimeAbstract testOrthogonal(Collection<CoordinateTimeAbstract> times) {
            CoordinateTimeAbstract maxCoord = null;
            int max = 0;
            HashSet<Object> result = new HashSet<Object>(100);
            for (CoordinateTimeAbstract coord : times) {
                if (max < coord.getSize()) {
                    maxCoord = coord;
                    max = coord.getSize();
                }
                for (Object object : coord.getValues()) {
                    result.add(object);
                }
            }
            int totalMax = result.size();
            return totalMax == max ? maxCoord : null;
        }
    }
}

