/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.util.Optional;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.referencing.operation.transform.ConcatenatedTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class DomainDefinition {
    private Envelope limits;
    private GeneralEnvelope intersection;
    private ToDomain stepToDomain;

    public void estimate(MathTransform mathTransform) throws TransformException {
        Envelope envelope;
        if (mathTransform instanceof AbstractMathTransform && (envelope = (Envelope)((AbstractMathTransform)mathTransform).getDomain(this).orElse(null)) != null) {
            if (this.stepToDomain != null) {
                envelope = Envelopes.transform(this.stepToDomain.concatenation(), envelope);
            }
            this.intersect(envelope);
        }
    }

    final void estimateOnInverse(MathTransform mathTransform) throws TransformException {
        if (mathTransform instanceof ConcatenatedTransform) {
            ConcatenatedTransform concatenatedTransform = (ConcatenatedTransform)mathTransform;
            this.estimateOnInverse(concatenatedTransform.transform2);
            this.estimateOnInverse(concatenatedTransform.transform1, concatenatedTransform.transform2);
        } else {
            MathTransform mathTransform2 = mathTransform.inverse();
            if (mathTransform2 instanceof ConcatenatedTransform) {
                ConcatenatedTransform concatenatedTransform = (ConcatenatedTransform)mathTransform2;
                MathTransform mathTransform3 = concatenatedTransform.transform2.inverse();
                MathTransform mathTransform4 = concatenatedTransform.transform1.inverse();
                this.estimateOnInverse(mathTransform4);
                this.estimateOnInverse(mathTransform3, mathTransform4);
            } else {
                this.estimate(mathTransform2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void estimateOnInverse(MathTransform mathTransform, MathTransform mathTransform2) throws TransformException {
        ToDomain toDomain = this.stepToDomain;
        try {
            this.stepToDomain = new ToDomain(mathTransform2, this.stepToDomain);
            this.estimateOnInverse(mathTransform);
        }
        finally {
            this.stepToDomain = toDomain;
        }
    }

    public void intersect(Envelope envelope) {
        ArgumentChecks.ensureNonNull("domain", envelope);
        if (this.limits == null) {
            this.limits = envelope;
        } else {
            if (this.intersection == null) {
                this.intersection = new GeneralEnvelope(this.limits);
                this.limits = this.intersection;
            }
            this.intersection.intersect(envelope);
        }
    }

    final Envelope intersectOrTransform(Envelope envelope, MathTransform mathTransform) throws TransformException {
        if (envelope != null) {
            if (this.stepToDomain != null) {
                mathTransform = MathTransforms.concatenate(mathTransform, this.stepToDomain.concatenation());
                envelope = Envelopes.transform(mathTransform, envelope);
                this.intersect(envelope);
                return null;
            }
            envelope = Envelopes.transform(mathTransform, envelope);
        }
        return envelope;
    }

    public Optional<Envelope> result() {
        return Optional.ofNullable(this.limits);
    }

    public String toString() {
        return this.limits != null ? this.limits.toString() : "empty";
    }

    private static final class ToDomain {
        private final MathTransform step;
        private final ToDomain next;
        private MathTransform concatenation;

        ToDomain(MathTransform mathTransform, ToDomain toDomain) {
            this.step = mathTransform;
            this.next = toDomain;
        }

        MathTransform concatenation() {
            if (this.concatenation == null) {
                this.concatenation = this.next == null ? this.step : MathTransforms.concatenate(this.step, this.next.concatenation());
            }
            return this.concatenation;
        }
    }
}

