/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import java.io.Serializable;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.sis.internal.referencing.CoordinateOperations;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.metadata.iso.extent.DefaultExtent;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.BackingStoreException;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.TransformException;

public class CoordinateOperationContext
implements Serializable {
    private static final long serialVersionUID = -6944460471653277973L;
    private Extent areaOfInterest;
    private double desiredAccuracy;

    public CoordinateOperationContext() {
    }

    public CoordinateOperationContext(Extent extent, double d) {
        ArgumentChecks.ensurePositive("accuracy", d);
        if (extent != null) {
            this.areaOfInterest = new DefaultExtent(extent);
        }
        this.desiredAccuracy = d;
    }

    public static CoordinateOperationContext fromBoundingBox(GeographicBoundingBox geographicBoundingBox) {
        if (geographicBoundingBox != null && (geographicBoundingBox.getSouthBoundLatitude() > -90.0 || geographicBoundingBox.getNorthBoundLatitude() < 90.0 || geographicBoundingBox.getWestBoundLongitude() > -180.0 || geographicBoundingBox.getEastBoundLongitude() < 180.0)) {
            CoordinateOperationContext coordinateOperationContext = new CoordinateOperationContext();
            coordinateOperationContext.setAreaOfInterest(geographicBoundingBox);
            return coordinateOperationContext;
        }
        return null;
    }

    public Extent getAreaOfInterest() {
        return this.areaOfInterest;
    }

    public void setAreaOfInterest(Extent extent) {
        if (extent != null) {
            extent = new DefaultExtent(extent);
        }
        this.areaOfInterest = extent;
    }

    public void setAreaOfInterest(GeographicBoundingBox geographicBoundingBox) {
        this.areaOfInterest = CoordinateOperationContext.setGeographicBoundingBox(this.areaOfInterest, geographicBoundingBox);
    }

    static Extent setGeographicBoundingBox(Extent extent, GeographicBoundingBox geographicBoundingBox) {
        if (extent != null) {
            DefaultExtent defaultExtent = DefaultExtent.castOrCopy(extent);
            defaultExtent.setGeographicElements(CollectionsExt.singletonOrEmpty(geographicBoundingBox));
            extent = defaultExtent;
        } else if (geographicBoundingBox != null) {
            extent = new DefaultExtent(null, geographicBoundingBox, null, null);
        }
        return extent;
    }

    public double getDesiredAccuracy() {
        return this.desiredAccuracy;
    }

    public void setDesiredAccuracy(double d) {
        ArgumentChecks.ensurePositive("accuracy", d);
        this.desiredAccuracy = d;
    }

    final Predicate<CoordinateOperation> getOperationFilter() {
        return null;
    }

    static double[] getConstantCoordinates() throws TransformException {
        Supplier<double[]> supplier = CoordinateOperations.CONSTANT_COORDINATES.get();
        if (supplier != null) {
            try {
                return supplier.get();
            }
            catch (BackingStoreException backingStoreException) {
                throw backingStoreException.unwrapOrRethrow(TransformException.class);
            }
        }
        return null;
    }
}

