/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory.sql;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.sis.internal.metadata.sql.SQLUtilities;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.factory.IdentifiedObjectFinder;
import org.apache.sis.referencing.factory.sql.EPSGDataAccess;
import org.apache.sis.referencing.factory.sql.TableInfo;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.logging.Logging;
import org.opengis.metadata.Identifier;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.util.CodeList;
import org.opengis.util.FactoryException;
import org.opengis.util.GenericName;

final class EPSGCodeFinder
extends IdentifiedObjectFinder {
    private final EPSGDataAccess dao;
    private Class<? extends IdentifiedObject> declaredType;

    EPSGCodeFinder(EPSGDataAccess ePSGDataAccess) {
        super(ePSGDataAccess.owner);
        this.dao = ePSGDataAccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<IdentifiedObject> find(IdentifiedObject identifiedObject) throws FactoryException {
        boolean bl = this.dao.quiet;
        this.dao.quiet = true;
        try {
            Set<IdentifiedObject> set = super.find(identifiedObject);
            return set;
        }
        finally {
            this.dao.quiet = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends IdentifiedObject> Condition dependencies(String string, Class<T> clazz, T t2, boolean bl) throws FactoryException {
        if (t2 != null) {
            Set<IdentifiedObject> set;
            Class<? extends IdentifiedObject> clazz2 = this.declaredType;
            boolean bl2 = this.isIgnoringAxes();
            try {
                this.setIgnoringAxes(bl | bl2);
                this.declaredType = clazz;
                set = this.find(t2);
            }
            finally {
                this.declaredType = clazz2;
                this.setIgnoringAxes(bl2);
            }
            LinkedHashSet<Number> linkedHashSet = new LinkedHashSet<Number>(Containers.hashMapCapacity(set.size()));
            for (IdentifiedObject identifiedObject : set) {
                Identifier identifier = IdentifiedObjects.getIdentifier(identifiedObject, Citations.EPSG);
                if (identifier == null) continue;
                try {
                    linkedHashSet.add(Integer.parseInt(identifier.getCode()));
                }
                catch (NumberFormatException numberFormatException) {
                    Logging.recoverableException(Logger.getLogger("org.apache.sis.referencing.factory"), EPSGCodeFinder.class, "getCodeCandidates", numberFormatException);
                }
            }
            if (!linkedHashSet.isEmpty()) {
                return new Condition(string, linkedHashSet);
            }
        }
        return null;
    }

    private boolean isInstance(Class<? extends IdentifiedObject> clazz, IdentifiedObject identifiedObject) {
        return (this.declaredType == null || clazz.isAssignableFrom(this.declaredType)) && clazz.isInstance(identifiedObject);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Set<String> getCodeCandidates(IdentifiedObject identifiedObject) throws FactoryException {
        int n;
        Object object;
        String string;
        LinkedHashSet<String> linkedHashSet;
        Object[] objectArray;
        Object object2;
        TableInfo tableInfo;
        block52: {
            block58: {
                block55: {
                    block56: {
                        int n2;
                        block57: {
                            if (!this.isInstance(CoordinateReferenceSystem.class, identifiedObject)) break block55;
                            tableInfo = TableInfo.CRS;
                            if (!this.isInstance(CompoundCRS.class, identifiedObject) || (object2 = ((CompoundCRS)identifiedObject).getComponents()) == null) break block56;
                            n2 = object2.size();
                            if (n2 != 2) break block57;
                            objectArray = new Condition[2];
                            break block58;
                        }
                        if (n2 == 1) {
                            return this.getCodeCandidates((IdentifiedObject)object2.get(0));
                        }
                    }
                    if (identifiedObject instanceof GeneralDerivedCRS) {
                        object2 = this.dependencies("SOURCE_GEOGCRS_CODE", CoordinateReferenceSystem.class, ((GeneralDerivedCRS)identifiedObject).getBaseCRS(), true);
                    } else if (identifiedObject instanceof GeodeticCRS) {
                        object2 = this.dependencies("DATUM_CODE", GeodeticDatum.class, ((GeodeticCRS)identifiedObject).getDatum(), true);
                    } else if (identifiedObject instanceof VerticalCRS) {
                        object2 = this.dependencies("DATUM_CODE", VerticalDatum.class, ((VerticalCRS)identifiedObject).getDatum(), true);
                    } else if (identifiedObject instanceof TemporalCRS) {
                        object2 = this.dependencies("DATUM_CODE", TemporalDatum.class, ((TemporalCRS)identifiedObject).getDatum(), true);
                    } else {
                        if (!(identifiedObject instanceof SingleCRS)) return Collections.emptySet();
                        object2 = this.dependencies("DATUM_CODE", Datum.class, ((SingleCRS)identifiedObject).getDatum(), true);
                    }
                    if (object2 == null) {
                        return Collections.emptySet();
                    }
                    objectArray = new Condition[]{object2};
                    break block52;
                }
                if (this.isInstance(Datum.class, identifiedObject)) {
                    tableInfo = TableInfo.DATUM;
                    if (this.isInstance(GeodeticDatum.class, identifiedObject)) {
                        objectArray = new Condition[]{this.dependencies("ELLIPSOID_CODE", Ellipsoid.class, ((GeodeticDatum)identifiedObject).getEllipsoid(), true), Condition.NAME};
                        if (objectArray[0] == null) {
                            return Collections.emptySet();
                        }
                        break block52;
                    } else {
                        if (this.isInstance(VerticalDatum.class, identifiedObject) && (object2 = ((VerticalDatum)identifiedObject).getVerticalDatumType()) != null && !((CodeList)object2).equals(EPSGDataAccess.VERTICAL_DATUM_TYPE)) {
                            return Collections.emptySet();
                        }
                        objectArray = new Condition[]{Condition.NAME};
                    }
                    break block52;
                } else {
                    if (!this.isInstance(Ellipsoid.class, identifiedObject)) return super.getCodeCandidates(identifiedObject);
                    tableInfo = TableInfo.ELLIPSOID;
                    objectArray = new Condition[]{new FloatCondition("SEMI_MAJOR_AXIS", ((Ellipsoid)identifiedObject).getSemiMajorAxis())};
                }
                break block52;
            }
            for (int i = 0; i <= 1; ++i) {
                objectArray[i] = this.dependencies(i == 0 ? "CMPD_HORIZCRS_CODE" : "CMPD_VERTCRS_CODE", CoordinateReferenceSystem.class, (CoordinateReferenceSystem)object2.get(i), false);
                if (objectArray[i] != null) continue;
                return Collections.emptySet();
            }
        }
        object2 = new StringBuilder(350);
        if (ArraysExt.containsIdentity(objectArray, Condition.NAME)) {
            linkedHashSet = new LinkedHashSet<String>();
            linkedHashSet.add(EPSGCodeFinder.toDatumPattern(identifiedObject.getName().getCode(), (StringBuilder)object2));
            for (GenericName genericName : identifiedObject.getAlias()) {
                linkedHashSet.add(EPSGCodeFinder.toDatumPattern(genericName.tip().toString(), (StringBuilder)object2));
            }
            ((StringBuilder)object2).setLength(0);
            ((StringBuilder)object2).append("SELECT OBJECT_CODE FROM [Alias] WHERE OBJECT_TABLE_NAME='").append(tableInfo.unquoted()).append("' AND ");
            EPSGCodeFinder.appendFilterByName(linkedHashSet, "ALIAS", (StringBuilder)object2);
            string = this.dao.translator.apply(((StringBuilder)object2).toString());
            ((StringBuilder)object2).setLength(0);
        } else {
            linkedHashSet = null;
            string = null;
        }
        ((StringBuilder)object2).append("SELECT ").append(tableInfo.codeColumn).append(" FROM ").append(tableInfo.table);
        tableInfo.where(identifiedObject.getClass(), (StringBuilder)object2);
        boolean bl = false;
        Object[] objectArray2 = objectArray;
        int n3 = objectArray2.length;
        for (n = 0; n < n3; bl |= ((Condition)object).appendToWhere((StringBuilder)object2, bl), ++n) {
            object = objectArray2[n];
        }
        try (Statement statement = this.dao.connection.createStatement();){
            if (linkedHashSet != null) {
                if (bl) {
                    ((StringBuilder)object2).append(" AND ");
                }
                bl = false;
                EPSGCodeFinder.appendFilterByName(linkedHashSet, tableInfo.nameColumn, (StringBuilder)object2);
                try (ResultSet resultSet = statement.executeQuery(string);){
                    while (resultSet.next()) {
                        n = resultSet.getInt(1);
                        if (resultSet.wasNull()) continue;
                        if (!bl) {
                            bl = true;
                            ((StringBuilder)object2).append(" OR ").append(tableInfo.codeColumn).append(" IN (");
                        } else {
                            ((StringBuilder)object2).append(',');
                        }
                        ((StringBuilder)object2).append(n);
                    }
                }
                if (bl) {
                    ((StringBuilder)object2).append(')');
                }
            }
            ((StringBuilder)object2).append(this.getSearchDomain() == IdentifiedObjectFinder.Domain.ALL_DATASET ? " ORDER BY ABS(DEPRECATED), " : " AND DEPRECATED=0 ORDER BY ");
            for (Object object3 : objectArray) {
                ((Condition)object3).appendToOrderBy((StringBuilder)object2);
            }
            ((StringBuilder)object2).append(tableInfo.codeColumn);
            LinkedHashSet linkedHashSet2 = new LinkedHashSet();
            try (Object[] objectArray3 = statement.executeQuery(this.dao.translator.apply(((StringBuilder)object2).toString()));){
                while (objectArray3.next()) {
                    linkedHashSet2.add(objectArray3.getString(1));
                }
            }
            linkedHashSet2.remove(null);
            if (linkedHashSet2.size() > 1) {
                objectArray3 = linkedHashSet2.toArray();
                if (this.dao.sort(tableInfo.unquoted(), objectArray3)) {
                    linkedHashSet2.clear();
                    for (Object object4 : objectArray3) {
                        linkedHashSet2.add((String)object4);
                    }
                }
            }
            objectArray3 = linkedHashSet2;
            return objectArray3;
        }
        catch (SQLException sQLException) {
            throw this.dao.databaseFailure(Identifier.class, (Comparable<?>)((Object)String.valueOf(CollectionsExt.first(((Condition)objectArray[0]).values))), sQLException);
        }
    }

    private static String toDatumPattern(String string, StringBuilder stringBuilder) {
        int n;
        int n2 = 0;
        if (string.startsWith("D_")) {
            n2 = "D_".length();
        }
        if ((n = string.indexOf(40)) < 0) {
            n = string.length();
        }
        n = CharSequences.skipTrailingWhitespaces(string, n2, n);
        stringBuilder.setLength(0);
        SQLUtilities.toLikePattern(string, n2, n, true, true, stringBuilder);
        return stringBuilder.toString();
    }

    private static void appendFilterByName(Set<String> set, String string, StringBuilder stringBuilder) {
        String string2 = "(";
        for (String string3 : set) {
            stringBuilder.append(string2).append("LOWER(").append(string).append(") LIKE '").append(string3).append('\'');
            string2 = " OR ";
        }
        stringBuilder.append(')');
    }

    private static class Condition {
        static final Condition NAME = new Condition("NAME", Collections.emptySet());
        final String column;
        final Set<Number> values;

        Condition(String string, Set<Number> set) {
            this.column = string;
            this.values = set;
        }

        boolean appendToWhere(StringBuilder stringBuilder, boolean bl) {
            if (this.values.isEmpty()) {
                return false;
            }
            if (bl) {
                stringBuilder.append(" AND ");
            }
            stringBuilder.append(this.column);
            if (this.values.size() == 1) {
                stringBuilder.append('=').append(CollectionsExt.first(this.values));
            } else {
                stringBuilder.append(" IN (");
                for (Number number : this.values) {
                    stringBuilder.append(number).append(',');
                }
                stringBuilder.setCharAt(stringBuilder.length() - 1, ')');
            }
            return true;
        }

        void appendToOrderBy(StringBuilder stringBuilder) {
        }

        public final String toString() {
            StringBuilder stringBuilder = new StringBuilder(50);
            this.appendToWhere(stringBuilder, false);
            return stringBuilder.toString();
        }
    }

    private static final class FloatCondition
    extends Condition {
        FloatCondition(String string, double d) {
            super(string, Collections.singleton(d));
        }

        @Override
        boolean appendToWhere(StringBuilder stringBuilder, boolean bl) {
            if (bl) {
                stringBuilder.append(" AND ");
            }
            double d = ((Number)this.values.iterator().next()).doubleValue();
            double d2 = Math.abs(1.5696105811844188E-9 * d);
            stringBuilder.append(this.column).append(">=").append(d - d2).append(" AND ").append(this.column).append("<=").append(d + d2);
            return true;
        }

        @Override
        void appendToOrderBy(StringBuilder stringBuilder) {
            double d = ((Number)this.values.iterator().next()).doubleValue();
            stringBuilder.append("ABS(").append(this.column).append('-').append(d).append("), ");
        }
    }
}

