/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.spatial;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.metadata.ImplementationHelper;
import org.apache.sis.measure.ValueRange;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.metadata.spatial.GeometricObjectType;
import org.opengis.metadata.spatial.GeometricObjects;

@XmlType(name="MD_GeometricObjects_Type", propOrder={"geometricObjectType", "geometricObjectCount"})
@XmlRootElement(name="MD_GeometricObjects")
public class DefaultGeometricObjects
extends ISOMetadata
implements GeometricObjects {
    private static final long serialVersionUID = -7965994170083468201L;
    private GeometricObjectType geometricObjectType;
    private Integer geometricObjectCount;

    public DefaultGeometricObjects() {
    }

    public DefaultGeometricObjects(GeometricObjectType geometricObjectType) {
        this.geometricObjectType = geometricObjectType;
    }

    public DefaultGeometricObjects(GeometricObjects geometricObjects) {
        super(geometricObjects);
        if (geometricObjects != null) {
            this.geometricObjectType = geometricObjects.getGeometricObjectType();
            this.geometricObjectCount = geometricObjects.getGeometricObjectCount();
        }
    }

    public static DefaultGeometricObjects castOrCopy(GeometricObjects geometricObjects) {
        if (geometricObjects == null || geometricObjects instanceof DefaultGeometricObjects) {
            return (DefaultGeometricObjects)geometricObjects;
        }
        return new DefaultGeometricObjects(geometricObjects);
    }

    @Override
    @XmlElement(name="geometricObjectType", required=true)
    public GeometricObjectType getGeometricObjectType() {
        return this.geometricObjectType;
    }

    public void setGeometricObjectType(GeometricObjectType geometricObjectType) {
        this.checkWritePermission(this.geometricObjectType);
        this.geometricObjectType = geometricObjectType;
    }

    @Override
    @ValueRange(minimum=1.0)
    @XmlElement(name="geometricObjectCount")
    public Integer getGeometricObjectCount() {
        return this.geometricObjectCount;
    }

    public void setGeometricObjectCount(Integer n) {
        this.checkWritePermission(this.geometricObjectCount);
        if (ImplementationHelper.ensurePositive(DefaultGeometricObjects.class, "geometricObjectCount", true, n)) {
            this.geometricObjectCount = n;
        }
    }
}

