/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.quality;

import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.metadata.iso.quality.ISOMetadata;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.quality.Element;
import org.opengis.util.InternationalString;

@XmlType(name="DQ_MeasureReference_Type", propOrder={"measureIdentification", "namesOfMeasure", "measureDescription"})
@XmlRootElement(name="DQ_MeasureReference")
@UML(identifier="DQ_MeasureReference", specification=Specification.UNSPECIFIED)
public class DefaultMeasureReference
extends ISOMetadata {
    private static final long serialVersionUID = -1841855681786546466L;
    private Identifier measureIdentification;
    private Collection<InternationalString> namesOfMeasure;
    private InternationalString measureDescription;

    public DefaultMeasureReference() {
    }

    public DefaultMeasureReference(DefaultMeasureReference defaultMeasureReference) {
        super(defaultMeasureReference);
        if (defaultMeasureReference != null) {
            this.measureIdentification = defaultMeasureReference.getMeasureIdentification();
            this.measureDescription = defaultMeasureReference.getMeasureDescription();
            this.namesOfMeasure = this.copyCollection(defaultMeasureReference.getNamesOfMeasure(), InternationalString.class);
        }
    }

    final boolean setLegacy(Element element) {
        this.measureIdentification = element.getMeasureIdentification();
        boolean bl = null != this.measureIdentification;
        this.namesOfMeasure = this.copyCollection(element.getNamesOfMeasure(), InternationalString.class);
        this.measureDescription = CollectionsExt.first(element.getNamesOfMeasure());
        return bl | null != this.namesOfMeasure | null != this.measureDescription;
    }

    @XmlElement(name="measureIdentification")
    @UML(identifier="measureIdentification", obligation=Obligation.OPTIONAL, specification=Specification.UNSPECIFIED)
    public Identifier getMeasureIdentification() {
        return this.measureIdentification;
    }

    public void setMeasureIdentification(Identifier identifier) {
        this.checkWritePermission(this.measureIdentification);
        this.measureIdentification = identifier;
    }

    @XmlElement(name="nameOfMeasure")
    @UML(identifier="nameOfMeasure", obligation=Obligation.CONDITIONAL, specification=Specification.UNSPECIFIED)
    public Collection<InternationalString> getNamesOfMeasure() {
        this.namesOfMeasure = this.nonNullCollection(this.namesOfMeasure, InternationalString.class);
        return this.namesOfMeasure;
    }

    public void setNamesOfMeasure(Collection<? extends InternationalString> collection) {
        this.namesOfMeasure = this.writeCollection(collection, this.namesOfMeasure, InternationalString.class);
    }

    @XmlElement(name="measureDescription")
    @UML(identifier="measureDescription", obligation=Obligation.OPTIONAL, specification=Specification.UNSPECIFIED)
    public InternationalString getMeasureDescription() {
        return this.measureDescription;
    }

    public void setMeasureDescription(InternationalString internationalString) {
        this.checkWritePermission(this.measureDescription);
        this.measureDescription = internationalString;
    }
}

