/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.identification;

import java.net.URI;
import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.internal.jaxb.gcx.MimeFileTypeAdapter;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.citation.OnlineResource;
import org.opengis.metadata.constraint.Constraints;
import org.opengis.metadata.identification.BrowseGraphic;
import org.opengis.util.InternationalString;

@XmlType(name="MD_BrowseGraphic_Type", namespace="http://standards.iso.org/iso/19115/-3/mcc/1.0", propOrder={"fileName", "fileDescription", "fileType", "linkage", "imageConstraint"})
@XmlRootElement(name="MD_BrowseGraphic", namespace="http://standards.iso.org/iso/19115/-3/mcc/1.0")
public class DefaultBrowseGraphic
extends ISOMetadata
implements BrowseGraphic {
    private static final long serialVersionUID = 1769063690091153678L;
    private URI fileName;
    private InternationalString fileDescription;
    private String fileType;
    private Collection<Constraints> imageConstraints;
    private Collection<OnlineResource> linkages;

    public DefaultBrowseGraphic() {
    }

    public DefaultBrowseGraphic(URI uRI) {
        this.fileName = uRI;
    }

    public DefaultBrowseGraphic(BrowseGraphic browseGraphic) {
        super(browseGraphic);
        if (browseGraphic != null) {
            this.fileName = browseGraphic.getFileName();
            this.fileDescription = browseGraphic.getFileDescription();
            this.fileType = browseGraphic.getFileType();
            if (browseGraphic instanceof DefaultBrowseGraphic) {
                this.imageConstraints = this.copyCollection(((DefaultBrowseGraphic)browseGraphic).getImageConstraints(), Constraints.class);
                this.linkages = this.copyCollection(((DefaultBrowseGraphic)browseGraphic).getLinkages(), OnlineResource.class);
            }
        }
    }

    public static DefaultBrowseGraphic castOrCopy(BrowseGraphic browseGraphic) {
        if (browseGraphic == null || browseGraphic instanceof DefaultBrowseGraphic) {
            return (DefaultBrowseGraphic)browseGraphic;
        }
        return new DefaultBrowseGraphic(browseGraphic);
    }

    @Override
    @XmlElement(name="fileName", required=true)
    public URI getFileName() {
        return this.fileName;
    }

    public void setFileName(URI uRI) {
        this.checkWritePermission(this.fileName);
        this.fileName = uRI;
    }

    @Override
    @XmlElement(name="fileDescription")
    public InternationalString getFileDescription() {
        return this.fileDescription;
    }

    public void setFileDescription(InternationalString internationalString) {
        this.checkWritePermission(this.fileDescription);
        this.fileDescription = internationalString;
    }

    @Override
    @XmlElement(name="fileType")
    @XmlJavaTypeAdapter(value=MimeFileTypeAdapter.class)
    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String string) {
        this.checkWritePermission(this.fileType);
        this.fileType = string;
    }

    @UML(identifier="imageContraints", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Constraints> getImageConstraints() {
        this.imageConstraints = this.nonNullCollection(this.imageConstraints, Constraints.class);
        return this.imageConstraints;
    }

    public void setImageConstraints(Collection<? extends Constraints> collection) {
        this.imageConstraints = this.writeCollection(collection, this.imageConstraints, Constraints.class);
    }

    @UML(identifier="linkage", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<OnlineResource> getLinkages() {
        this.linkages = this.nonNullCollection(this.linkages, OnlineResource.class);
        return this.linkages;
    }

    public void setLinkages(Collection<? extends OnlineResource> collection) {
        this.linkages = this.writeCollection(collection, this.linkages, OnlineResource.class);
    }

    @XmlElement(name="imageConstraints")
    private Collection<Constraints> getImageConstraint() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getImageConstraints() : null;
    }

    @XmlElement(name="linkage")
    private Collection<OnlineResource> getLinkage() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getLinkages() : null;
    }
}

