/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.extent;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.extent.DefaultBoundingPolygon;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.metadata.iso.extent.DefaultGeographicDescription;
import org.opengis.metadata.extent.BoundingPolygon;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.extent.GeographicDescription;
import org.opengis.metadata.extent.GeographicExtent;

@XmlType(name="AbstractEX_GeographicExtent_Type")
@XmlRootElement(name="AbstractEX_GeographicExtent")
@XmlSeeAlso(value={DefaultGeographicBoundingBox.class, DefaultBoundingPolygon.class, DefaultGeographicDescription.class})
public class AbstractGeographicExtent
extends ISOMetadata
implements GeographicExtent {
    private static final long serialVersionUID = 4819196764221609265L;
    private Boolean inclusion;

    public AbstractGeographicExtent() {
    }

    public AbstractGeographicExtent(boolean bl) {
        this.inclusion = bl;
    }

    public AbstractGeographicExtent(GeographicExtent geographicExtent) {
        super(geographicExtent);
        if (geographicExtent != null) {
            this.inclusion = geographicExtent.getInclusion();
        }
    }

    public static AbstractGeographicExtent castOrCopy(GeographicExtent geographicExtent) {
        if (geographicExtent instanceof BoundingPolygon) {
            return DefaultBoundingPolygon.castOrCopy((BoundingPolygon)geographicExtent);
        }
        if (geographicExtent instanceof GeographicBoundingBox) {
            return DefaultGeographicBoundingBox.castOrCopy((GeographicBoundingBox)geographicExtent);
        }
        if (geographicExtent instanceof GeographicDescription) {
            return DefaultGeographicDescription.castOrCopy((GeographicDescription)geographicExtent);
        }
        if (geographicExtent == null || geographicExtent instanceof AbstractGeographicExtent) {
            return (AbstractGeographicExtent)geographicExtent;
        }
        return new AbstractGeographicExtent(geographicExtent);
    }

    @Override
    @XmlElement(name="extentTypeCode")
    public Boolean getInclusion() {
        return this.inclusion;
    }

    public void setInclusion(Boolean bl) {
        this.checkWritePermission(this.inclusion);
        this.inclusion = bl;
    }
}

