/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.acquisition;

import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.metadata.ImplementationHelper;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.metadata.acquisition.RequestedDate;

@XmlType(name="MI_RequestedDate_Type", propOrder={"requestedDateOfCollection", "latestAcceptableDate"})
@XmlRootElement(name="MI_RequestedDate")
public class DefaultRequestedDate
extends ISOMetadata
implements RequestedDate {
    private static final long serialVersionUID = 942236885315159329L;
    private long requestedDateOfCollection = Long.MIN_VALUE;
    private long latestAcceptableDate = Long.MIN_VALUE;

    public DefaultRequestedDate() {
    }

    public DefaultRequestedDate(RequestedDate requestedDate) {
        super(requestedDate);
        if (requestedDate != null) {
            this.requestedDateOfCollection = ImplementationHelper.toMilliseconds(requestedDate.getRequestedDateOfCollection());
            this.latestAcceptableDate = ImplementationHelper.toMilliseconds(requestedDate.getLatestAcceptableDate());
        }
    }

    public static DefaultRequestedDate castOrCopy(RequestedDate requestedDate) {
        if (requestedDate == null || requestedDate instanceof DefaultRequestedDate) {
            return (DefaultRequestedDate)requestedDate;
        }
        return new DefaultRequestedDate(requestedDate);
    }

    @Override
    @XmlElement(name="requestedDateOfCollection", required=true)
    public Date getRequestedDateOfCollection() {
        return ImplementationHelper.toDate(this.requestedDateOfCollection);
    }

    public void setRequestedDateOfCollection(Date date) {
        this.checkWritePermission(ImplementationHelper.toDate(this.requestedDateOfCollection));
        this.requestedDateOfCollection = ImplementationHelper.toMilliseconds(date);
    }

    @Override
    @XmlElement(name="latestAcceptableDate", required=true)
    public Date getLatestAcceptableDate() {
        return ImplementationHelper.toDate(this.latestAcceptableDate);
    }

    public void setLatestAcceptableDate(Date date) {
        this.checkWritePermission(ImplementationHelper.toDate(this.latestAcceptableDate));
        this.latestAcceptableDate = ImplementationHelper.toMilliseconds(date);
    }
}

