/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.logging.Logger;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.format.ParserException;
import org.apache.sis.internal.util.FinalFieldSetter;
import org.apache.sis.measure.Quantities;
import org.apache.sis.measure.UnitFormat;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.logging.Logging;

public class QuantityFormat
extends Format {
    private static final long serialVersionUID = 1014042719969477503L;
    public static final char SEPARATOR = '\u202f';
    protected final NumberFormat numberFormat;
    protected final UnitFormat unitFormat;

    public QuantityFormat(Locale locale) {
        ArgumentChecks.ensureNonNull("locale", locale);
        this.numberFormat = NumberFormat.getNumberInstance(locale);
        this.unitFormat = new UnitFormat(locale);
    }

    public QuantityFormat(NumberFormat numberFormat, UnitFormat unitFormat) {
        ArgumentChecks.ensureNonNull("numberFormat", numberFormat);
        ArgumentChecks.ensureNonNull("unitFormat", unitFormat);
        this.numberFormat = numberFormat;
        this.unitFormat = unitFormat;
    }

    @Override
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        Quantity quantity = (Quantity)object;
        if (fieldPosition == null) {
            fieldPosition = new FieldPosition(0);
        }
        stringBuffer = this.numberFormat.format(quantity.getValue(), stringBuffer, fieldPosition).append('\u202f');
        stringBuffer = this.unitFormat.format(quantity.getUnit(), stringBuffer, fieldPosition);
        return stringBuffer;
    }

    @Override
    public Object parseObject(String string, ParsePosition parsePosition) {
        int n = parsePosition.getIndex();
        Number number = this.numberFormat.parse(string, parsePosition);
        if (number != null) {
            try {
                Unit<?> unit = this.unitFormat.parse(string, parsePosition);
                if (unit != null) {
                    return Quantities.create(number.doubleValue(), unit);
                }
            }
            catch (ParserException parserException) {
                Logging.ignorableException(Logger.getLogger("org.apache.sis.measure"), QuantityFormat.class, "parseObject", parserException);
            }
            parsePosition.setIndex(n);
        }
        return null;
    }

    @Override
    public QuantityFormat clone() {
        QuantityFormat quantityFormat = (QuantityFormat)super.clone();
        try {
            FinalFieldSetter.set(QuantityFormat.class, "numberFormat", "unitFormat", quantityFormat, this.numberFormat.clone(), this.unitFormat.clone());
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw FinalFieldSetter.cloneFailure(reflectiveOperationException);
        }
        return quantityFormat;
    }
}

