/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.image;

import java.io.Closeable;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.internal.referencing.j2d.AffineTransform2D;
import org.apache.sis.internal.storage.MetadataBuilder;
import org.apache.sis.internal.storage.PRJDataStore;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.storage.image.FormatFinder;
import org.apache.sis.internal.storage.image.WarningListener;
import org.apache.sis.internal.storage.image.WorldFileResource;
import org.apache.sis.internal.storage.image.WorldFileStoreProvider;
import org.apache.sis.internal.util.ListOfUnknownSize;
import org.apache.sis.metadata.sql.MetadataStoreException;
import org.apache.sis.setup.OptionKey;
import org.apache.sis.storage.DataStoreClosedException;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreReferencingException;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.ReadOnlyStorageException;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.UnsupportedStorageException;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.TransformException;

public class WorldFileStore
extends PRJDataStore {
    private static final String[] KNOWN_FORMATS = new String[]{"PNG"};
    static final int MAIN_IMAGE = 0;
    private static final String DEFAULT_SUFFIX = "wld";
    static final PixelInCell CELL_ANCHOR = PixelInCell.CELL_CENTER;
    final String suffix;
    private String suffixWLD;
    private ImageReader reader;
    private Closeable toClose;
    private int width;
    private int height;
    private GridGeometry gridGeometry;
    private Components components;
    private Metadata metadata;
    final Map<String, Boolean> identifiers;

    public WorldFileStore(WorldFileStoreProvider worldFileStoreProvider, StorageConnector storageConnector) throws DataStoreException, IOException {
        this(new FormatFinder(worldFileStoreProvider, storageConnector), true);
    }

    WorldFileStore(FormatFinder formatFinder, boolean bl) throws DataStoreException, IOException {
        super(formatFinder.provider, formatFinder.connector);
        this.listeners.useReadOnlyEvents();
        this.identifiers = new HashMap<String, Boolean>();
        this.suffix = formatFinder.suffix;
        if (formatFinder.storage instanceof Closeable) {
            this.toClose = (Closeable)formatFinder.storage;
        }
        if (bl || !formatFinder.openAsWriter) {
            this.reader = formatFinder.getOrCreateReader();
            if (this.reader == null) {
                throw new UnsupportedStorageException(super.getLocale(), "World file", formatFinder.storage, formatFinder.connector.getOption(OptionKey.OPEN_OPTIONS));
            }
            this.configureReader();
            if (bl) {
                formatFinder.close();
            }
        }
    }

    private void configureReader() {
        try {
            this.reader.setLocale(this.listeners.getLocale());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.reader.addIIOReadWarningListener(new WarningListener(this.listeners));
    }

    private String getWorldFileSuffix() {
        int n;
        if (this.suffix != null && this.suffix.codePointCount(0, n = this.suffix.length()) >= 2) {
            int n2;
            boolean bl = true;
            for (int i = n; i > 0 && !(bl = Character.isLowerCase(n2 = this.suffix.codePointBefore(i))); i -= Character.charCount(n2)) {
                boolean bl2 = bl = !Character.isUpperCase(n2);
                if (!bl) break;
            }
            return new StringBuilder(3).appendCodePoint(this.suffix.codePointAt(0)).appendCodePoint(this.suffix.codePointBefore(n)).append(bl ? (char)'w' : 'W').toString();
        }
        return DEFAULT_SUFFIX;
    }

    private AffineTransform2D readWorldFile() throws IOException, DataStoreException {
        IOException iOException = null;
        String string = this.getWorldFileSuffix();
        int n = 0;
        block7: while (true) {
            String string2;
            switch (n) {
                default: {
                    break block7;
                }
                case 0: {
                    string2 = string;
                    break;
                }
                case 2: {
                    string2 = DEFAULT_SUFFIX;
                    break;
                }
                case 1: {
                    if (string.equals(DEFAULT_SUFFIX)) break block7;
                    string2 = this.suffix + string.charAt(string.length() - 1);
                }
            }
            try {
                return this.readWorldFile(string2);
            }
            catch (FileNotFoundException | NoSuchFileException iOException2) {
                if (iOException == null) {
                    iOException = iOException2;
                } else {
                    iOException.addSuppressed(iOException2);
                }
                ++n;
                continue;
            }
            break;
        }
        if (iOException != null) {
            this.listeners.warning(this.resources().getString((short)66, string), iOException);
        }
        return null;
    }

    private AffineTransform2D readWorldFile(String string) throws IOException, DataStoreException {
        int n;
        PRJDataStore.AuxiliaryContent auxiliaryContent = this.readAuxiliaryFile(string);
        if (auxiliaryContent == null) {
            this.listeners.warning(Resources.format((short)66, string));
            return null;
        }
        String string2 = auxiliaryContent.getFilename();
        CharSequence[] charSequenceArray = CharSequences.splitOnEOL(auxiliaryContent);
        int n2 = 0;
        double[] dArray = new double[6];
        for (n = 0; n < 6; ++n) {
            String string3 = charSequenceArray[n].toString().trim();
            if (string3.isEmpty() || string3.charAt(0) == '#') continue;
            if (n2 >= 6) {
                throw new DataStoreContentException(this.errors().getString((short)130, 6, "coefficient"));
            }
            try {
                dArray[n2++] = Double.parseDouble(string3);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw new DataStoreContentException(this.errors().getString((short)33, string2, n), numberFormatException);
            }
        }
        if (n2 != 6) {
            throw new EOFException(this.errors().getString((short)137, string2));
        }
        if (string2 != null && (n = string2.lastIndexOf(46)) >= 0) {
            this.suffixWLD = string2.substring(n + 1);
        }
        return new AffineTransform2D(dArray);
    }

    final Resources resources() {
        return Resources.forLocale(this.listeners.getLocale());
    }

    private Errors errors() {
        return Errors.getResources(this.listeners.getLocale());
    }

    public String[] getImageFormat(boolean bl) {
        ImageReaderSpi imageReaderSpi;
        if (this.reader != null && (imageReaderSpi = this.reader.getOriginatingProvider()) != null) {
            String[] stringArray;
            String[] stringArray2 = stringArray = bl ? imageReaderSpi.getMIMETypes() : imageReaderSpi.getFormatNames();
            if (stringArray != null) {
                return stringArray;
            }
        }
        return CharSequences.EMPTY_ARRAY;
    }

    @Override
    public synchronized Path[] getComponentFiles() throws DataStoreException {
        if (this.suffixWLD == null) {
            try {
                this.getGridGeometry(0);
            }
            catch (IOException iOException) {
                throw new DataStoreException(iOException);
            }
        }
        return this.listComponentFiles(this.suffixWLD, "prj");
    }

    final GridGeometry getGridGeometry(int n) throws IOException, DataStoreException {
        assert (Thread.holdsLock(this));
        ImageReader imageReader = this.reader();
        if (this.gridGeometry == null) {
            this.width = imageReader.getWidth(0);
            this.height = imageReader.getHeight(0);
            AffineTransform2D affineTransform2D = this.readWorldFile();
            this.readPRJ();
            this.gridGeometry = new GridGeometry(new GridExtent((long)this.width, this.height), CELL_ANCHOR, affineTransform2D, this.crs);
        }
        if (n != 0) {
            int n2 = imageReader.getWidth(n);
            int n3 = imageReader.getHeight(n);
            if (n2 != this.width || n3 != this.height) {
                return new GridGeometry(new GridExtent((long)n2, n3), CELL_ANCHOR, null, null);
            }
        }
        return this.gridGeometry;
    }

    String setGridGeometry(int n, GridGeometry gridGeometry) throws IOException, DataStoreException {
        if (n != 0) {
            return null;
        }
        GridExtent gridExtent = gridGeometry.getExtent();
        int n2 = Math.toIntExact(gridExtent.getSize(0));
        int n3 = Math.toIntExact(gridExtent.getSize(1));
        String string = this.suffixWLD != null ? this.suffixWLD : this.getWorldFileSuffix();
        this.crs = gridGeometry.isDefined(1) ? gridGeometry.getCoordinateReferenceSystem() : null;
        this.gridGeometry = gridGeometry;
        this.width = n2;
        this.height = n3;
        this.suffixWLD = string;
        return string;
    }

    @Override
    public synchronized Metadata getMetadata() throws DataStoreException {
        if (this.metadata == null) {
            try {
                MetadataBuilder metadataBuilder = new MetadataBuilder();
                String string = this.reader().getFormatName();
                for (String string2 : KNOWN_FORMATS) {
                    if (!string2.equalsIgnoreCase(string)) continue;
                    try {
                        metadataBuilder.setPredefinedFormat(string2);
                        string = null;
                    }
                    catch (MetadataStoreException metadataStoreException) {
                        this.listeners.warning(Level.FINE, null, metadataStoreException);
                    }
                    break;
                }
                metadataBuilder.addFormatName(string);
                metadataBuilder.addResourceScope(ScopeCode.valueOf("COVERAGE"), null);
                metadataBuilder.addSpatialRepresentation(null, this.getGridGeometry(0), true);
                if (this.gridGeometry.isDefined(2)) {
                    metadataBuilder.addExtent(this.gridGeometry.getEnvelope());
                }
                this.addTitleOrIdentifier(metadataBuilder);
                metadataBuilder.setISOStandards(false);
                this.metadata = metadataBuilder.buildAndFreeze();
            }
            catch (IOException iOException) {
                throw new DataStoreException(iOException);
            }
            catch (TransformException transformException) {
                throw new DataStoreReferencingException(transformException);
            }
        }
        return this.metadata;
    }

    public synchronized Collection<? extends GridCoverageResource> components() throws DataStoreException {
        if (this.components == null) {
            try {
                this.components = new Components(this.reader().getNumImages(false));
            }
            catch (IOException iOException) {
                throw new DataStoreException(iOException);
            }
        }
        return this.components;
    }

    final Components components(boolean bl, int n) {
        if (this.components == null && bl) {
            this.components = new Components(n);
        }
        return this.components;
    }

    void remove(Resource resource) throws DataStoreException {
        throw new ReadOnlyStorageException();
    }

    WorldFileResource createImageResource(int n) throws DataStoreException, IOException {
        return new WorldFileResource(this, this.listeners, n, this.getGridGeometry(n));
    }

    boolean isComponentHidden() {
        return false;
    }

    ImageReader prepareReader(ImageReader imageReader) throws IOException {
        return null;
    }

    final ImageReader getCurrentReader() {
        return this.reader;
    }

    final ImageReader reader() throws DataStoreException, IOException {
        assert (Thread.holdsLock(this));
        ImageReader imageReader = this.reader;
        if (imageReader == null || imageReader.getInput() == null) {
            this.reader = imageReader = this.prepareReader(imageReader);
            if (imageReader == null) {
                throw new DataStoreClosedException(this.getLocale(), "World file", StandardOpenOption.READ);
            }
            this.configureReader();
        }
        return imageReader;
    }

    @Override
    public synchronized void close() throws DataStoreException {
        this.listeners.close();
        ImageReader imageReader = this.reader;
        Closeable closeable = this.toClose;
        this.reader = null;
        this.toClose = null;
        this.metadata = null;
        this.components = null;
        this.gridGeometry = null;
        try {
            Object object = null;
            if (imageReader != null) {
                object = imageReader.getInput();
                imageReader.setInput(null);
                imageReader.dispose();
                if (object instanceof AutoCloseable) {
                    ((AutoCloseable)object).close();
                }
            }
            if (closeable != null && closeable != object) {
                closeable.close();
            }
        }
        catch (Exception exception) {
            throw new DataStoreException(exception);
        }
    }

    final class Components
    extends ListOfUnknownSize<WorldFileResource> {
        private int size;
        private WorldFileResource[] images;

        private Components(int n) {
            this.size = n;
            this.images = new WorldFileResource[Math.max(n, 1)];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            WorldFileStore worldFileStore = WorldFileStore.this;
            synchronized (worldFileStore) {
                if (this.size < 0) {
                    try {
                        this.size = WorldFileStore.this.reader().getNumImages(true);
                        this.images = ArraysExt.resize(this.images, this.size);
                    }
                    catch (IOException iOException) {
                        throw new UncheckedIOException(iOException);
                    }
                    catch (DataStoreException dataStoreException) {
                        throw new BackingStoreException(dataStoreException);
                    }
                }
                return this.size;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected int sizeIfKnown() {
            WorldFileStore worldFileStore = WorldFileStore.this;
            synchronized (worldFileStore) {
                return this.size;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean exists(int n) {
            WorldFileStore worldFileStore = WorldFileStore.this;
            synchronized (worldFileStore) {
                if (this.size >= 0) {
                    return n >= 0 && n < this.size;
                }
                try {
                    return this.get(n) != null;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    return false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public WorldFileResource get(int n) {
            WorldFileStore worldFileStore = WorldFileStore.this;
            synchronized (worldFileStore) {
                WorldFileResource worldFileResource = null;
                if (n < this.images.length) {
                    worldFileResource = this.images[n];
                }
                if (worldFileResource == null) {
                    try {
                        worldFileResource = WorldFileStore.this.createImageResource(n);
                        if (n >= this.images.length) {
                            this.images = Arrays.copyOf(this.images, Math.max(this.images.length * 2, n + 1));
                        }
                        this.images[n] = worldFileResource;
                    }
                    catch (IOException iOException) {
                        throw new UncheckedIOException(iOException);
                    }
                    catch (DataStoreException dataStoreException) {
                        throw new BackingStoreException(dataStoreException);
                    }
                }
                return worldFileResource;
            }
        }

        final void added(WorldFileResource worldFileResource) {
            this.size = worldFileResource.getImageIndex();
            if (this.size >= this.images.length) {
                this.images = Arrays.copyOf(this.images, this.size * 2);
            }
            this.images[this.size++] = worldFileResource;
        }

        final void removed(int n) throws DataStoreException {
            int n2 = this.images.length - 1;
            System.arraycopy(this.images, n + 1, this.images, n, n2 - n);
            this.images[n2] = null;
            --this.size;
            while (n < n2) {
                WorldFileResource worldFileResource;
                if ((worldFileResource = this.images[n++]) == null) continue;
                worldFileResource.decrementImageIndex();
            }
        }

        @Override
        public WorldFileResource remove(int n) {
            WorldFileResource worldFileResource = this.get(n);
            try {
                WorldFileStore.this.remove(worldFileResource);
            }
            catch (DataStoreException dataStoreException) {
                throw new UnsupportedOperationException(dataStoreException);
            }
            return worldFileResource;
        }
    }
}

