/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.folder;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.apache.sis.internal.storage.MetadataBuilder;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.storage.StoreResource;
import org.apache.sis.internal.storage.StoreUtilities;
import org.apache.sis.internal.storage.folder.StoreProvider;
import org.apache.sis.internal.storage.folder.UnstructuredAggregate;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.setup.OptionKey;
import org.apache.sis.storage.DataOptionKey;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.DataStores;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.UnsupportedStorageException;
import org.apache.sis.storage.aggregate.CoverageAggregator;
import org.apache.sis.util.collection.BackingStoreException;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.util.GenericName;
import org.opengis.util.LocalName;
import org.opengis.util.NameFactory;
import org.opengis.util.NameSpace;

class Store
extends DataStore
implements StoreResource,
UnstructuredAggregate,
DirectoryStream.Filter<Path> {
    private final Store originator;
    protected final Path location;
    private GenericName identifier;
    protected final Locale locale;
    protected final TimeZone timezone;
    protected final Charset encoding;
    final Map<Path, DataStore> children;
    private transient Metadata metadata;
    transient Collection<Resource> components;
    protected final DataStoreProvider componentProvider;
    private transient boolean sharedRepositoryReported;
    private transient Resource structuredView;

    Store(DataStoreProvider dataStoreProvider, StorageConnector storageConnector, Path path, DataStoreProvider dataStoreProvider2) throws DataStoreException, IOException {
        super(dataStoreProvider, storageConnector);
        this.originator = this;
        this.location = path;
        this.locale = storageConnector.getOption(OptionKey.LOCALE);
        this.timezone = storageConnector.getOption(OptionKey.TIMEZONE);
        this.encoding = storageConnector.getOption(OptionKey.ENCODING);
        this.children = new ConcurrentHashMap<Path, DataStore>();
        this.children.put(path.toRealPath(new LinkOption[0]), this);
        this.componentProvider = dataStoreProvider2;
    }

    private Store(Store store, StorageConnector storageConnector, NameFactory nameFactory) throws DataStoreException {
        super(store, store.getProvider(), storageConnector, false);
        this.originator = store;
        this.locale = storageConnector.getOption(OptionKey.LOCALE);
        this.timezone = storageConnector.getOption(OptionKey.TIMEZONE);
        this.encoding = storageConnector.getOption(OptionKey.ENCODING);
        this.location = storageConnector.commit(Path.class, "folder");
        this.children = store.children;
        this.componentProvider = store.componentProvider;
        this.identifier = nameFactory.createLocalName(store.identifier(nameFactory).scope(), super.getDisplayName());
    }

    @Override
    public DataStore getOriginator() {
        return this.originator;
    }

    @Override
    public Optional<ParameterValueGroup> getOpenParameters() {
        String string = StoreUtilities.getFormatName(this.componentProvider);
        ParameterValueGroup parameterValueGroup = (this.provider != null ? this.provider.getOpenParameters() : StoreProvider.PARAMETERS).createValue();
        parameterValueGroup.parameter("location").setValue(this.location);
        if (this.locale != null) {
            parameterValueGroup.parameter("locale").setValue(this.locale);
        }
        if (this.timezone != null) {
            parameterValueGroup.parameter("timezone").setValue(this.timezone);
        }
        if (this.encoding != null) {
            parameterValueGroup.parameter("encoding").setValue(this.encoding);
        }
        if (string != null) {
            parameterValueGroup.parameter("format").setValue(string);
        }
        return Optional.of(parameterValueGroup);
    }

    @Override
    public boolean accept(Path path) throws IOException {
        return !Files.isHidden(path);
    }

    @Override
    public Optional<GenericName> getIdentifier() {
        return Optional.of(this.identifier(null));
    }

    private synchronized GenericName identifier(NameFactory nameFactory) {
        if (this.identifier == null) {
            if (nameFactory == null) {
                nameFactory = DefaultFactories.forBuildin(NameFactory.class);
            }
            LocalName localName = nameFactory.createLocalName(null, super.getDisplayName());
            NameSpace nameSpace = nameFactory.createNameSpace(localName, Collections.singletonMap("separator", "/"));
            this.identifier = nameFactory.createLocalName(nameSpace, ".");
        }
        return this.identifier;
    }

    @Override
    public synchronized Metadata getMetadata() {
        if (this.metadata == null) {
            MetadataBuilder metadataBuilder = new MetadataBuilder();
            metadataBuilder.addResourceScope(ScopeCode.valueOf("COLLECTION"), Resources.formatInternational((short)35, this.getDisplayName()));
            metadataBuilder.addLanguage(this.locale, MetadataBuilder.Scope.RESOURCE);
            metadataBuilder.addEncoding(this.encoding, MetadataBuilder.Scope.RESOURCE);
            String string = null;
            if (this.identifier != null && ".".equals(string = this.identifier.toString())) {
                string = null;
            }
            if (string == null) {
                string = super.getDisplayName();
            }
            metadataBuilder.addTitleOrIdentifier(string, MetadataBuilder.Scope.RESOURCE);
            this.metadata = metadataBuilder.buildAndFreeze();
        }
        return this.metadata;
    }

    public synchronized Collection<Resource> components() throws DataStoreException {
        if (this.components == null) {
            ArrayList<DataStore> arrayList = new ArrayList<DataStore>();
            NameFactory nameFactory = DefaultFactories.forBuildin(NameFactory.class);
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(this.location, this);){
                for (Path path : directoryStream) {
                    Path path2 = path.toRealPath(new LinkOption[0]);
                    DataStore dataStore = this.children.get(path2);
                    if (dataStore instanceof Store) {
                        ((Store)dataStore).sharedRepository(path2);
                    }
                    if (dataStore == null) {
                        block25: {
                            StorageConnector storageConnector = new StorageConnector(path);
                            storageConnector.setOption(OptionKey.LOCALE, this.locale);
                            storageConnector.setOption(OptionKey.TIMEZONE, this.timezone);
                            storageConnector.setOption(OptionKey.ENCODING, this.encoding);
                            storageConnector.setOption(DataOptionKey.PARENT_LISTENERS, this.listeners);
                            try {
                                if (this.componentProvider == null) {
                                    dataStore = DataStores.open(storageConnector);
                                    break block25;
                                }
                                if (this.componentProvider.probeContent(storageConnector).isSupported()) {
                                    dataStore = this.componentProvider.open(storageConnector);
                                    break block25;
                                }
                                if (Files.isDirectory(path, new LinkOption[0])) {
                                    dataStore = new Store(this, storageConnector, nameFactory);
                                    break block25;
                                }
                                storageConnector.closeAllExcept(null);
                                continue;
                            }
                            catch (UnsupportedStorageException unsupportedStorageException) {
                                if (!Files.isDirectory(path, new LinkOption[0])) {
                                    storageConnector.closeAllExcept(null);
                                    this.listeners.warning(Level.FINE, null, unsupportedStorageException);
                                    continue;
                                }
                                dataStore = new Store(this, storageConnector, nameFactory);
                            }
                            catch (DataStoreException dataStoreException) {
                                try {
                                    storageConnector.closeAllExcept(null);
                                }
                                catch (DataStoreException dataStoreException2) {
                                    dataStoreException.addSuppressed(dataStoreException2);
                                }
                                throw dataStoreException;
                            }
                        }
                        DataStore dataStore2 = this.children.putIfAbsent(path2, dataStore);
                        if (dataStore2 != null) {
                            dataStore.close();
                            dataStore = dataStore2;
                            if (dataStore instanceof Store) {
                                ((Store)dataStore).sharedRepository(path2);
                            }
                        }
                    }
                    arrayList.add(dataStore);
                }
            }
            catch (UncheckedIOException | DirectoryIteratorException runtimeException) {
                throw new DataStoreException(this.canNotRead(), runtimeException.getCause());
            }
            catch (IOException iOException) {
                throw new DataStoreException(this.canNotRead(), iOException);
            }
            catch (BackingStoreException backingStoreException) {
                throw backingStoreException.unwrapOrRethrow(DataStoreException.class);
            }
            this.components = UnmodifiableArrayList.wrap(arrayList.toArray(new Resource[arrayList.size()]));
        }
        return this.components;
    }

    private String canNotRead() {
        return this.message((short)34, this.getDisplayName());
    }

    private void sharedRepository(Path path) {
        if (!this.sharedRepositoryReported) {
            this.sharedRepositoryReported = true;
            this.listeners.warning(this.message((short)36, path));
        }
    }

    @Override
    public synchronized Resource getStructuredView() throws DataStoreException {
        if (this.structuredView == null) {
            CoverageAggregator coverageAggregator = new CoverageAggregator(this.listeners);
            coverageAggregator.addComponents(this);
            this.structuredView = coverageAggregator.build();
        }
        return this.structuredView;
    }

    final Resources messages() {
        return Resources.forLocale(this.getLocale());
    }

    final String message(short s2, Object object) {
        return this.messages().getString(s2, object);
    }

    @Override
    public synchronized void close() throws DataStoreException {
        this.listeners.close();
        Collection<Resource> collection = this.components;
        if (collection != null) {
            this.components = null;
            DataStoreException dataStoreException = null;
            for (Resource resource : collection) {
                if (!(resource instanceof DataStore)) continue;
                try {
                    ((DataStore)resource).close();
                }
                catch (DataStoreException dataStoreException2) {
                    if (dataStoreException == null) {
                        dataStoreException = dataStoreException2;
                        continue;
                    }
                    dataStoreException.addSuppressed(dataStoreException2);
                }
            }
            if (dataStoreException != null) {
                throw dataStoreException;
            }
        }
    }
}

