/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.esri;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridCoverage2D;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.internal.coverage.j2d.ColorModelFactory;
import org.apache.sis.internal.coverage.j2d.ImageUtilities;
import org.apache.sis.internal.storage.MetadataBuilder;
import org.apache.sis.internal.storage.PRJDataStore;
import org.apache.sis.internal.storage.RangeArgument;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.math.Statistics;
import org.apache.sis.metadata.sql.MetadataStoreException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.DataStoreReferencingException;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.referencing.operation.TransformException;

abstract class RasterStore
extends PRJDataStore
implements GridCoverageResource {
    private static final int VISIBLE_BAND = 0;
    static final String NROWS = "NROWS";
    static final String NCOLS = "NCOLS";
    static final String STX = "stx";
    static final String CLR = "clr";
    private ColorModel colorModel;
    private List<SampleDimension> sampleDimensions;
    double nodataValue = Double.NaN;
    Metadata metadata;
    private static final short[] RGB_BAND_NAMES = new short[]{167, 96, 18, 201};

    RasterStore(DataStoreProvider dataStoreProvider, StorageConnector storageConnector) throws DataStoreException {
        super(dataStoreProvider, storageConnector);
        this.listeners.useReadOnlyEvents();
    }

    @Override
    public Path[] getComponentFiles() throws DataStoreException {
        return this.listComponentFiles("prj", STX, CLR);
    }

    @Override
    public Optional<Envelope> getEnvelope() throws DataStoreException {
        return Optional.ofNullable(this.getGridGeometry().getEnvelope());
    }

    final void createMetadata(String string, String string2) throws DataStoreException {
        GridGeometry gridGeometry = this.getGridGeometry();
        MetadataBuilder metadataBuilder = new MetadataBuilder();
        try {
            metadataBuilder.setPredefinedFormat(string2);
        }
        catch (MetadataStoreException metadataStoreException) {
            metadataBuilder.addFormatName(string);
            this.listeners.warning(metadataStoreException);
        }
        metadataBuilder.addResourceScope(ScopeCode.valueOf("COVERAGE"), null);
        metadataBuilder.addEncoding(this.encoding, MetadataBuilder.Scope.METADATA);
        metadataBuilder.addSpatialRepresentation(null, gridGeometry, true);
        try {
            metadataBuilder.addExtent(gridGeometry.getEnvelope());
        }
        catch (TransformException transformException) {
            throw new DataStoreReferencingException(this.getLocale(), string, this.getDisplayName(), null).initCause(transformException);
        }
        if (this.sampleDimensions != null) {
            for (SampleDimension sampleDimension : this.sampleDimensions) {
                metadataBuilder.addNewBand(sampleDimension);
            }
        }
        this.addTitleOrIdentifier(metadataBuilder);
        metadataBuilder.setISOStandards(false);
        this.metadata = metadataBuilder.buildAndFreeze();
    }

    /*
     * WARNING - void declaration
     */
    private ColorModel readColorMap(int n, int n2, int n3) throws DataStoreException, IOException {
        void var7_10;
        int n4;
        int n5;
        int n52;
        switch (n) {
            case 0: {
                n52 = 255;
                break;
            }
            case 1: {
                n52 = 65535;
                break;
            }
            default: {
                return null;
            }
        }
        int n6 = 0;
        long[] lArray = ArraysExt.EMPTY_LONG;
        CharSequence[] objectArray = CharSequences.splitOnEOL(this.readAuxiliaryFile(CLR));
        int n7 = objectArray.length;
        for (n5 = 0; n5 < n7; ++n5) {
            CharSequence charSequence = objectArray[n5];
            n4 = CharSequences.skipTrailingWhitespaces(charSequence, 0, charSequence.length());
            int n8 = CharSequences.skipLeadingWhitespaces(charSequence, 0, n4);
            if (n8 >= n4 || !Character.isDigit(Character.codePointAt(charSequence, n8))) continue;
            int n9 = 0;
            long l = 0L;
            for (CharSequence charSequence2 : CharSequences.split(charSequence.subSequence(n8, n4), ' ')) {
                if (charSequence2.length() == 0) continue;
                int n10 = Integer.parseInt(charSequence2.toString());
                if (n9 == 0) {
                    l = (long)n10 << 32;
                } else {
                    n10 = Math.max(0, Math.min(255, n10));
                    l |= (long)(n10 << (3 - n9) * 8);
                }
                if (++n9 >= 4) break;
            }
            if (n6 >= lArray.length) {
                lArray = Arrays.copyOf(lArray, Math.max(n6 * 2, 64));
            }
            lArray[n6++] = l | 0xFF000000L;
        }
        if (n6 <= 1) {
            return null;
        }
        Arrays.sort(lArray, 0, n6);
        int[] nArray = new int[Math.max(n2, Math.toIntExact((lArray[n6 - 1] >>> 32) + 1L))];
        int[] nArray2 = new int[2];
        for (n5 = 1; n5 < n6; ++n5) {
            n4 = (int)(lArray[n5] >>> 32);
            int n11 = (int)(lArray[n5 - 1] >>> 32);
            if (n4 >= n11) {
                nArray2[0] = (int)lArray[n5 - 1];
                nArray2[1] = (int)lArray[n5];
                ColorModelFactory.expand(nArray2, nArray, n11, n4 + 1);
            }
            if (n4 <= n52) continue;
            int[] nArray3 = Arrays.copyOf(nArray, n52 + 1);
            break;
        }
        return ColorModelFactory.createIndexColorModel(n3, 0, (int[])var7_10, true, -1);
    }

    private Statistics[] readStatistics(String string, SampleModel sampleModel) throws DataStoreException, IOException {
        Statistics[] statisticsArray = new Statistics[sampleModel.getNumBands()];
        for (CharSequence charSequence : CharSequences.splitOnEOL(this.readAuxiliaryFile(STX))) {
            int n = CharSequences.skipTrailingWhitespaces(charSequence, 0, charSequence.length());
            int n2 = CharSequences.skipLeadingWhitespaces(charSequence, 0, n);
            if (n2 >= n || !Character.isDigit(Character.codePointAt(charSequence, n2))) continue;
            int n3 = 0;
            int n4 = 0;
            double d = Double.NaN;
            double d2 = Double.NaN;
            double d3 = Double.NaN;
            double d4 = Double.NaN;
            for (CharSequence charSequence2 : CharSequences.split(charSequence.subSequence(n2, n), ' ')) {
                if (charSequence2.length() == 0) continue;
                if (n3 == 0) {
                    n4 = Integer.parseInt(charSequence2.toString());
                } else if (charSequence2.charAt(0) != '#') {
                    double d5 = Double.parseDouble(charSequence2.toString());
                    switch (n3) {
                        case 1: {
                            d = d5;
                            break;
                        }
                        case 2: {
                            d2 = d5;
                            break;
                        }
                        case 3: {
                            d3 = d5;
                            break;
                        }
                        case 4: {
                            d4 = d5;
                        }
                    }
                }
                ++n3;
            }
            if (n4 < true || n4 > statisticsArray.length) continue;
            int n5 = Math.multiplyExact(sampleModel.getWidth(), sampleModel.getHeight());
            statisticsArray[n4 - 1] = new Statistics(string, 0, n5, d, d2, d3, d4, false);
        }
        return statisticsArray;
    }

    final void loadBandDescriptions(String string, SampleModel sampleModel, Statistics ... statisticsArray) throws DataStoreException {
        SampleDimension[] sampleDimensionArray = new SampleDimension[sampleModel.getNumBands()];
        try {
            statisticsArray = this.readStatistics(string, sampleModel);
        }
        catch (IOException | NumberFormatException exception) {
            this.canNotReadAuxiliaryFile(STX, exception);
        }
        int n = sampleModel.getDataType();
        boolean bl = ImageUtilities.isIntegerType(n);
        boolean bl2 = bl && ImageUtilities.isUnsignedType(sampleModel);
        boolean bl3 = bl && (sampleDimensionArray.length == 3 || sampleDimensionArray.length == 4);
        SampleDimension.Builder builder = new SampleDimension.Builder();
        for (int i = 0; i < sampleDimensionArray.length; ++i) {
            Statistics statistics;
            double d = Double.NaN;
            double d2 = Double.NaN;
            if (i < statisticsArray.length && (statistics = statisticsArray[i]) != null) {
                d = statistics.minimum();
                d2 = statistics.maximum();
            }
            if (!(d <= d2)) {
                d = 0.0;
                d2 = 1.0;
                if (bl) {
                    long l = Numerics.bitmask(sampleModel.getSampleSize(i)) - 1L;
                    if (!bl2) {
                        d = (l >>>= 1) ^ 0xFFFFFFFFFFFFFFFFL;
                    }
                    d2 = l;
                }
            }
            if (bl3) {
                builder.setName(Vocabulary.formatInternational(RGB_BAND_NAMES[i]));
            } else {
                if (string != null) {
                    builder.setName(string);
                    string = null;
                }
                builder.addQuantitative(null, d, d2, null);
                if (this.nodataValue < d || this.nodataValue > d2) {
                    builder.mapQualitative(null, this.nodataValue, Float.NaN);
                }
            }
            sampleDimensionArray[i] = builder.build().forConvertedValues(!bl);
            builder.clear();
            if (i != 0) continue;
            if (bl3) {
                this.colorModel = ColorModelFactory.createRGB(sampleModel);
                continue;
            }
            try {
                this.colorModel = this.readColorMap(n, (int)(d2 + 1.0), sampleDimensionArray.length);
            }
            catch (IOException | NumberFormatException exception) {
                this.canNotReadAuxiliaryFile(CLR, exception);
            }
            if (this.colorModel != null) continue;
            this.colorModel = ColorModelFactory.createGrayScale(n, sampleDimensionArray.length, i, d, d2);
        }
        this.sampleDimensions = UnmodifiableArrayList.wrap(sampleDimensionArray);
    }

    private void canNotReadAuxiliaryFile(String string, Exception exception) {
        Level level = Level.WARNING;
        if (exception instanceof NoSuchFileException || exception instanceof FileNotFoundException) {
            level = Level.FINE;
        }
        this.listeners.warning(level, Resources.format((short)66, string), exception);
    }

    final GridCoverage2D createCoverage(GridGeometry gridGeometry, RangeArgument rangeArgument, WritableRaster writableRaster, Statistics statistics) {
        Object object;
        Hashtable<String, Object[]> hashtable = null;
        if (statistics != null) {
            object = new Statistics[rangeArgument.getNumBands()];
            Arrays.fill((Object[])object, statistics);
            hashtable = new Hashtable<String, Object[]>();
            hashtable.put("org.apache.sis.Statistics", (Object[])object);
        }
        object = this.sampleDimensions;
        ColorModel colorModel = this.colorModel;
        if (!rangeArgument.isIdentity()) {
            object = Arrays.asList(rangeArgument.select(this.sampleDimensions));
            if ((colorModel = (ColorModel)rangeArgument.select(colorModel).orElse(null)) == null) {
                SampleDimension sampleDimension = (SampleDimension)object.get(0);
                colorModel = ColorModelFactory.createGrayScale(writableRaster.getSampleModel(), 0, sampleDimension.getSampleRange().orElse(null));
            }
        }
        return new GridCoverage2D(gridGeometry, (List<? extends SampleDimension>)object, new BufferedImage(colorModel, writableRaster, false, hashtable));
    }

    @Override
    public List<SampleDimension> getSampleDimensions() throws DataStoreException {
        return this.sampleDimensions;
    }

    @Override
    public void close() throws DataStoreException {
        this.metadata = null;
    }
}

