/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage;

import java.util.Collection;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.metadata.iso.lineage.DefaultSource;
import org.apache.sis.metadata.iso.maintenance.DefaultScope;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.identification.DataIdentification;
import org.opengis.metadata.identification.Identification;
import org.opengis.metadata.identification.Resolution;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.util.InternationalString;

final class ResourceLineage {
    private InternationalString description;
    private Citation sourceCitation;
    private DefaultScope scope;
    private ReferenceSystem referenceSystem;
    private Resolution resolution;

    final boolean isEmpty() {
        return this.description == null && this.sourceCitation == null && this.scope == null && this.referenceSystem == null && this.resolution == null;
    }

    ResourceLineage(Metadata metadata) {
        this.referenceSystem = CollectionsExt.first(metadata.getReferenceSystemInfo());
        for (Identification object2 : CollectionsExt.nonNull(metadata.getIdentificationInfo())) {
            Citation citation = object2.getCitation();
            if (citation != null) {
                if (this.sourceCitation == null) {
                    this.sourceCitation = citation;
                }
                if (this.description == null) {
                    this.description = citation.getTitle();
                }
            }
            if (this.resolution != null || !(object2 instanceof DataIdentification)) continue;
            for (Resolution resolution : CollectionsExt.nonNull(((DataIdentification)object2).getSpatialResolutions())) {
                if (resolution == null) continue;
                this.resolution = resolution;
            }
        }
        ScopeCode scopeCode = ResourceLineage.getScopeLevel(metadata);
        Collection<? extends Extent> collection = Extents.fromIdentificationInfo(metadata);
        if (scopeCode != null || !collection.isEmpty()) {
            this.scope = new DefaultScope(scopeCode);
            this.scope.setExtents(collection);
        }
    }

    private static ScopeCode getScopeLevel(Metadata metadata) {
        ScopeCode scopeCode = null;
        for (ScopeCode scopeCode2 : CollectionsExt.nonNull(metadata.getHierarchyLevels())) {
            if (scopeCode2 == null) continue;
            if (scopeCode == null) {
                scopeCode = scopeCode2;
                continue;
            }
            if (scopeCode.equals(scopeCode2)) continue;
            scopeCode = null;
            break;
        }
        return scopeCode;
    }

    final DefaultSource build() {
        DefaultSource defaultSource = new DefaultSource();
        defaultSource.setDescription(this.description);
        defaultSource.setSourceCitation(this.sourceCitation);
        defaultSource.setScope(this.scope);
        defaultSource.setSourceReferenceSystem(this.referenceSystem);
        defaultSource.setSourceSpatialResolution(this.resolution);
        return defaultSource;
    }
}

