/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage;

import java.awt.image.RenderedImage;
import java.util.Arrays;
import java.util.List;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridCoverageBuilder;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.GridRoundingMode;
import org.apache.sis.image.ImageProcessor;
import org.apache.sis.internal.storage.RangeArgument;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.storage.AbstractGridCoverageResource;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.referencing.datum.PixelInCell;

public class MemoryGridResource
extends AbstractGridCoverageResource {
    public final GridCoverage coverage;

    public MemoryGridResource(StoreListeners storeListeners, GridCoverage gridCoverage) {
        super(storeListeners, false);
        ArgumentChecks.ensureNonNull("coverage", gridCoverage);
        this.coverage = gridCoverage;
    }

    @Override
    public GridGeometry getGridGeometry() {
        return this.coverage.getGridGeometry();
    }

    @Override
    public List<SampleDimension> getSampleDimensions() {
        return this.coverage.getSampleDimensions();
    }

    @Override
    public GridCoverage read(GridGeometry gridGeometry, int ... nArray) {
        List<SampleDimension> list = this.coverage.getSampleDimensions();
        RangeArgument rangeArgument = RangeArgument.validate(list.size(), nArray, this.listeners);
        GridExtent gridExtent = null;
        GridGeometry gridGeometry2 = this.coverage.getGridGeometry();
        if (gridGeometry == null) {
            gridGeometry = gridGeometry2;
        } else {
            gridExtent = gridGeometry2.derive().rounding(GridRoundingMode.ENCLOSING).subgrid(gridGeometry).getIntersection();
            if (gridExtent.equals(gridGeometry2.getExtent())) {
                gridExtent = null;
                gridGeometry = gridGeometry2;
            }
        }
        boolean bl = rangeArgument.isIdentity();
        if (bl && gridExtent == null) {
            return this.coverage;
        }
        RenderedImage renderedImage = this.coverage.render(gridExtent);
        if (gridExtent != null) {
            int[] nArray2 = gridExtent.getSubspaceDimensions(2);
            int n = nArray2[0];
            int n2 = nArray2[1];
            long l = gridExtent.getLow(n);
            long l2 = gridExtent.getLow(n2);
            long[] lArray = new long[Math.max(n, n2) + 1];
            int n3 = lArray.length;
            while (--n3 >= 0) {
                lArray[n3] = gridExtent.getSize(n3);
            }
            lArray[n] = renderedImage.getWidth();
            lArray[n2] = renderedImage.getHeight();
            gridExtent = gridExtent.resize(lArray);
            Arrays.fill(lArray, 0L);
            lArray[n] = Math.addExact(l - gridExtent.getLow(n), (long)renderedImage.getMinX());
            lArray[n2] = Math.addExact(l2 - gridExtent.getLow(n2), (long)renderedImage.getMinX());
            gridExtent = gridExtent.translate(lArray);
            if (gridExtent.equals(gridGeometry2.getExtent())) {
                if (bl) {
                    return this.coverage;
                }
                gridGeometry = gridGeometry2;
            } else {
                gridGeometry = new GridGeometry(gridExtent, PixelInCell.CELL_CORNER, gridGeometry2.getGridToCRS(PixelInCell.CELL_CORNER), gridGeometry2.getCoordinateReferenceSystem());
            }
        }
        if (!bl) {
            renderedImage = new ImageProcessor().selectBands(renderedImage, nArray);
            list = UnmodifiableArrayList.wrap(rangeArgument.select(list));
        }
        return new GridCoverageBuilder().setValues(renderedImage).setRanges(list).setDomain(gridGeometry).build();
    }
}

