/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.j2d;

import java.awt.geom.Path2D;
import org.opengis.referencing.operation.TransformException;

public abstract class Bezier {
    private static final int DEPTH_LIMIT = 12;
    private static final int MAXIMUM_ITERATIONS = 4;
    private final Path2D path;
    protected double \u03b5x;
    protected double \u03b5y;
    private double x0;
    private double y0;
    private double dx0;
    private double dy0;
    protected double dx;
    protected double dy;
    protected final double[] point;
    protected int depth;
    protected boolean forceCubic;

    protected Bezier(int n) {
        this.point = new double[n];
        this.path = new Path2D.Double();
    }

    protected abstract void evaluateAt(double var1) throws TransformException;

    public final Path2D build() throws TransformException {
        this.evaluateAt(0.0);
        this.x0 = this.point[0];
        this.y0 = this.point[1];
        this.dx0 = this.dx;
        this.dy0 = this.dy;
        this.path.moveTo(this.x0, this.y0);
        this.evaluateAt(0.5);
        double d = this.point[0];
        double d2 = this.point[1];
        double d3 = this.dx;
        double d4 = this.dy;
        this.evaluateAt(1.0);
        this.sequence(0.0, 1.0, d, d2, d3, d4, this.point[0], this.point[1], this.dx, this.dy);
        return this.path;
    }

    private void sequence(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) throws TransformException {
        this.evaluateAt(0.25 * d + 0.75 * d2);
        double d11 = this.point[0];
        double d12 = this.point[1];
        double d13 = this.dx;
        double d14 = this.dy;
        double d15 = this.\u03b5x;
        double d16 = this.\u03b5y;
        this.evaluateAt(0.75 * d + 0.25 * d2);
        double d17 = this.point[0];
        double d18 = this.point[1];
        double d19 = this.dx;
        double d20 = this.dy;
        if (d15 < this.\u03b5x) {
            this.\u03b5x = d15;
        }
        if (d16 < this.\u03b5y) {
            this.\u03b5y = d16;
        }
        if (this.curve(d17, d18, d3, d4, d11, d12, d7, d8, d9, d10)) {
            this.x0 = d7;
            this.y0 = d8;
            this.dx0 = d9;
            this.dy0 = d10;
        } else {
            ++this.depth;
            double d21 = this.\u03b5x;
            double d22 = this.\u03b5y;
            double d23 = 0.5 * (d + d2);
            this.sequence(d, d23, d17, d18, d19, d20, d3, d4, d5, d6);
            this.sequence(d23, d2, d11, d12, d13, d14, d7, d8, d9, d10);
            this.\u03b5x = d21;
            this.\u03b5y = d22;
            --this.depth;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean curve(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
        double d11;
        double d12;
        double d13;
        double d14;
        d -= this.x0;
        d3 -= this.x0;
        d5 -= this.x0;
        d2 -= this.y0;
        d4 -= this.y0;
        d6 -= this.y0;
        double d15 = d7 - this.x0;
        double d16 = d8 - this.y0;
        if (!this.forceCubic && (Math.abs(this.dx0) >= Math.abs(this.dy0) ? Math.abs(d15 * (this.dy0 / this.dx0) - d16) <= this.\u03b5y : Math.abs(d16 * (this.dx0 / this.dy0) - d15) <= this.\u03b5x) && (Math.abs(d9) >= Math.abs(d10) ? Math.abs(d15 * (d10 / d9) - d16) <= this.\u03b5y : Math.abs(d16 * (d9 / d10) - d15) <= this.\u03b5x)) {
            if (this.depth < 12) {
                if (Math.abs(d15) >= Math.abs(d16)) {
                    double d17 = d16 / d15;
                    if (Math.abs(d17 * d3 - d4) > this.\u03b5y) return false;
                    if (Math.abs(d17 * d - d2) > this.\u03b5y) return false;
                    if (Math.abs(d17 * d5 - d6) > this.\u03b5y) {
                        return false;
                    }
                } else {
                    double d18 = d15 / d16;
                    if (Math.abs(d18 * d4 - d3) > this.\u03b5x) return false;
                    if (Math.abs(d18 * d2 - d) > this.\u03b5x) return false;
                    if (Math.abs(d18 * d6 - d5) > this.\u03b5x) {
                        return false;
                    }
                }
            }
            this.path.lineTo(d7, d8);
            return true;
        }
        double d19 = ((8.0 * d3 - 4.0 * d15) * d10 - (8.0 * d4 - 4.0 * d16) * d9) / (3.0 * (this.dx0 * d10 - this.dy0 * d9));
        double d20 = d19 * this.dx0;
        double d21 = d19 * this.dy0;
        if (Math.abs(d9) >= Math.abs(d10)) {
            d14 = (8.0 * d3 - d15) / 3.0 - d20;
            d13 = d16 - (d15 - d14) * (d10 / d9);
        } else {
            d13 = (8.0 * d4 - d16) / 3.0 - d21;
            d14 = d15 - (d16 - d13) * (d9 / d10);
        }
        if (this.depth < 12) {
            d12 = 0.421875 * d20 + 0.140625 * d14 + 0.015625 * d15;
            d11 = 0.421875 * d21 + 0.140625 * d13 + 0.015625 * d16;
            if ((Math.abs(d12 - d) > this.\u03b5x || Math.abs(d11 - d2) > this.\u03b5y) && !this.isNear(d12, d11, 0.25, d20, d21, 1.6875, d14, d13, 1.125, d15, d16, 0.1875, d, d2)) {
                return false;
            }
            d12 = 0.140625 * d20 + 0.421875 * d14 + 0.421875 * d15;
            d11 = 0.140625 * d21 + 0.421875 * d13 + 0.421875 * d16;
            if ((Math.abs(d12 - d5) > this.\u03b5x || Math.abs(d11 - d6) > this.\u03b5y) && !this.isNear(d12, d11, 0.75, d20, d21, 0.1875, d14, d13, 1.125, d15, d16, 1.6875, d5, d6)) {
                return false;
            }
        }
        if (!this.forceCubic) {
            double d22;
            d12 = (3.0 * (d14 - d20) - d15) / 2.0;
            if (Math.abs(d22) <= 2.0 * this.\u03b5x) {
                double d23;
                d11 = (3.0 * (d13 - d21) - d16) / 2.0;
                if (Math.abs(d23) <= 2.0 * this.\u03b5y) {
                    double d24 = (3.0 * d20 + d12) / 2.0;
                    double d25 = (3.0 * d21 + d11) / 2.0;
                    this.path.quadTo(d24 + this.x0, d25 + this.y0, d7, d8);
                    return true;
                }
            }
        }
        this.path.curveTo(d20 + this.x0, d21 + this.y0, d14 + this.x0, d13 + this.y0, d7, d8);
        return true;
    }

    private boolean isNear(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14) {
        double d15 = d7 - d4;
        double d16 = d8 - d5;
        double d17 = d10 - d7;
        double d18 = d11 - d8;
        int n = 4;
        while (true) {
            double d19;
            double d20;
            double d21;
            double d22;
            double d23 = d6 * d4 + d9 * d15 + d12 * d17;
            double d24 = d6 * d5 + d9 * d16 + d12 * d18;
            if (Math.abs(d23) >= Math.abs(d24)) {
                d22 = d24 / d23;
                d21 = d2 - d22 * d;
                d20 = ((d14 - d21) * d22 + d13) / (d22 * d22 + 1.0);
                d3 += (d20 - d) / d23;
            } else {
                d22 = d23 / d24;
                d21 = d - d22 * d2;
                d19 = ((d13 - d21) * d22 + d14) / (d22 * d22 + 1.0);
                d3 += (d19 - d2) / d24;
            }
            if (d3 < 0.0) {
                d3 = 0.0;
            } else if (d3 > 1.0) {
                d3 = 1.0;
            }
            d6 = 1.0 - d3;
            d9 = 3.0 * d6;
            d12 = d3 * d3;
            d20 = ((d4 * d6 + d3 * d7) * d9 + d10 * d12) * d3;
            d19 = ((d5 * d6 + d3 * d8) * d9 + d11 * d12) * d3;
            if (Math.abs(d20 - d13) <= this.\u03b5x && Math.abs(d19 - d14) <= this.\u03b5y) {
                return true;
            }
            if (--n < 0 || !(Math.abs(d20 - d) > this.\u03b5x / 2.0) && !(Math.abs(d19 - d2) > this.\u03b5y / 2.0)) break;
            d6 *= d9;
            d9 *= 2.0 * d3;
            d12 *= 3.0;
            d = d20;
            d2 = d19;
        }
        return false;
    }
}

