/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing;

import org.apache.sis.geometry.GeneralDirectPosition;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Utilities;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public final class PositionTransformer
extends GeneralDirectPosition {
    private final CoordinateOperationFactory factory;
    public final CoordinateReferenceSystem defaultCRS;
    private transient CoordinateReferenceSystem lastCRS;
    private transient MathTransform forward;
    private transient MathTransform inverse;

    public PositionTransformer(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, CoordinateOperationFactory coordinateOperationFactory) {
        super(coordinateReferenceSystem2);
        ArgumentChecks.ensureNonNull("targetCRS", coordinateReferenceSystem2);
        this.defaultCRS = coordinateReferenceSystem != null ? coordinateReferenceSystem : coordinateReferenceSystem2;
        this.factory = coordinateOperationFactory != null ? coordinateOperationFactory : DefaultFactories.forBuildin(CoordinateOperationFactory.class);
    }

    @Override
    public void setCoordinateReferenceSystem(CoordinateReferenceSystem coordinateReferenceSystem) throws MismatchedDimensionException {
        ArgumentChecks.ensureNonNull("targetCRS", coordinateReferenceSystem);
        super.setCoordinateReferenceSystem(coordinateReferenceSystem);
        this.forward = null;
        this.inverse = null;
    }

    private void setSourceCRS(CoordinateReferenceSystem coordinateReferenceSystem) throws TransformException {
        CoordinateOperation coordinateOperation;
        CoordinateReferenceSystem coordinateReferenceSystem2 = this.getCoordinateReferenceSystem();
        try {
            coordinateOperation = this.factory.createOperation(coordinateReferenceSystem, coordinateReferenceSystem2);
        }
        catch (FactoryException factoryException) {
            throw new TransformException(factoryException.getLocalizedMessage(), factoryException);
        }
        this.forward = coordinateOperation.getMathTransform();
        this.inverse = null;
        this.lastCRS = coordinateReferenceSystem;
        if (this.forward.isIdentity()) {
            this.forward = null;
        }
    }

    public void transform(double[] dArray) throws TransformException {
        if (dArray != null) {
            if (this.lastCRS != this.defaultCRS) {
                this.setSourceCRS(this.defaultCRS);
            }
            if (this.forward != null) {
                this.forward.transform(dArray, 0, dArray, 0, 1);
            }
        }
    }

    public DirectPosition transform(DirectPosition directPosition) throws TransformException {
        if (directPosition != null) {
            CoordinateReferenceSystem coordinateReferenceSystem = directPosition.getCoordinateReferenceSystem();
            if (coordinateReferenceSystem == null) {
                coordinateReferenceSystem = this.defaultCRS;
            }
            if (!Utilities.equalsIgnoreMetadata(this.lastCRS, coordinateReferenceSystem)) {
                this.setSourceCRS(coordinateReferenceSystem);
            }
            if (this.forward != null) {
                return this.forward.transform(directPosition, this);
            }
        }
        return directPosition;
    }

    private MathTransform inverse() throws TransformException {
        if (this.inverse == null) {
            if (!Utilities.equalsIgnoreMetadata(this.lastCRS, this.defaultCRS)) {
                this.setSourceCRS(this.defaultCRS);
            }
            this.inverse = this.forward != null ? this.forward.inverse() : MathTransforms.identity(this.getDimension());
        }
        return this.inverse;
    }

    public DirectPosition inverseTransform() throws TransformException {
        return this.inverse().transform(this, new GeneralDirectPosition(this.defaultCRS));
    }

    public Matrix inverseTransform(double[] dArray) throws TransformException {
        return MathTransforms.derivativeAndTransform(this.inverse(), this.coordinates, 0, dArray, 0);
    }
}

