/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.processing.isoline;

import java.awt.Shape;
import java.util.AbstractList;
import java.util.NavigableMap;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.sis.internal.processing.isoline.Isolines;
import org.apache.sis.util.resources.Errors;

final class Result
extends AbstractList<NavigableMap<Double, Shape>> {
    private Future<Isolines[]> task;
    private NavigableMap<Double, Shape>[] isolines;

    Result(Future<Isolines[]> future) {
        this.task = future;
    }

    private NavigableMap<Double, Shape>[] isolines() {
        if (this.isolines == null) {
            if (this.task == null) {
                throw new CompletionException(Errors.format((short)191), null);
            }
            try {
                this.isolines = Isolines.toArray(this.task.get());
                this.task = null;
            }
            catch (InterruptedException interruptedException) {
                throw new CompletionException(Errors.format((short)192), interruptedException);
            }
            catch (ExecutionException executionException) {
                this.task = null;
                throw new CompletionException(Errors.format((short)191), executionException.getCause());
            }
        }
        return this.isolines;
    }

    @Override
    public int size() {
        return this.isolines().length;
    }

    @Override
    public NavigableMap<Double, Shape> get(int n) {
        return this.isolines()[n];
    }

    @Override
    public Object[] toArray() {
        return (Object[])this.isolines().clone();
    }
}

