/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf;

import java.util.Collection;
import java.util.Locale;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.netcdf.NamedElement;
import org.apache.sis.internal.netcdf.Resources;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.math.Vector;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.resources.Errors;

public abstract class Node
extends NamedElement {
    protected final Decoder decoder;

    protected Node(Decoder decoder) {
        this.decoder = decoder;
    }

    public abstract Collection<String> getAttributeNames();

    public abstract Class<?> getAttributeType(String var1);

    protected abstract Object getAttributeValue(String var1);

    public final String getAttributeAsString(String string) {
        Object object = this.getAttributeValue(string);
        if (object == null || object instanceof String) {
            return (String)object;
        }
        String[] stringArray = Node.toArray(object);
        if (stringArray == null) {
            return object.toString();
        }
        String string2 = null;
        for (String string3 : stringArray) {
            if (string3 == null) continue;
            if (string2 == null) {
                string2 = string3;
                continue;
            }
            if (string2.equals(string3)) continue;
            return null;
        }
        return string2;
    }

    public final CharSequence[] getAttributeAsStrings(String string, char c) {
        Object object = this.getAttributeValue(string);
        if (object != null) {
            CharSequence[] charSequenceArray = Node.toArray(object);
            if (charSequenceArray == null) {
                charSequenceArray = CharSequences.split(object.toString(), c);
            }
            if (charSequenceArray.length != 0) {
                return charSequenceArray;
            }
        }
        return null;
    }

    private static String[] toArray(Object object) {
        int n;
        String[] stringArray;
        Object object2;
        if (object instanceof String[]) {
            return (String[])object;
        }
        if (object instanceof Object[]) {
            object2 = (Object[])object;
            stringArray = new String[((Object[])object2).length];
            for (n = 0; n < stringArray.length; ++n) {
                Object object3 = object2[n];
                if (object3 == null) continue;
                stringArray[n] = object3.toString();
            }
        } else if (object instanceof Vector) {
            object2 = (Vector)object;
            stringArray = new String[((Vector)object2).size()];
            for (n = 0; n < stringArray.length; ++n) {
                stringArray[n] = ((Vector)object2).stringValue(n);
            }
        } else {
            return null;
        }
        boolean bl = false;
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = Strings.trimOrNull(stringArray[n]);
            bl |= stringArray[n] != null;
        }
        return bl ? stringArray : null;
    }

    public final Number getAttributeAsNumber(String string) {
        Number number = null;
        Object object = this.getAttributeValue(string);
        if (object instanceof Number) {
            number = (Number)object;
        } else if (object instanceof String) {
            number = this.decoder.parseNumber(string, (String)object);
        } else if (object instanceof Vector) {
            Vector vector = (Vector)object;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                Number number2 = vector.get(i);
                if (number2 == null) continue;
                if (number == null) {
                    number = number2;
                    continue;
                }
                if (number.equals(number2)) continue;
                return null;
            }
        }
        return number;
    }

    public final double getAttributeAsDouble(String string) {
        Number number = this.getAttributeAsNumber(string);
        if (number == null) {
            return Double.NaN;
        }
        double d = number.doubleValue();
        float f = (float)d;
        if ((double)f == d) {
            d = DecimalFunctions.floatToDouble(f);
        }
        return d;
    }

    public final Vector getAttributeAsVector(String string) {
        Object object = this.getAttributeValue(string);
        if (object instanceof Vector) {
            return (Vector)object;
        }
        if (object instanceof Float) {
            return Vector.createForDecimal(new float[]{((Float)object).floatValue()});
        }
        if (object instanceof Number) {
            return Vector.create(new Number[]{(Number)object}, false);
        }
        return null;
    }

    protected final Locale getLocale() {
        return this.decoder.listeners.getLocale();
    }

    protected final Resources resources() {
        return Resources.forLocale(this.getLocale());
    }

    final Errors errors() {
        return Errors.getResources(this.getLocale());
    }

    protected final void warning(Class<?> clazz, String string, short s2, Object ... objectArray) {
        Node.warning(this.decoder.listeners, clazz, string, null, null, s2, objectArray);
    }

    protected final void error(Class<?> clazz, String string, Exception exception, short s2, Object ... objectArray) {
        Node.warning(this.decoder.listeners, clazz, string, exception, this.errors(), s2, objectArray);
    }
}

