/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.gco;

import java.util.UUID;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.SpecializedIdentifier;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.IdentifiedObject;
import org.apache.sis.xml.IdentifierMap;
import org.apache.sis.xml.IdentifierSpace;
import org.apache.sis.xml.MarshalContext;
import org.apache.sis.xml.ReferenceResolver;
import org.apache.sis.xml.XLink;
import org.opengis.metadata.Identifier;

final class ObjectReference {
    UUID uuid;
    XLink xlink;

    ObjectReference() {
    }

    ObjectReference(UUID uUID, XLink xLink) {
        this.uuid = uUID;
        this.xlink = xLink;
    }

    final <T> T resolve(Context context, Class<T> clazz, T t2) {
        if (t2 == null) {
            ReferenceResolver referenceResolver = Context.resolver(context);
            if (!(this.uuid != null && (t2 = referenceResolver.resolve((MarshalContext)context, clazz, this.uuid)) != null || this.xlink != null && (t2 = referenceResolver.resolve((MarshalContext)context, clazz, this.xlink)) != null)) {
                int n = 0;
                Identifier[] identifierArray = new SpecializedIdentifier[2];
                if (this.uuid != null) {
                    identifierArray[n++] = new SpecializedIdentifier<UUID>(IdentifierSpace.UUID, this.uuid);
                }
                if (this.xlink != null) {
                    identifierArray[n++] = new SpecializedIdentifier<XLink>(IdentifierSpace.XLINK, this.xlink);
                }
                identifierArray = ArraysExt.resize(identifierArray, n);
                t2 = referenceResolver.newIdentifiedObject(context, clazz, identifierArray);
            }
        } else if (t2 instanceof IdentifiedObject) {
            IdentifierMap identifierMap = ((IdentifiedObject)t2).getIdentifierMap();
            ObjectReference.putInto(context, identifierMap, IdentifierSpace.UUID, this.uuid);
            ObjectReference.putInto(context, identifierMap, IdentifierSpace.XLINK, this.xlink);
        }
        return t2;
    }

    private static <T> void putInto(Context context, IdentifierMap identifierMap, IdentifierSpace<T> identifierSpace, T t2) {
        T t3;
        if (t2 != null && (t3 = identifierMap.putSpecialized(identifierSpace, t2)) != null && !t3.equals(t2)) {
            Context.warningOccured(context, IdentifierMap.class, "putSpecialized", Errors.class, (short)67, identifierSpace.getName(), t2);
            identifierMap.putSpecialized(identifierSpace, t3);
        }
    }
}

