/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.cat;

import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.internal.jaxb.cat.CodeListUID;
import org.apache.sis.util.iso.Types;
import org.opengis.util.CodeList;

public abstract class CodeListAdapter<ValueType extends CodeListAdapter<ValueType, BoundType>, BoundType extends CodeList<BoundType>>
extends XmlAdapter<ValueType, BoundType> {
    protected CodeListUID identifier;

    protected CodeListAdapter() {
    }

    protected CodeListAdapter(CodeListUID codeListUID) {
        this.identifier = codeListUID;
    }

    protected abstract ValueType wrap(CodeListUID var1);

    protected abstract Class<BoundType> getCodeListClass();

    protected final boolean accept2014() {
        return FilterByVersion.CURRENT_METADATA.accept();
    }

    @Override
    public final BoundType unmarshal(ValueType ValueType) {
        return ValueType != null ? (BoundType)Types.forCodeName(this.getCodeListClass(), ((CodeListAdapter)ValueType).identifier.toString(), true) : null;
    }

    @Override
    public final ValueType marshal(BoundType BoundType2) {
        CodeListUID codeListUID;
        if (BoundType2 == null) {
            return null;
        }
        if (this.isEnum()) {
            codeListUID = new CodeListUID();
            codeListUID.value = Types.getCodeName(BoundType2);
        } else {
            codeListUID = new CodeListUID(Context.current(), (CodeList<?>)BoundType2);
        }
        return this.wrap(codeListUID);
    }

    protected boolean isEnum() {
        return false;
    }

    public abstract CodeListUID getElement();
}

