/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.coverage.j2d;

import java.awt.Point;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.apache.sis.image.DataType;
import org.apache.sis.internal.coverage.j2d.ColorModelFactory;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Static;
import org.apache.sis.util.collection.WeakHashSet;

public final class RasterFactory
extends Static {
    private static final WeakHashSet<SampleModel> POOL = new WeakHashSet<SampleModel>(SampleModel.class);

    private RasterFactory() {
    }

    public static BufferedImage createGrayScaleImage(int n, int n2, int n3, int n4, int n5, double d, double d2) {
        switch (n) {
            case 0: 
            case 1: {
                if (n4 != 1 || !ColorModelFactory.isStandardRange(n, d, d2)) break;
                return new BufferedImage(n2, n3, n == 0 ? 10 : 11);
            }
        }
        ColorModel colorModel = ColorModelFactory.createGrayScale(n, n4, n5, d, d2);
        return new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(n2, n3), false, null);
    }

    public static WritableRaster createRaster(DataBuffer dataBuffer, int n, int n2, int n3, int n4, int[] nArray, int[] nArray2, Point point) {
        ComponentSampleModel componentSampleModel;
        int n5 = dataBuffer.getDataType();
        if (dataBuffer.getNumBanks() == 1 && (nArray == null || nArray[0] == 0)) {
            switch (n5) {
                case 0: 
                case 1: {
                    return WritableRaster.createInterleavedRaster(dataBuffer, n, n2, n4, n3, nArray2, point);
                }
                case 3: {
                    if (nArray2.length != 1 || n3 != 1) break;
                    return WritableRaster.createBandedRaster(dataBuffer, n, n2, n4, new int[1], nArray2, point);
                }
            }
            componentSampleModel = new PixelInterleavedSampleModel(n5, n, n2, n3, n4, nArray2);
        } else {
            if (nArray == null) {
                nArray = ArraysExt.range(0, nArray2.length);
            }
            if (n3 == 1) {
                switch (n5) {
                    case 0: 
                    case 1: 
                    case 3: {
                        return WritableRaster.createBandedRaster(dataBuffer, n, n2, n4, nArray, nArray2, point);
                    }
                }
                componentSampleModel = new BandedSampleModel(n5, n, n2, n4, nArray, nArray2);
            } else {
                componentSampleModel = new ComponentSampleModel(n5, n, n2, n3, n4, nArray, nArray2);
            }
        }
        return WritableRaster.createWritableRaster(RasterFactory.unique(componentSampleModel), dataBuffer, point);
    }

    public static Buffer createBuffer(DataType dataType, int n) {
        switch (dataType) {
            case USHORT: 
            case SHORT: {
                return ShortBuffer.allocate(n);
            }
            case BYTE: {
                return ByteBuffer.allocate(n);
            }
            case INT: {
                return IntBuffer.allocate(n);
            }
            case FLOAT: {
                return FloatBuffer.allocate(n);
            }
            case DOUBLE: {
                return DoubleBuffer.allocate(n);
            }
        }
        throw new AssertionError((Object)dataType);
    }

    public static DataBuffer wrap(DataType dataType, Buffer ... bufferArray) {
        Object object;
        int n = bufferArray.length;
        switch (dataType) {
            case USHORT: 
            case SHORT: {
                object = new short[n][];
                break;
            }
            case INT: {
                object = new int[n][];
                break;
            }
            case BYTE: {
                object = new byte[n][];
                break;
            }
            case FLOAT: {
                object = new float[n][];
                break;
            }
            case DOUBLE: {
                object = new double[n][];
                break;
            }
            default: {
                throw new AssertionError((Object)dataType);
            }
        }
        int[] nArray = new int[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Buffer buffer = bufferArray[i];
            ArgumentChecks.ensureNonNullElement("data", i, buffer);
            object[i] = (short[])buffer.array();
            nArray[i] = Math.addExact(buffer.arrayOffset(), buffer.position());
            int n3 = buffer.remaining();
            if (i == 0) {
                n2 = n3;
                continue;
            }
            if (n2 == n3) continue;
            throw new RasterFormatException(Resources.format((short)41));
        }
        switch (dataType) {
            case BYTE: {
                return new DataBufferByte((byte[][])object, n2, nArray);
            }
            case SHORT: {
                return new DataBufferShort((short[][])object, n2, nArray);
            }
            case USHORT: {
                return new DataBufferUShort((short[][])object, n2, nArray);
            }
            case INT: {
                return new DataBufferInt((int[][])object, n2, nArray);
            }
            case FLOAT: {
                return new DataBufferFloat((float[][])object, n2, nArray);
            }
            case DOUBLE: {
                return new DataBufferDouble((double[][])object, n2, nArray);
            }
        }
        throw new AssertionError((Object)dataType);
    }

    static <T extends SampleModel> T unique(T t2) {
        return POOL.unique(t2);
    }
}

