/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.converter;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.sis.internal.converter.Column;
import org.apache.sis.internal.converter.SystemConverter;
import org.apache.sis.math.FunctionProperty;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ObjectConverter;
import org.apache.sis.util.UnconvertibleObjectException;
import org.apache.sis.util.collection.TreeTable;

final class FallbackConverter<S, T>
extends SystemConverter<S, T> {
    private static final long serialVersionUID = 6331789192804695560L;
    final ObjectConverter<S, ? extends T> primary;
    final ObjectConverter<S, ? extends T> fallback;

    private FallbackConverter(Class<S> clazz, Class<T> clazz2, ObjectConverter<S, ? extends T> objectConverter, ObjectConverter<S, ? extends T> objectConverter2) {
        super(clazz, clazz2);
        if (FallbackConverter.needSwap(objectConverter, objectConverter2.getClass())) {
            this.primary = objectConverter2;
            this.fallback = objectConverter;
        } else {
            this.primary = objectConverter;
            this.fallback = objectConverter2;
        }
    }

    private static <S> boolean needSwap(ObjectConverter<S, ?> objectConverter, Class<?> clazz) {
        if (objectConverter instanceof FallbackConverter) {
            FallbackConverter fallbackConverter = (FallbackConverter)objectConverter;
            return FallbackConverter.needSwap(fallbackConverter.primary, clazz) && FallbackConverter.needSwap(fallbackConverter.fallback, clazz);
        }
        Class<?> clazz2 = objectConverter.getTargetClass();
        return clazz.isAssignableFrom(clazz2) && !clazz2.isAssignableFrom(clazz);
    }

    public static <S, T> ObjectConverter<S, ? extends T> merge(ObjectConverter<S, ? extends T> objectConverter, ObjectConverter<S, ? extends T> objectConverter2) {
        Object object;
        Class<? extends T> clazz;
        ArgumentChecks.ensureNonNull("primary", objectConverter);
        ArgumentChecks.ensureNonNull("fallback", objectConverter2);
        assert (!(objectConverter2 instanceof FallbackConverter)) : objectConverter2;
        ObjectConverter<S, ? extends T> objectConverter3 = FallbackConverter.mergeIfSubtype(objectConverter, objectConverter2, null);
        if (objectConverter3 != null) {
            return objectConverter3;
        }
        Class<S> clazz2 = objectConverter.getSourceClass();
        Class<? extends T> clazz3 = objectConverter.getTargetClass();
        Class<Object> clazz4 = Classes.findCommonClass(clazz3, clazz = objectConverter2.getTargetClass());
        if (clazz4 == Object.class) {
            object = Classes.findCommonInterfaces(clazz3, clazz);
            object.removeAll(Arrays.asList(Classes.getAllInterfaces(clazz2)));
            Iterator<Class<?>> iterator = object.iterator();
            if (iterator.hasNext()) {
                clazz4 = iterator.next();
            }
        }
        assert (clazz4.isAssignableFrom(clazz3)) : clazz3;
        assert (clazz4.isAssignableFrom(clazz)) : clazz;
        object = new FallbackConverter<S, T>(clazz2, clazz4, objectConverter, objectConverter2);
        return object;
    }

    private static <S, T> ObjectConverter<S, ? extends T> mergeIfSubtype(ObjectConverter<S, T> objectConverter, ObjectConverter<S, ?> objectConverter2, Class<? super T> clazz) {
        if (objectConverter.equals(objectConverter2)) {
            return objectConverter;
        }
        Class<T> clazz2 = objectConverter.getTargetClass();
        if (!clazz2.isAssignableFrom(objectConverter2.getTargetClass())) {
            return null;
        }
        ObjectConverter<S, ?> objectConverter3 = objectConverter2;
        if (objectConverter instanceof FallbackConverter) {
            return ((FallbackConverter)objectConverter).merge(objectConverter3, clazz);
        }
        return new FallbackConverter<S, T>(objectConverter.getSourceClass(), clazz2, objectConverter, objectConverter3);
    }

    private ObjectConverter<S, ? extends T> merge(ObjectConverter<S, ? extends T> objectConverter, Class<? super T> clazz) {
        ObjectConverter<S, ? extends T> objectConverter2;
        FallbackConverter fallbackConverter;
        ObjectConverter<S, ? extends T> objectConverter3 = FallbackConverter.mergeIfSubtype(this.fallback, objectConverter, this.targetClass);
        if (objectConverter3 != null) {
            fallbackConverter = this.primary;
            objectConverter2 = objectConverter3;
        } else {
            objectConverter3 = FallbackConverter.mergeIfSubtype(this.primary, objectConverter, this.targetClass);
            if (objectConverter3 != null) {
                fallbackConverter = objectConverter3;
                objectConverter2 = this.fallback;
            } else if (this.targetClass != clazz) {
                fallbackConverter = this;
                objectConverter2 = objectConverter;
            } else {
                return null;
            }
        }
        return new FallbackConverter<S, T>(this.sourceClass, this.targetClass, fallbackConverter, objectConverter2);
    }

    @Override
    public final Set<FunctionProperty> properties() {
        Set<FunctionProperty> set = this.primary.properties();
        if (!(this.primary instanceof FallbackConverter)) {
            set = EnumSet.copyOf(set);
            set.remove((Object)FunctionProperty.INVERTIBLE);
        }
        set.retainAll(this.fallback.properties());
        return set;
    }

    @Override
    public T apply(S s2) throws UnconvertibleObjectException {
        try {
            return this.primary.apply(s2);
        }
        catch (UnconvertibleObjectException unconvertibleObjectException) {
            try {
                return this.fallback.apply(s2);
            }
            catch (UnconvertibleObjectException unconvertibleObjectException2) {
                unconvertibleObjectException.addSuppressed(unconvertibleObjectException2);
                throw unconvertibleObjectException;
            }
        }
    }

    private void toTree(ObjectConverter<?, ?> objectConverter, TreeTable.Node node) {
        if (objectConverter instanceof FallbackConverter) {
            boolean bl;
            boolean bl2 = bl = objectConverter.getTargetClass() != this.targetClass;
            if (bl) {
                node = node.newChild();
            }
            ((FallbackConverter)objectConverter).toTree(node, bl);
        } else {
            Column.toTree(objectConverter, node);
        }
    }

    final void toTree(TreeTable.Node node, boolean bl) {
        if (bl) {
            node.setValue(Column.SOURCE, this.sourceClass);
            node.setValue(Column.TARGET, this.targetClass);
        }
        this.toTree(this.primary, node);
        this.toTree(this.fallback, node);
    }

    @Override
    public String toString() {
        TreeTable treeTable = Column.createTable();
        this.toTree(treeTable.getRoot(), true);
        return Column.format(treeTable);
    }
}

