/*
 * Decompiled with CFR 0.152.
 */
package jj2000.disp;

import java.awt.Adjustable;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class ImgScrollPane
extends Container {
    public static final int SCROLLBARS_ALWAYS = 1;
    public static final int SCROLLBARS_AS_NEEDED = 0;
    public static final int SCROLLBARS_NEVER = 2;
    public static final float MAX_ZOOM = 32.0f;
    static final int SCROLLBAR_THICKNESS = 16;
    static final int INTERNAL_GAP = 0;
    static final float BLOCK_INCREMENT_PROPORTION = 0.8f;
    ISPScrollbar hsbar;
    ISPScrollbar vsbar;
    private ImageScrollDisplay imgDisplay;
    private int sbType;
    private float zoom = 1.0f;
    private float lastZoom;
    private Dimension lastSize;
    private boolean copyScroll = true;

    public ImgScrollPane() {
        this(0);
    }

    public ImgScrollPane(int svt) {
        super.setLayout(new BorderLayout(0, 0));
        this.sbType = svt;
        this.hsbar = new ISPScrollbar(0, 0, 1, 0, 1);
        this.vsbar = new ISPScrollbar(1, 0, 1, 0, 1);
        this.imgDisplay = new ImageScrollDisplay();
        super.add((Component)this.hsbar, "South");
        super.add((Component)this.vsbar, "East");
        super.add((Component)this.imgDisplay, "Center");
        switch (svt) {
            case 0: 
            case 2: {
                this.hsbar.setVisible(false);
                this.vsbar.setVisible(false);
                break;
            }
            case 1: {
                this.hsbar.setVisible(true);
                this.vsbar.setVisible(true);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void setImage(Image img) {
        this.imgDisplay.setImage(img);
    }

    public synchronized Image getImage() {
        return this.imgDisplay.img;
    }

    public synchronized void setZoom(float zf) {
        if (zf == this.zoom || zf > 32.0f && this.zoom == 32.0f) {
            return;
        }
        this.zoom = zf;
        if (this.zoom > 32.0f) {
            this.zoom = 32.0f;
        }
        this.setScrollbars();
        if (this.sbType == 0) {
            this.doLayout();
        }
        this.imgDisplay.erase = true;
        this.imgDisplay.repaint();
    }

    public synchronized void zoom(float zm) {
        this.setZoom(this.zoom * zm);
    }

    public synchronized float getZoom() {
        return this.zoom;
    }

    public Adjustable getHAdjustable() {
        return this.hsbar;
    }

    public Adjustable getVAdjustable() {
        return this.vsbar;
    }

    public int getScrollbarDisplayPolicy() {
        return this.sbType;
    }

    public void setScrollbarDisplayPolicy(int v) {
        if (v == this.sbType) {
            return;
        }
        switch (this.sbType) {
            case 0: 
            case 2: {
                this.hsbar.setVisible(false);
                this.vsbar.setVisible(false);
                break;
            }
            case 1: {
                this.hsbar.setVisible(true);
                this.vsbar.setVisible(true);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.doLayout();
    }

    public synchronized void setScrollPosition(int x, int y) {
        this.hsbar.setValueI(x);
        this.vsbar.setValueI(y);
        x = this.hsbar.getValue();
        y = this.vsbar.getValue();
        if (this.imgDisplay.lastUpdateOffset != null && this.imgDisplay.lastUpdateOffset.x == x && this.imgDisplay.lastUpdateOffset.y == y) {
            return;
        }
        this.imgDisplay.repaint();
    }

    public synchronized void setScrollPosition(Point p) {
        this.setScrollPosition(p.x, p.y);
    }

    public Point getScrollPosition() {
        return new Point(this.hsbar.getValue(), this.vsbar.getValue());
    }

    public Dimension getViewportSize() {
        return this.imgDisplay.getSize();
    }

    public synchronized void setCopyScroll(boolean v) {
        this.copyScroll = v;
    }

    public synchronized boolean getCopyScroll() {
        return this.copyScroll;
    }

    @Override
    public synchronized void doLayout() {
        if (this.sbType == 0 && this.imgDisplay.calcDim()) {
            Dimension sz = this.getSize();
            Dimension imsz = this.imgDisplay.getPreferredSize();
            if (sz.width >= imsz.width + 0) {
                if (sz.height >= imsz.height + 0) {
                    this.hsbar.setVisible(false);
                    this.vsbar.setVisible(false);
                } else {
                    this.vsbar.setVisible(true);
                    if (sz.width >= imsz.width + 0 + 16) {
                        this.hsbar.setVisible(false);
                    } else {
                        this.hsbar.setVisible(true);
                    }
                }
            } else {
                this.hsbar.setVisible(true);
                if (sz.height >= imsz.height + 0 + 16) {
                    this.vsbar.setVisible(false);
                } else {
                    this.vsbar.setVisible(true);
                }
            }
        }
        this.imgDisplay.erase = true;
        super.doLayout();
        if (this.hsbar.isVisible() && this.vsbar.isVisible()) {
            Rectangle b = this.hsbar.getBounds();
            if (b.width > 16) {
                b.width -= 16;
            }
            this.hsbar.setBounds(b);
        }
        this.setScrollbars();
    }

    @Override
    public synchronized void addFocusListener(FocusListener l) {
        super.addFocusListener(l);
        this.imgDisplay.addFocusListener(l);
        this.hsbar.addFocusListener(l);
        this.vsbar.addFocusListener(l);
    }

    @Override
    public synchronized void removeFocusListener(FocusListener l) {
        super.removeFocusListener(l);
        this.imgDisplay.removeFocusListener(l);
        this.hsbar.removeFocusListener(l);
        this.vsbar.removeFocusListener(l);
    }

    @Override
    public synchronized void addKeyListener(KeyListener l) {
        super.addKeyListener(l);
        this.imgDisplay.addKeyListener(l);
        this.hsbar.addKeyListener(l);
        this.vsbar.addKeyListener(l);
    }

    @Override
    public synchronized void removeKeyListener(KeyListener l) {
        super.removeKeyListener(l);
        this.imgDisplay.removeKeyListener(l);
        this.hsbar.removeKeyListener(l);
        this.vsbar.removeKeyListener(l);
    }

    @Override
    public synchronized void addMouseListener(MouseListener l) {
        super.addMouseListener(l);
        this.imgDisplay.addMouseListener(l);
    }

    @Override
    public synchronized void removeMouseListener(MouseListener l) {
        super.removeMouseListener(l);
        this.imgDisplay.removeMouseListener(l);
    }

    @Override
    public synchronized void addMouseMotionListener(MouseMotionListener l) {
        super.addMouseMotionListener(l);
        this.imgDisplay.addMouseMotionListener(l);
    }

    @Override
    public synchronized void removeMouseMotionListener(MouseMotionListener l) {
        super.removeMouseMotionListener(l);
        this.imgDisplay.removeMouseMotionListener(l);
    }

    @Override
    public synchronized void setBackground(Color c) {
        super.setBackground(c);
        this.imgDisplay.setBackground(c);
        this.hsbar.setBackground(c);
        this.vsbar.setBackground(c);
    }

    @Override
    public synchronized void setCursor(Cursor cursor) {
        super.setCursor(cursor);
        this.imgDisplay.setCursor(cursor);
    }

    @Override
    public synchronized void setEnabled(boolean b) {
        super.setEnabled(b);
        this.imgDisplay.setEnabled(b);
        this.hsbar.setEnabled(b);
        this.vsbar.setEnabled(b);
    }

    @Override
    public synchronized void setForeground(Color c) {
        super.setForeground(c);
        this.imgDisplay.setForeground(c);
        this.hsbar.setForeground(c);
        this.vsbar.setForeground(c);
    }

    @Override
    public Component add(Component comp) {
        throw new IllegalArgumentException();
    }

    @Override
    public Component add(String name, Component comp) {
        throw new IllegalArgumentException();
    }

    @Override
    public Component add(Component comp, int index) {
        throw new IllegalArgumentException();
    }

    @Override
    public void add(Component comp, Object constraints) {
        throw new IllegalArgumentException();
    }

    @Override
    public void add(Component comp, Object constraints, int index) {
        throw new IllegalArgumentException();
    }

    @Override
    public void remove(int index) {
        throw new IllegalArgumentException();
    }

    @Override
    public void remove(Component comp) {
        throw new IllegalArgumentException();
    }

    @Override
    public void removeAll() {
        throw new IllegalArgumentException();
    }

    @Override
    public void setLayout(LayoutManager mgr) {
        throw new IllegalArgumentException();
    }

    private void setScrollbars() {
        if (!this.imgDisplay.calcDim()) {
            return;
        }
        Dimension asz = this.imgDisplay.getSize();
        Dimension psz = this.imgDisplay.getPreferredSize();
        if (this.lastZoom == 0.0f) {
            this.lastZoom = this.zoom;
        }
        if (this.lastSize == null) {
            this.lastSize = new Dimension(asz.width, asz.height);
        }
        int szx = asz.width < psz.width ? asz.width : psz.width;
        int szy = asz.height < psz.height ? asz.height : psz.height;
        int pos = (int)(((float)this.hsbar.getValue() + (float)this.lastSize.width / 2.0f) / this.lastZoom * this.zoom - (float)szx / 2.0f);
        if (pos > psz.width - asz.width) {
            pos = psz.width - asz.width;
        }
        if (pos < 0) {
            pos = 0;
        }
        if (asz.width <= 0) {
            asz.width = 1;
        }
        if (psz.width <= 0) {
            psz.width = 1;
        }
        this.hsbar.setValues(pos, asz.width, 0, psz.width);
        asz.width = (int)((float)asz.width * 0.8f);
        if (asz.width <= 0) {
            asz.width = 1;
        }
        this.hsbar.setBlockIncrementI(asz.width);
        pos = (int)(((float)this.vsbar.getValue() + (float)this.lastSize.height / 2.0f) / this.lastZoom * this.zoom - (float)szy / 2.0f);
        if (pos > psz.height - asz.height) {
            pos = psz.height - asz.height;
        }
        if (pos < 0) {
            pos = 0;
        }
        if (asz.height <= 0) {
            asz.height = 1;
        }
        if (psz.height <= 0) {
            psz.height = 1;
        }
        this.vsbar.setValues(pos, asz.height, 0, psz.height);
        asz.height = (int)((float)asz.height * 0.8f);
        if (asz.height <= 0) {
            asz.height = 1;
        }
        this.vsbar.setBlockIncrementI(asz.height);
        this.lastZoom = this.zoom;
        this.lastSize.width = szx;
        this.lastSize.height = szy;
    }

    class ISPScrollbar
    extends Scrollbar {
        ISPScrollbar(int orientation, int value, int visible, int min2, int max) {
            super(orientation, value, visible, min2, max);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension psz = super.getPreferredSize();
            if (this.getOrientation() == 0) {
                psz.height = 16;
            } else {
                psz.width = 16;
            }
            return psz;
        }

        @Override
        public void setMinimum(int min2) {
            throw new IllegalArgumentException();
        }

        @Override
        public void setMaximum(int max) {
            throw new IllegalArgumentException();
        }

        @Override
        public void setVisibleAmount(int v) {
            throw new IllegalArgumentException();
        }

        @Override
        public void setBlockIncrement(int b) {
            throw new IllegalArgumentException();
        }

        void setBlockIncrementI(int v) {
            super.setBlockIncrement(v);
        }

        void setValueI(int newValue) {
            super.setValue(newValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setValue(int newValue) {
            ImgScrollPane imgScrollPane = ImgScrollPane.this;
            synchronized (imgScrollPane) {
                super.setValue(newValue);
                newValue = this.getValue();
                if (((ImgScrollPane)ImgScrollPane.this).imgDisplay.lastUpdateOffset != null) {
                    if (this.getOrientation() == 0) {
                        if (((ImgScrollPane)ImgScrollPane.this).imgDisplay.lastUpdateOffset.x == newValue) {
                            return;
                        }
                    } else if (((ImgScrollPane)ImgScrollPane.this).imgDisplay.lastUpdateOffset.y == newValue) {
                        return;
                    }
                }
            }
            ImgScrollPane.this.imgDisplay.repaint();
        }
    }

    private class ImageScrollDisplay
    extends Canvas {
        Image img;
        Dimension dim = new Dimension();
        boolean erase;
        Dimension imgDim = new Dimension();
        int dimFlags;
        Point lastUpdateOffset;

        private ImageScrollDisplay() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setImage(Image img) {
            ImgScrollPane imgScrollPane = ImgScrollPane.this;
            synchronized (imgScrollPane) {
                if (img == null) {
                    throw new IllegalArgumentException();
                }
                if (this.img == img) {
                    return;
                }
                this.dimFlags = 0;
                this.img = img;
                ImgScrollPane.this.lastSize = null;
                ImgScrollPane.this.lastZoom = 0.0f;
                ImgScrollPane.this.setScrollbars();
                this.erase = true;
            }
            ImgScrollPane.this.prepareImage(img, this);
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(0, 0);
        }

        @Override
        public Dimension getMaximumSize() {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.dim;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean imageUpdate(Image img, int infoflags, int x, int y, int w, int h2) {
            if (this.img != img) {
                return false;
            }
            if ((infoflags & 3) != 0) {
                ImgScrollPane imgScrollPane = ImgScrollPane.this;
                synchronized (imgScrollPane) {
                    if ((infoflags & 1) != 0) {
                        this.imgDim.width = w;
                        this.dimFlags |= 1;
                    }
                    if ((infoflags & 2) != 0) {
                        this.imgDim.height = h2;
                        this.dimFlags |= 2;
                    }
                    if (this.dimFlags == 3) {
                        ImgScrollPane.this.doLayout();
                    }
                }
            }
            return super.imageUpdate(img, infoflags, x, y, w, h2);
        }

        @Override
        public void paint(Graphics g2) {
            this.update(g2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void update(Graphics g2) {
            int dx2;
            int dy2;
            int dx1;
            int dy1;
            int sx2;
            int sy2;
            int sx1;
            int sy1;
            int loffy;
            int loffx;
            int offy;
            int offx;
            Rectangle clip;
            int oy;
            int ox;
            Rectangle b;
            int status;
            boolean copyScroll;
            boolean erase;
            float zoom;
            Image img;
            ImgScrollPane imgScrollPane = ImgScrollPane.this;
            synchronized (imgScrollPane) {
                img = this.img;
                zoom = ImgScrollPane.this.zoom;
                erase = this.erase;
                copyScroll = ImgScrollPane.this.copyScroll;
                this.erase = false;
                if (img == null || (status = this.checkImage(img, null)) == 0) {
                    return;
                }
                b = this.getBounds();
                ox = b.width > this.dim.width ? (b.width - this.dim.width) / 2 : 0;
                oy = b.height > this.dim.height ? (b.height - this.dim.height) / 2 : 0;
                clip = g2.getClipBounds();
                if (this.lastUpdateOffset != null && (clip.width < b.width || clip.height < b.height)) {
                    offx = this.lastUpdateOffset.x;
                    offy = this.lastUpdateOffset.y;
                } else {
                    offx = ImgScrollPane.this.hsbar.getValue();
                    offy = ImgScrollPane.this.vsbar.getValue();
                }
                if (this.lastUpdateOffset == null) {
                    this.lastUpdateOffset = new Point();
                }
                loffx = this.lastUpdateOffset.x;
                loffy = this.lastUpdateOffset.y;
                this.lastUpdateOffset.x = offx;
                this.lastUpdateOffset.y = offy;
                if (zoom == 1.0f) {
                    ox -= offx;
                    oy -= offy;
                    sy1 = 0;
                    sx1 = 0;
                    sy2 = 0;
                    sx2 = 0;
                    dy1 = 0;
                    dx1 = 0;
                    dy2 = 0;
                    dx2 = 0;
                } else {
                    if (this.dimFlags != 3) {
                        return;
                    }
                    sy1 = 0;
                    sx1 = 0;
                    sx2 = this.imgDim.width;
                    sy2 = this.imgDim.height;
                    dy1 = 0;
                    dx1 = 0;
                    dx2 = this.dim.width;
                    dy2 = this.dim.height;
                    int soy = 0;
                    int sox = 0;
                    if (dx2 > b.width) {
                        dx2 = b.width + (zoom > 1.0f ? (int)Math.ceil(zoom) : 0);
                        if ((float)((int)zoom) == zoom) {
                            dx2 = (int)(Math.ceil((float)dx2 / zoom) * (double)zoom);
                        }
                        sx1 = (int)((float)offx / zoom);
                        sx2 = sx1 + (int)((float)dx2 / zoom);
                        sox = (int)((float)sx1 * zoom - (float)offx);
                    }
                    if (dy2 > b.height) {
                        dy2 = b.height + (zoom > 1.0f ? (int)Math.ceil(zoom) : 0);
                        if ((float)((int)zoom) == zoom) {
                            dy2 = (int)(Math.ceil((float)dy2 / zoom) * (double)zoom);
                        }
                        sy1 = (int)((float)offy / zoom);
                        sy2 = sy1 + (int)((float)dy2 / zoom);
                        soy = (int)((float)sy1 * zoom - (float)offy);
                    }
                    dx1 += ox + sox;
                    dy1 += oy + soy;
                    dx2 += ox + sox;
                    dy2 += oy + soy;
                }
            }
            if ((status & 0x20) == 0 && (loffx != offx || loffy != offy)) {
                erase = true;
            }
            if (erase) {
                g2.setClip(0, 0, b.width, b.height);
                g2.setColor(this.getBackground());
                g2.fillRect(0, 0, b.width, b.height);
            }
            if (copyScroll && !erase && (loffx != offx || loffy != offy) && (status & 0x20) != 0) {
                int culx = clip.x;
                int culy = clip.y;
                int cdrx = clip.x + clip.width;
                int cdry = clip.y + clip.height;
                int vulx = loffx - offx;
                int vuly = loffy - offy;
                int vdrx = vulx + b.width;
                int vdry = vuly + b.height;
                if (culx > vulx) {
                    vulx = culx;
                }
                if (culy > vuly) {
                    vuly = culy;
                }
                if (cdrx < vdrx) {
                    vdrx = cdrx;
                }
                if (cdry < vdry) {
                    vdry = cdry;
                }
                if (vulx < vdrx && vuly < vdry) {
                    g2.copyArea(vulx + offx - loffx, vuly + offy - loffy, vdrx - vulx, vdry - vuly, loffx - offx, loffy - offy);
                    if (culx < vulx) {
                        g2.setClip(culx, culy, vulx - culx, cdry - culy);
                        if (zoom == 1.0f) {
                            g2.drawImage(img, ox, oy, this);
                        } else {
                            g2.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, this);
                        }
                    }
                    if (vdrx < cdrx) {
                        g2.setClip(vdrx, culy, cdrx - vdrx, cdry - culy);
                        if (zoom == 1.0f) {
                            g2.drawImage(img, ox, oy, this);
                        } else {
                            g2.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, this);
                        }
                    }
                    if (culy < vuly) {
                        g2.setClip(vulx, culy, vdrx - vulx, vuly - culy);
                        if (zoom == 1.0f) {
                            g2.drawImage(img, ox, oy, this);
                        } else {
                            g2.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, this);
                        }
                    }
                    if (vdry < cdry) {
                        g2.setClip(vulx, vdry, vdrx - vulx, cdry - vdry);
                        if (zoom == 1.0f) {
                            g2.drawImage(img, ox, oy, this);
                        } else {
                            g2.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, this);
                        }
                    }
                } else if (zoom == 1.0f) {
                    g2.drawImage(img, ox, oy, this);
                } else {
                    g2.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, this);
                }
            } else if (zoom == 1.0f) {
                g2.drawImage(img, ox, oy, this);
            } else {
                g2.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, this);
            }
        }

        boolean calcDim() {
            if (this.dimFlags != 3) {
                return false;
            }
            if (ImgScrollPane.this.zoom == 1.0f) {
                this.dim.width = this.imgDim.width;
                this.dim.height = this.imgDim.height;
            } else {
                this.dim.width = (int)(ImgScrollPane.this.zoom * (float)this.imgDim.width);
                this.dim.height = (int)(ImgScrollPane.this.zoom * (float)this.imgDim.height);
            }
            return true;
        }
    }
}

