/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pdf;

import org.apache.tika.exception.AccessPermissionException;
import org.apache.tika.metadata.AccessPermissions;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.PropertyTypeException;
import org.apache.tika.parser.pdf.AccessChecker;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AccessCheckerTest {
    @Test
    public void testLegacy() throws AccessPermissionException {
        Metadata m = this.getMetadata(false, false);
        AccessChecker checker = new AccessChecker();
        checker.check(m);
        m = this.getMetadata(false, true);
        checker.check(m);
        m = this.getMetadata(true, true);
        checker.check(m);
    }

    @Test
    public void testNoExtraction() {
        Metadata m = null;
        AccessChecker checker = new AccessChecker(false);
        boolean ex = false;
        try {
            m = this.getMetadata(false, false);
            checker.check(m);
        }
        catch (AccessPermissionException e) {
            ex = true;
        }
        Assertions.assertTrue((boolean)ex, (String)"correct exception with no extraction, no extract for accessibility");
        ex = false;
        try {
            m = this.getMetadata(false, true);
            checker.check(m);
        }
        catch (AccessPermissionException e) {
            ex = true;
        }
        Assertions.assertTrue((boolean)ex, (String)"correct exception with no extraction, no extract for accessibility");
    }

    @Test
    public void testExtractOnlyForAccessibility() throws AccessPermissionException {
        Metadata m = this.getMetadata(false, true);
        AccessChecker checker = new AccessChecker(true);
        checker.check(m);
        Assertions.assertTrue((boolean)true, (String)"no exception");
        boolean ex = false;
        try {
            m = this.getMetadata(false, false);
            checker.check(m);
        }
        catch (AccessPermissionException e) {
            ex = true;
        }
        Assertions.assertTrue((boolean)ex, (String)"correct exception");
    }

    @Test
    public void testIllogicalExtractNotForAccessibility() throws AccessPermissionException {
        Metadata m = this.getMetadata(true, false);
        AccessChecker checker = new AccessChecker(true);
        checker.check(m);
        Assertions.assertTrue((boolean)true, (String)"no exception");
        checker = new AccessChecker(false);
        checker.check(m);
        Assertions.assertTrue((boolean)true, (String)"no exception");
    }

    @Test
    public void testCantAddMultiplesToMetadata() {
        Metadata m = new Metadata();
        boolean ex = false;
        m.add(AccessPermissions.EXTRACT_CONTENT, "true");
        try {
            m.add(AccessPermissions.EXTRACT_CONTENT, "false");
        }
        catch (PropertyTypeException e) {
            ex = true;
        }
        Assertions.assertTrue((boolean)ex, (String)"can't add multiple values");
        m = new Metadata();
        ex = false;
        m.add(AccessPermissions.EXTRACT_FOR_ACCESSIBILITY, "true");
        try {
            m.add(AccessPermissions.EXTRACT_FOR_ACCESSIBILITY, "false");
        }
        catch (PropertyTypeException e) {
            ex = true;
        }
        Assertions.assertTrue((boolean)ex, (String)"can't add multiple values");
    }

    private Metadata getMetadata(boolean allowExtraction, boolean allowExtractionForAccessibility) {
        Metadata m = new Metadata();
        m.set(AccessPermissions.EXTRACT_CONTENT, Boolean.toString(allowExtraction));
        m.set(AccessPermissions.EXTRACT_FOR_ACCESSIBILITY, Boolean.toString(allowExtractionForAccessibility));
        return m;
    }
}

