/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.recognition.tf;

import com.github.openjson.JSONArray;
import com.github.openjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.tika.config.Field;
import org.apache.tika.config.InitializableProblemHandler;
import org.apache.tika.config.Param;
import org.apache.tika.exception.TikaConfigException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.recognition.ObjectRecogniser;
import org.apache.tika.parser.recognition.RecognisedObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class TensorflowRESTRecogniser
implements ObjectRecogniser {
    protected static final String LABEL_LANG = "eng";
    private static final Logger LOG = LoggerFactory.getLogger(TensorflowRESTRecogniser.class);
    private static final Set<MediaType> SUPPORTED_MIMES = Collections.unmodifiableSet(new HashSet<MediaType>(Arrays.asList(MediaType.image((String)"jpeg"), MediaType.image((String)"png"), MediaType.image((String)"gif"))));
    @Field
    protected URI apiBaseUri = URI.create("http://localhost:8764/inception/v4");
    @Field
    protected int topN = 2;
    @Field
    protected double minConfidence = 0.015;
    protected URI apiUri;
    protected URI healthUri;
    protected boolean available;

    protected URI getApiUri(Metadata metadata) {
        return this.apiUri;
    }

    @Override
    public Set<MediaType> getSupportedMimes() {
        return SUPPORTED_MIMES;
    }

    @Override
    public boolean isAvailable() {
        return this.available;
    }

    @Override
    public void initialize(Map<String, Param> params) throws TikaConfigException {
        this.healthUri = URI.create(String.valueOf(this.apiBaseUri) + "/ping");
        this.apiUri = URI.create(String.valueOf(this.apiBaseUri) + String.format(Locale.getDefault(), "/classify/image?topn=%1$d&min_confidence=%2$f", this.topN, this.minConfidence));
        try (CloseableHttpClient client = HttpClientBuilder.create().build();){
            CloseableHttpResponse response = client.execute(new HttpGet(this.healthUri));
            this.available = response.getStatusLine().getStatusCode() == 200;
            LOG.info("Available = {}, API Status = {}", (Object)this.available, (Object)response.getStatusLine());
            LOG.info("topN = {}, minConfidence = {}", (Object)this.topN, (Object)this.minConfidence);
        }
        catch (Exception e) {
            this.available = false;
            throw new TikaConfigException(e.getMessage(), (Throwable)e);
        }
    }

    public void checkInitialization(InitializableProblemHandler handler) throws TikaConfigException {
    }

    public List<RecognisedObject> recognise(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        ArrayList<RecognisedObject> recObjs = new ArrayList<RecognisedObject>();
        try (CloseableHttpClient client = HttpClientBuilder.create().build();){
            HttpPost request = new HttpPost(this.getApiUri(metadata));
            try (UnsynchronizedByteArrayOutputStream byteStream = UnsynchronizedByteArrayOutputStream.builder().get();){
                IOUtils.copy((InputStream)stream, (OutputStream)byteStream);
                request.setEntity(new ByteArrayEntity(byteStream.toByteArray()));
            }
            CloseableHttpResponse response = client.execute(request);
            try (InputStream reply = response.getEntity().getContent();){
                String replyMessage = IOUtils.toString((InputStream)reply, (Charset)StandardCharsets.UTF_8);
                if (response.getStatusLine().getStatusCode() == 200) {
                    JSONObject jReply = new JSONObject(replyMessage);
                    JSONArray jClasses = jReply.getJSONArray("classnames");
                    JSONArray jConfidence = jReply.getJSONArray("confidence");
                    if (jClasses.length() != jConfidence.length()) {
                        LOG.warn("Classes of size {} is not equal to confidence of size {}", (Object)jClasses.length(), (Object)jConfidence.length());
                    }
                    assert (jClasses.length() == jConfidence.length());
                    for (int i = 0; i < jClasses.length(); ++i) {
                        RecognisedObject recObj = new RecognisedObject(jClasses.getString(i), LABEL_LANG, jClasses.getString(i), jConfidence.getDouble(i));
                        recObjs.add(recObj);
                    }
                } else {
                    LOG.warn("Status = {}", (Object)response.getStatusLine());
                    LOG.warn("Response = {}", (Object)replyMessage);
                }
            }
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), (Throwable)e);
        }
        LOG.debug("Num Objects found {}", (Object)recObjs.size());
        return recObjs;
    }
}

