/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.fuzzing.pdf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Set;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.RandomAccessReadBuffer;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.encryption.InvalidPasswordException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.fuzzing.Transformer;
import org.apache.tika.fuzzing.exceptions.CantFuzzException;
import org.apache.tika.fuzzing.pdf.EvilCOSWriter;
import org.apache.tika.fuzzing.pdf.PDFTransformerConfig;
import org.apache.tika.mime.MediaType;

public class PDFTransformer
implements Transformer {
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MediaType.application((String)"pdf"));
    private PDFTransformerConfig config = new PDFTransformerConfig();

    @Override
    public Set<MediaType> getSupportedTypes() {
        return SUPPORTED_TYPES;
    }

    @Override
    public void transform(InputStream is, OutputStream os) throws IOException, TikaException {
        try (PDDocument pdDocument = Loader.loadPDF((RandomAccessRead)new RandomAccessReadBuffer(is));){
            pdDocument.setAllSecurityToBeRemoved(true);
            try (EvilCOSWriter cosWriter = new EvilCOSWriter(os, this.config);){
                cosWriter.write(pdDocument);
            }
        }
        catch (InvalidPasswordException e) {
            throw new CantFuzzException("encrypted doc");
        }
    }

    public void setConfig(PDFTransformerConfig pdfTransformerConfig) {
        this.config = pdfTransformerConfig;
    }
}

