/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.pipes.fetcher.http.jwt;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.crypto.MACSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import org.apache.tika.pipes.fetcher.http.jwt.JwtCreds;
import org.apache.tika.pipes.fetcher.http.jwt.JwtPrivateKeyCreds;
import org.apache.tika.pipes.fetcher.http.jwt.JwtSecretCreds;

public class JwtGenerator {
    JwtCreds jwtCreds;

    public JwtGenerator(JwtCreds jwtCreds) {
        this.jwtCreds = jwtCreds;
    }

    public String jwt() throws JOSEException {
        if (this.jwtCreds instanceof JwtSecretCreds) {
            return this.jwtHS256((JwtSecretCreds)this.jwtCreds);
        }
        return this.jwtRS256((JwtPrivateKeyCreds)this.jwtCreds);
    }

    String jwtHS256(JwtSecretCreds jwtSecretCreds) throws JOSEException {
        MACSigner signer = new MACSigner(jwtSecretCreds.getSecret());
        JWTClaimsSet claimsSet = this.getJwtClaimsSet(jwtSecretCreds.getIssuer(), jwtSecretCreds.getSubject(), jwtSecretCreds.getExpiresInSeconds());
        SignedJWT signedJWT = new SignedJWT(new JWSHeader(JWSAlgorithm.HS256), claimsSet);
        signedJWT.sign(signer);
        return signedJWT.serialize();
    }

    String jwtRS256(JwtPrivateKeyCreds jwtPrivateKeyCreds) throws JOSEException {
        RSASSASigner signer = new RSASSASigner(jwtPrivateKeyCreds.getPrivateKey());
        JWTClaimsSet claimsSet = this.getJwtClaimsSet(jwtPrivateKeyCreds.getIssuer(), jwtPrivateKeyCreds.getSubject(), jwtPrivateKeyCreds.getExpiresInSeconds());
        SignedJWT signedJWT = new SignedJWT(new JWSHeader(JWSAlgorithm.RS256), claimsSet);
        signedJWT.sign(signer);
        return signedJWT.serialize();
    }

    private JWTClaimsSet getJwtClaimsSet(String issuer, String subject, int expiresInSeconds) {
        return new JWTClaimsSet.Builder().subject(subject).issuer(issuer).expirationTime(Date.from(Instant.now().plus((long)expiresInSeconds, ChronoUnit.SECONDS))).build();
    }
}

