/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.pipes.fetcher.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jose.JOSEException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream;
import org.apache.http.ConnectionClosedException;
import org.apache.http.Header;
import org.apache.http.HttpConnection;
import org.apache.http.HttpEntity;
import org.apache.http.HttpInetConnection;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.conn.ConnectionShutdownException;
import org.apache.http.util.EntityUtils;
import org.apache.tika.client.HttpClientFactory;
import org.apache.tika.config.Field;
import org.apache.tika.config.Initializable;
import org.apache.tika.config.InitializableProblemHandler;
import org.apache.tika.config.Param;
import org.apache.tika.exception.TikaConfigException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.exception.TikaTimeoutException;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Property;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.pipes.fetcher.AbstractFetcher;
import org.apache.tika.pipes.fetcher.RangeFetcher;
import org.apache.tika.pipes.fetcher.config.FetcherConfigContainer;
import org.apache.tika.pipes.fetcher.http.config.HttpFetcherConfig;
import org.apache.tika.pipes.fetcher.http.config.HttpHeaders;
import org.apache.tika.pipes.fetcher.http.jwt.JwtGenerator;
import org.apache.tika.pipes.fetcher.http.jwt.JwtPrivateKeyCreds;
import org.apache.tika.pipes.fetcher.http.jwt.JwtSecretCreds;
import org.apache.tika.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpFetcher
extends AbstractFetcher
implements Initializable,
RangeFetcher {
    private static final ObjectMapper OM = new ObjectMapper();
    private HttpFetcherConfig httpFetcherConfig = new HttpFetcherConfig();
    private HttpClientFactory httpClientFactory = new HttpClientFactory();
    public static String HTTP_HEADER_PREFIX = "http-header:";
    public static String HTTP_FETCH_PREFIX = "http-connection:";
    public static Property HTTP_STATUS_CODE = Property.externalInteger((String)(HTTP_HEADER_PREFIX + "status-code"));
    public static Property HTTP_NUM_REDIRECTS = Property.externalInteger((String)(HTTP_FETCH_PREFIX + "num-redirects"));
    public static Property HTTP_TARGET_URL = Property.externalText((String)(HTTP_FETCH_PREFIX + "target-url"));
    public static Property HTTP_TARGET_IP_ADDRESS = Property.externalText((String)(HTTP_FETCH_PREFIX + "target-ip-address"));
    public static Property HTTP_FETCH_TRUNCATED = Property.externalBoolean((String)(HTTP_FETCH_PREFIX + "fetch-truncated"));
    public static Property HTTP_CONTENT_ENCODING = Property.externalText((String)(HTTP_HEADER_PREFIX + "content-encoding"));
    public static Property HTTP_CONTENT_TYPE = Property.externalText((String)(HTTP_HEADER_PREFIX + "content-type"));
    private static String USER_AGENT = "User-Agent";
    Logger LOG = LoggerFactory.getLogger(HttpFetcher.class);
    private HttpClient httpClient;
    private HttpClient noCompressHttpClient;
    private int maxRedirects = 10;
    private long overallTimeout = -1L;
    private long maxSpoolSize = -1L;
    private int maxErrMsgSize = 10000;
    private Set<String> httpHeaders = new HashSet<String>();
    private Set<String> httpRequestHeaders = new HashSet<String>();
    private String userAgent = null;
    JwtGenerator jwtGenerator;

    public HttpFetcher() {
    }

    public HttpFetcher(HttpFetcherConfig httpFetcherConfig) {
        this.httpFetcherConfig = httpFetcherConfig;
    }

    public InputStream fetch(String fetchKey, Metadata metadata, ParseContext parseContext) throws IOException, TikaException {
        HttpFetcherConfig additionalHttpFetcherConfig = this.getAdditionalHttpFetcherConfig(parseContext);
        HttpGet get = new HttpGet(fetchKey);
        RequestConfig requestConfig = RequestConfig.custom().setMaxRedirects(this.httpFetcherConfig.getMaxRedirects()).setRedirectsEnabled(this.httpFetcherConfig.getMaxRedirects() > 0).build();
        get.setConfig(requestConfig);
        this.setHttpRequestHeaders(metadata, get);
        this.putAdditionalHeadersOnRequest(additionalHttpFetcherConfig, get);
        return this.execute(get, metadata, this.httpClient, true);
    }

    private void setHttpRequestHeaders(Metadata metadata, HttpGet get) {
        String[] httpRequestHeaders;
        if (!StringUtils.isBlank((String)this.userAgent)) {
            get.setHeader(USER_AGENT, this.userAgent);
        }
        if (this.httpRequestHeaders != null) {
            for (String httpRequestHeader : this.httpRequestHeaders) {
                HttpFetcher.parseHeaderAndPutOnRequest(get, httpRequestHeader);
            }
        }
        if ((httpRequestHeaders = metadata.getValues("httpRequestHeaders")) != null) {
            for (String httpRequestHeader : httpRequestHeaders) {
                HttpFetcher.parseHeaderAndPutOnRequest(get, httpRequestHeader);
            }
        }
    }

    private static void parseHeaderAndPutOnRequest(HttpGet get, String httpRequestHeader) {
        String[] parts = httpRequestHeader.trim().split(":", 2);
        if (parts.length >= 2) {
            String key = parts[0].trim();
            String value = parts[1].trim();
            get.setHeader(key, value);
        }
    }

    private HttpFetcherConfig getAdditionalHttpFetcherConfig(ParseContext parseContext) throws JsonProcessingException {
        HttpFetcherConfig additionalHttpFetcherConfig = null;
        FetcherConfigContainer fetcherConfigContainer = (FetcherConfigContainer)parseContext.get(FetcherConfigContainer.class);
        if (fetcherConfigContainer != null) {
            additionalHttpFetcherConfig = OM.readValue(fetcherConfigContainer.getJson(), HttpFetcherConfig.class);
        }
        return additionalHttpFetcherConfig;
    }

    public InputStream fetch(String fetchKey, long startRange, long endRange, Metadata metadata, ParseContext parseContext) throws IOException, TikaException {
        HttpFetcherConfig additionalHttpFetcherConfig = this.getAdditionalHttpFetcherConfig(parseContext);
        HttpGet get = new HttpGet(fetchKey);
        this.putAdditionalHeadersOnRequest(additionalHttpFetcherConfig, get);
        get.setHeader("Range", "bytes=" + startRange + "-" + endRange);
        return this.execute(get, metadata, this.httpClient, true);
    }

    private void putAdditionalHeadersOnRequest(HttpFetcherConfig additionalFetcherConfig, HttpGet httpGet) throws TikaException {
        if (!StringUtils.isBlank((String)this.httpFetcherConfig.getUserAgent())) {
            httpGet.setHeader(USER_AGENT, this.httpFetcherConfig.getUserAgent());
        }
        if (additionalFetcherConfig != null && additionalFetcherConfig.getHttpRequestHeaders() != null) {
            additionalFetcherConfig.getHttpRequestHeaders().getHeaders().forEach(httpGet::addHeader);
        }
        if (this.httpFetcherConfig.getHttpRequestHeaders() != null) {
            this.httpFetcherConfig.getHttpRequestHeaders().getHeaders().forEach(httpGet::addHeader);
        }
        if (this.jwtGenerator != null) {
            try {
                httpGet.setHeader("Authorization", "Bearer " + this.jwtGenerator.jwt());
            }
            catch (JOSEException e) {
                throw new TikaException("Could not generate JWT", (Throwable)e);
            }
        }
    }

    private static void placeHeaderOnGetRequest(HttpGet get, String httpRequestHeader) {
        int idxOfEquals = httpRequestHeader.indexOf(58);
        if (idxOfEquals == -1) {
            return;
        }
        String headerKey = httpRequestHeader.substring(0, idxOfEquals).trim();
        String headerValue = httpRequestHeader.substring(idxOfEquals + 1).trim();
        get.setHeader(headerKey, headerValue);
    }

    private InputStream execute(final HttpGet get, Metadata metadata, HttpClient client, boolean retryOnBadLength) throws IOException {
        HttpClientContext context = HttpClientContext.create();
        HttpResponse response = null;
        final AtomicBoolean timeout = new AtomicBoolean(false);
        Timer timer = null;
        long overallTimeout = this.httpFetcherConfig.getOverallTimeout() == null ? -1L : this.httpFetcherConfig.getOverallTimeout();
        try {
            InputStream inputStream;
            block20: {
                if (overallTimeout > -1L) {
                    TimerTask task = new TimerTask(){

                        @Override
                        public void run() {
                            timeout.set(true);
                            if (get != null) {
                                get.abort();
                            }
                        }
                    };
                    timer = new Timer(false);
                    timer.schedule(task, overallTimeout);
                }
                response = client.execute((HttpUriRequest)get, context);
                this.updateMetadata(get.getURI().toString(), response, context, metadata);
                int code = response.getStatusLine().getStatusCode();
                this.LOG.info("Fetch id {} status code {}", (Object)get.getURI(), (Object)code);
                if (code < 200 || code > 299) {
                    throw new IOException("bad status code: " + code + " :: " + this.responseToString(response));
                }
                InputStream is = response.getEntity().getContent();
                try {
                    inputStream = this.spool(is, metadata);
                    if (is == null) break block20;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (ConnectionClosedException e) {
                        if (retryOnBadLength && e.getMessage() != null && e.getMessage().contains("Premature end of Content-Length delimited message")) {
                            this.LOG.warn("premature end of content-length delimited message; retrying with content compression disabled for {}", (Object)get.getURI());
                            InputStream inputStream2 = this.execute(get, metadata, this.noCompressHttpClient, false);
                            return inputStream2;
                        }
                        throw e;
                    }
                    catch (IOException e) {
                        if (timeout.get()) {
                            throw new TikaTimeoutException("Overall timeout after " + overallTimeout + "ms");
                        }
                        throw e;
                    }
                }
                is.close();
            }
            return inputStream;
        }
        finally {
            if (timer != null) {
                timer.cancel();
                timer.purge();
            }
            if (response != null) {
                EntityUtils.consumeQuietly(response.getEntity());
            }
            if (response instanceof CloseableHttpResponse) {
                ((CloseableHttpResponse)response).close();
            }
        }
    }

    private InputStream spool(InputStream content, Metadata metadata) throws IOException {
        long start = System.currentTimeMillis();
        TemporaryResources tmp = new TemporaryResources();
        Path tmpFile = tmp.createTempFile(metadata);
        if (this.httpFetcherConfig.getMaxSpoolSize() < 0L) {
            Files.copy(content, tmpFile, StandardCopyOption.REPLACE_EXISTING);
        } else {
            try (OutputStream os = Files.newOutputStream(tmpFile, new OpenOption[0]);){
                long totalRead = IOUtils.copyLarge((InputStream)content, (OutputStream)os, (long)0L, (long)this.httpFetcherConfig.getMaxSpoolSize());
                if (totalRead == this.httpFetcherConfig.getMaxSpoolSize() && content.read() != -1) {
                    metadata.set(HTTP_FETCH_TRUNCATED, "true");
                }
            }
        }
        long elapsed = System.currentTimeMillis() - start;
        this.LOG.debug("took {} ms to copy to local tmp file", (Object)elapsed);
        return TikaInputStream.get((Path)tmpFile, (Metadata)metadata, (TemporaryResources)tmp);
    }

    private void updateMetadata(String url, HttpResponse response, HttpClientContext context, Metadata metadata) {
        List<URI> uriList;
        HttpEntity entity;
        if (response == null) {
            return;
        }
        if (response.getStatusLine() != null) {
            metadata.set(HTTP_STATUS_CODE, response.getStatusLine().getStatusCode());
        }
        if ((entity = response.getEntity()) != null && entity.getContentEncoding() != null) {
            metadata.set(HTTP_CONTENT_ENCODING, entity.getContentEncoding().getValue());
        }
        if (entity != null && entity.getContentType() != null) {
            metadata.set(HTTP_CONTENT_TYPE, entity.getContentType().getValue());
        }
        if (this.httpFetcherConfig.getHttpHeaders() != null) {
            for (String h : this.httpFetcherConfig.getHttpHeaders()) {
                Header[] headers = response.getHeaders(h);
                if (headers == null || headers.length <= 0) continue;
                String name = HTTP_HEADER_PREFIX + h;
                for (Header header : headers) {
                    metadata.add(name, header.getValue());
                }
            }
        }
        if ((uriList = context.getRedirectLocations()) == null) {
            metadata.set(HTTP_NUM_REDIRECTS, 0);
            metadata.set(HTTP_TARGET_URL, url);
        } else {
            metadata.set(HTTP_NUM_REDIRECTS, uriList.size());
            try {
                URI uri = uriList.get(uriList.size() - 1);
                if (uri != null) {
                    URL u = uri.toURL();
                    metadata.set(HTTP_TARGET_URL, u.toString());
                    metadata.set("resourceName", u.getFile());
                }
            }
            catch (MalformedURLException uri) {
                // empty catch block
            }
        }
        HttpConnection connection = context.getConnection();
        if (connection instanceof HttpInetConnection) {
            try {
                InetAddress inetAddress = ((HttpInetConnection)connection).getRemoteAddress();
                if (inetAddress != null) {
                    metadata.set(HTTP_TARGET_IP_ADDRESS, inetAddress.getHostAddress());
                }
            }
            catch (ConnectionShutdownException e) {
                this.LOG.warn("connection shutdown while trying to get target URL: " + url);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String responseToString(HttpResponse response) {
        if (response.getEntity() == null) {
            return "";
        }
        try {
            String string;
            block14: {
                InputStream is = response.getEntity().getContent();
                try {
                    UnsynchronizedByteArrayOutputStream bos = UnsynchronizedByteArrayOutputStream.builder().get();
                    IOUtils.copyLarge((InputStream)is, (OutputStream)bos, (long)0L, (long)this.httpFetcherConfig.getMaxErrMsgSize().intValue());
                    string = bos.toString(StandardCharsets.UTF_8);
                    if (is == null) break block14;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        this.LOG.warn("IOException trying to read error message", (Throwable)e);
                        String string2 = "";
                        return string2;
                    }
                    catch (NullPointerException e) {
                        String string3 = "";
                        return string3;
                    }
                }
                is.close();
            }
            return string;
        }
        finally {
            EntityUtils.consumeQuietly(response.getEntity());
        }
    }

    @Field
    public void setUserName(String userName) {
        this.httpFetcherConfig.setUserName(userName);
    }

    @Field
    public void setPassword(String password) {
        this.httpFetcherConfig.setPassword(password);
    }

    @Field
    public void setNtDomain(String domain) {
        this.httpFetcherConfig.setNtDomain(domain);
    }

    @Field
    public void setAuthScheme(String authScheme) {
        this.httpFetcherConfig.setAuthScheme(authScheme);
    }

    @Field
    public void setProxyHost(String proxyHost) {
        this.httpFetcherConfig.setProxyHost(proxyHost);
    }

    @Field
    public void setProxyPort(int proxyPort) {
        this.httpFetcherConfig.setProxyPort(proxyPort);
    }

    @Field
    public void setConnectTimeout(int connectTimeout) {
        this.httpFetcherConfig.setConnectTimeout(connectTimeout);
    }

    @Field
    public void setRequestTimeout(int requestTimeout) {
        this.httpFetcherConfig.setRequestTimeout(requestTimeout);
    }

    @Field
    public void setSocketTimeout(int socketTimeout) {
        this.httpFetcherConfig.setSocketTimeout(socketTimeout);
    }

    @Field
    public void setMaxConnections(int maxConnections) {
        this.httpFetcherConfig.setMaxConnections(maxConnections);
    }

    @Field
    public void setMaxConnectionsPerRoute(int maxConnectionsPerRoute) {
        this.httpFetcherConfig.setMaxConnectionsPerRoute(maxConnectionsPerRoute);
    }

    @Field
    public void setMaxSpoolSize(long maxSpoolSize) {
        this.httpFetcherConfig.setMaxSpoolSize(maxSpoolSize);
    }

    @Field
    public void setMaxRedirects(int maxRedirects) {
        this.httpFetcherConfig.setMaxRedirects(maxRedirects);
    }

    @Field
    public void setHttpRequestHeaders(List<String> headers) {
        this.httpRequestHeaders.clear();
        this.httpRequestHeaders.addAll(headers);
        this.httpFetcherConfig.setHttpRequestHeaders(new HttpHeaders());
        if (headers != null) {
            HashMap<String, Collection<String>> allParsedHeaders = new HashMap<String, Collection<String>>();
            for (String header : headers) {
                Map<String, Collection<String>> parsedHeaders = HttpFetcher.parseHeaders(header);
                allParsedHeaders.putAll(parsedHeaders);
            }
            this.httpFetcherConfig.getHttpRequestHeaders().setMap(allParsedHeaders);
        }
    }

    public static Map<String, Collection<String>> parseHeaders(String headersString) {
        String[] headers;
        HashMap<String, Collection<String>> headersMap = new HashMap<String, Collection<String>>();
        for (String header : headers = headersString.split("\n")) {
            String[] keyValue = header.split(":", 2);
            if (keyValue.length != 2) continue;
            String key = keyValue[0].trim();
            String value = keyValue[1].trim();
            headersMap.put(key, List.of(value));
        }
        return headersMap;
    }

    @Field
    public void setHttpHeaders(List<String> headers) {
        this.httpFetcherConfig.setHttpHeaders(new ArrayList<String>());
        if (headers != null) {
            this.httpFetcherConfig.getHttpHeaders().addAll(headers);
        }
    }

    @Field
    public void setOverallTimeout(long overallTimeout) {
        this.httpFetcherConfig.setOverallTimeout(overallTimeout);
    }

    @Field
    public void setMaxErrMsgSize(int maxErrMsgSize) {
        this.httpFetcherConfig.setMaxErrMsgSize(maxErrMsgSize);
    }

    @Field
    public void setUserAgent(String userAgent) {
        this.httpFetcherConfig.setUserAgent(userAgent);
    }

    @Field
    public void setJwtIssuer(String jwtIssuer) {
        this.httpFetcherConfig.setJwtIssuer(jwtIssuer);
    }

    @Field
    public void setJwtSubject(String jwtSubject) {
        this.httpFetcherConfig.setJwtSubject(jwtSubject);
    }

    @Field
    public void setJwtExpiresInSeconds(int jwtExpiresInSeconds) {
        this.httpFetcherConfig.setJwtExpiresInSeconds(jwtExpiresInSeconds);
    }

    @Field
    public void setJwtSecret(String jwtSecret) {
        this.httpFetcherConfig.setJwtSecret(jwtSecret);
    }

    @Field
    public void setJwtPrivateKeyBase64(String jwtPrivateKeyBase64) {
        this.httpFetcherConfig.setJwtPrivateKeyBase64(jwtPrivateKeyBase64);
    }

    public void initialize(Map<String, Param> params) throws TikaConfigException {
        if (this.httpFetcherConfig.getSocketTimeout() != null) {
            this.httpClientFactory.setSocketTimeout(this.httpFetcherConfig.getSocketTimeout());
        }
        if (this.httpFetcherConfig.getRequestTimeout() != null) {
            this.httpClientFactory.setRequestTimeout(this.httpFetcherConfig.getRequestTimeout());
        }
        if (this.httpFetcherConfig.getConnectTimeout() != null) {
            this.httpClientFactory.setSocketTimeout(this.httpFetcherConfig.getConnectTimeout());
        }
        if (this.httpFetcherConfig.getMaxConnections() != null) {
            this.httpClientFactory.setMaxConnections(this.httpFetcherConfig.getMaxConnections());
        }
        if (this.httpFetcherConfig.getMaxConnectionsPerRoute() != null) {
            this.httpClientFactory.setMaxConnectionsPerRoute(this.httpFetcherConfig.getMaxConnectionsPerRoute());
        }
        if (!StringUtils.isBlank((String)this.httpFetcherConfig.getAuthScheme())) {
            this.httpClientFactory.setUserName(this.httpFetcherConfig.getUserName());
            this.httpClientFactory.setPassword(this.httpFetcherConfig.getPassword());
            this.httpClientFactory.setAuthScheme(this.httpFetcherConfig.getAuthScheme());
            if (this.httpFetcherConfig.getNtDomain() != null) {
                this.httpClientFactory.setNtDomain(this.httpFetcherConfig.getNtDomain());
            }
        }
        if (!StringUtils.isBlank((String)this.httpFetcherConfig.getProxyHost())) {
            this.httpClientFactory.setProxyHost(this.httpFetcherConfig.getProxyHost());
            this.httpClientFactory.setProxyPort(this.httpFetcherConfig.getProxyPort());
        }
        this.httpClient = this.httpClientFactory.build();
        HttpClientFactory cp = this.httpClientFactory.copy();
        cp.setDisableContentCompression(true);
        this.noCompressHttpClient = cp.build();
        if (!StringUtils.isBlank((String)this.httpFetcherConfig.getJwtPrivateKeyBase64())) {
            PrivateKey key = JwtPrivateKeyCreds.convertBase64ToPrivateKey(this.httpFetcherConfig.getJwtPrivateKeyBase64());
            this.jwtGenerator = new JwtGenerator(new JwtPrivateKeyCreds(key, this.httpFetcherConfig.getJwtIssuer(), this.httpFetcherConfig.getJwtSubject(), this.httpFetcherConfig.getJwtExpiresInSeconds()));
        } else if (!StringUtils.isBlank((String)this.httpFetcherConfig.getJwtSecret())) {
            this.jwtGenerator = new JwtGenerator(new JwtSecretCreds(this.httpFetcherConfig.getJwtSecret().getBytes(StandardCharsets.UTF_8), this.httpFetcherConfig.getJwtIssuer(), this.httpFetcherConfig.getJwtSubject(), this.httpFetcherConfig.getJwtExpiresInSeconds()));
        }
    }

    public void checkInitialization(InitializableProblemHandler problemHandler) throws TikaConfigException {
        if (!StringUtils.isBlank((String)this.httpFetcherConfig.getJwtSecret()) && !StringUtils.isBlank((String)this.httpFetcherConfig.getJwtPrivateKeyBase64())) {
            throw new TikaConfigException("Both JWT secret and JWT private key base 64 were specified. Only one or the other is supported");
        }
    }

    public void setHttpClientFactory(HttpClientFactory httpClientFactory) {
        this.httpClientFactory = httpClientFactory;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public HttpFetcherConfig getHttpFetcherConfig() {
        return this.httpFetcherConfig;
    }

    public void setHttpFetcherConfig(HttpFetcherConfig httpFetcherConfig) {
        this.httpFetcherConfig = httpFetcherConfig;
    }
}

