/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.udp;

import io.netty.channel.ChannelFuture;
import io.netty.channel.socket.DatagramChannel;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import org.jspecify.annotations.Nullable;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.FutureMono;
import reactor.netty.ReactorNetty;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.udp.UdpInbound;
import reactor.netty.udp.UdpOutbound;
import reactor.util.Logger;
import reactor.util.Loggers;

final class UdpOperations
extends ChannelOperations<UdpInbound, UdpOutbound>
implements UdpInbound,
UdpOutbound {
    static final Logger log = Loggers.getLogger(UdpOperations.class);

    UdpOperations(Connection c, ConnectionObserver listener) {
        super(c, listener);
    }

    @Override
    public Mono<Void> join(InetAddress multicastAddress, @Nullable NetworkInterface iface) {
        if (!(this.connection().channel() instanceof DatagramChannel)) {
            throw new UnsupportedOperationException();
        }
        DatagramChannel datagramChannel = (DatagramChannel)this.connection().channel();
        if (null == iface && null != datagramChannel.config().getNetworkInterface()) {
            iface = datagramChannel.config().getNetworkInterface();
        }
        ChannelFuture future = null != iface ? datagramChannel.joinGroup(new InetSocketAddress(multicastAddress, datagramChannel.localAddress().getPort()), iface) : datagramChannel.joinGroup(multicastAddress);
        return FutureMono.from(future).doOnSuccess(v -> {
            if (log.isInfoEnabled()) {
                log.info(ReactorNetty.format(future.channel(), "JOIN {}"), multicastAddress);
            }
        });
    }

    @Override
    public Mono<Void> leave(InetAddress multicastAddress, @Nullable NetworkInterface iface) {
        if (!(this.connection().channel() instanceof DatagramChannel)) {
            throw new UnsupportedOperationException();
        }
        DatagramChannel datagramChannel = (DatagramChannel)this.connection().channel();
        if (null == iface && null != datagramChannel.config().getNetworkInterface()) {
            iface = datagramChannel.config().getNetworkInterface();
        }
        ChannelFuture future = null != iface ? datagramChannel.leaveGroup(new InetSocketAddress(multicastAddress, datagramChannel.localAddress().getPort()), iface) : datagramChannel.leaveGroup(multicastAddress);
        return FutureMono.from(future).doOnSuccess(v -> {
            if (log.isInfoEnabled()) {
                log.info(ReactorNetty.format(future.channel(), "JOIN {}"), multicastAddress);
            }
        });
    }
}

