/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.tcp;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.util.AsyncMapping;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import org.jspecify.annotations.Nullable;
import reactor.core.Exceptions;
import reactor.netty.ReactorNetty;
import reactor.netty.tcp.SniProvider;
import reactor.netty.tcp.TcpClientSecure;
import reactor.netty.transport.logging.AdvancedByteBufFormat;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.Incubating;

public final class SslProvider {
    final SslContext sslContext;
    final long handshakeTimeoutMillis;
    final long closeNotifyFlushTimeoutMillis;
    final long closeNotifyReadTimeoutMillis;
    final @Nullable Consumer<? super SslHandler> handlerConfigurator;
    final int builderHashCode;
    final @Nullable SniProvider sniProvider;
    final Map<String, SslProvider> confPerDomainName;
    final @Nullable List<SNIServerName> serverNames;
    final @Nullable AsyncMapping<String, SslProvider> sniMappings;
    static final Logger log = Loggers.getLogger(SslProvider.class);
    static final LoggingHandler LOGGING_HANDLER = AdvancedByteBufFormat.HEX_DUMP.toLoggingHandler("reactor.netty.tcp.ssl", LogLevel.DEBUG, Charset.defaultCharset());

    public static SslContextSpec builder() {
        return new Build();
    }

    public static SslProvider addHandlerConfigurator(SslProvider provider, Consumer<? super SslHandler> handlerConfigurator) {
        Objects.requireNonNull(provider, "provider");
        Objects.requireNonNull(handlerConfigurator, "handlerConfigurator");
        return new SslProvider(provider, handlerConfigurator);
    }

    public static SslProvider defaultClientProvider() {
        return TcpClientSecure.DEFAULT_SSL_PROVIDER;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    SslProvider(Build builder) {
        this.confPerDomainName = builder.confPerDomainName;
        if (builder.sslContext == null) {
            if (builder.genericSslContextSpec == null) throw new IllegalArgumentException("Neither SslContextBuilder nor SslContext is specified");
            try {
                if (!this.confPerDomainName.isEmpty() && builder.genericSslContextSpec instanceof GenericSslContextSpecWithSniSupport) {
                    this.sslContext = ((GenericSslContextSpecWithSniSupport)builder.genericSslContextSpec).sslContext(this.confPerDomainName);
                }
                this.sslContext = builder.genericSslContextSpec.sslContext();
            }
            catch (SSLException e) {
                throw Exceptions.propagate(e);
            }
        } else {
            this.sslContext = builder.sslContext;
        }
        this.serverNames = builder.serverNames;
        if (this.serverNames != null) {
            Consumer<SslHandler> configurator = h -> {
                SSLEngine engine = h.engine();
                SSLParameters sslParameters = engine.getSSLParameters();
                sslParameters.setServerNames(this.serverNames);
                engine.setSSLParameters(sslParameters);
            };
            this.handlerConfigurator = builder.handlerConfigurator == null ? configurator : configurator.andThen(builder.handlerConfigurator);
        } else {
            this.handlerConfigurator = builder.handlerConfigurator;
        }
        this.handshakeTimeoutMillis = builder.handshakeTimeoutMillis;
        this.closeNotifyFlushTimeoutMillis = builder.closeNotifyFlushTimeoutMillis;
        this.closeNotifyReadTimeoutMillis = builder.closeNotifyReadTimeoutMillis;
        this.builderHashCode = builder.hashCode();
        this.sniMappings = builder.sniMappings;
        this.sniProvider = !this.confPerDomainName.isEmpty() ? new SniProvider(this.confPerDomainName, this) : (this.sniMappings != null ? new SniProvider(this.sniMappings, builder.handshakeTimeoutMillis) : null);
    }

    SslProvider(SslProvider from, Consumer<? super SslHandler> handlerConfigurator) {
        this.sslContext = from.sslContext;
        this.handlerConfigurator = from.handlerConfigurator == null ? handlerConfigurator : h -> {
            handlerConfigurator.accept((SslHandler)h);
            from.handlerConfigurator.accept((SslHandler)h);
        };
        this.handshakeTimeoutMillis = from.handshakeTimeoutMillis;
        this.closeNotifyFlushTimeoutMillis = from.closeNotifyFlushTimeoutMillis;
        this.closeNotifyReadTimeoutMillis = from.closeNotifyReadTimeoutMillis;
        this.builderHashCode = from.builderHashCode;
        this.confPerDomainName = from.confPerDomainName;
        this.serverNames = from.serverNames;
        this.sniMappings = from.sniMappings;
        this.sniProvider = from.sniProvider;
    }

    public SslContext getSslContext() {
        return this.sslContext;
    }

    @Incubating
    public @Nullable List<SNIServerName> getServerNames() {
        return this.serverNames;
    }

    public void configure(SslHandler sslHandler) {
        Objects.requireNonNull(sslHandler, "sslHandler");
        sslHandler.setHandshakeTimeoutMillis(this.handshakeTimeoutMillis);
        sslHandler.setCloseNotifyFlushTimeoutMillis(this.closeNotifyFlushTimeoutMillis);
        sslHandler.setCloseNotifyReadTimeoutMillis(this.closeNotifyReadTimeoutMillis);
        if (this.handlerConfigurator != null) {
            this.handlerConfigurator.accept(sslHandler);
        }
    }

    public void addSslHandler(Channel channel, @Nullable SocketAddress remoteAddress, boolean sslDebug) {
        SslHandler sslHandler;
        Objects.requireNonNull(channel, "channel");
        if (this.sniProvider != null) {
            this.sniProvider.addSniHandler(channel, sslDebug);
            return;
        }
        if (remoteAddress instanceof InetSocketAddress) {
            InetSocketAddress sniInfo = (InetSocketAddress)remoteAddress;
            sslHandler = this.getSslContext().newHandler(channel.alloc(), sniInfo.getHostString(), sniInfo.getPort());
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(channel, "SSL enabled using engine {} and SNI {}"), sslHandler.engine(), sniInfo);
            }
        } else {
            sslHandler = this.getSslContext().newHandler(channel.alloc());
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(channel, "SSL enabled using engine {}"), sslHandler.engine());
            }
        }
        this.configure(sslHandler);
        ChannelPipeline pipeline = channel.pipeline();
        if (pipeline.get("reactor.left.proxyHandler") != null) {
            pipeline.addAfter("reactor.left.proxyHandler", "reactor.left.sslHandler", sslHandler);
        } else if (pipeline.get("reactor.left.nonSslRedirectDetector") != null) {
            pipeline.addAfter("reactor.left.nonSslRedirectDetector", "reactor.left.sslHandler", sslHandler);
        } else {
            pipeline.addFirst("reactor.left.sslHandler", (ChannelHandler)sslHandler);
        }
        SslProvider.addSslReadHandler(pipeline, sslDebug);
    }

    public String toString() {
        return "SslProvider {handshakeTimeoutMillis=" + this.handshakeTimeoutMillis + ", closeNotifyFlushTimeoutMillis=" + this.closeNotifyFlushTimeoutMillis + ", closeNotifyReadTimeoutMillis=" + this.closeNotifyReadTimeoutMillis + '}';
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SslProvider that = (SslProvider)o;
        return this.builderHashCode == that.builderHashCode;
    }

    public int hashCode() {
        return this.builderHashCode;
    }

    static void addSslReadHandler(ChannelPipeline pipeline, boolean sslDebug) {
        if (pipeline.get("reactor.left.loggingHandler") != null) {
            pipeline.addAfter("reactor.left.loggingHandler", "reactor.left.sslReader", new SslReadHandler());
            if (sslDebug) {
                pipeline.addBefore("reactor.left.sslHandler", "reactor.left.sslLoggingHandler", LOGGING_HANDLER);
            }
        } else {
            pipeline.addAfter("reactor.left.sslHandler", "reactor.left.sslReader", new SslReadHandler());
        }
    }

    static final class SslReadHandler
    extends ChannelInboundHandlerAdapter {
        boolean handshakeDone;

        SslReadHandler() {
        }

        @Override
        public void channelActive(ChannelHandlerContext ctx) {
            ctx.read();
        }

        @Override
        public void channelReadComplete(ChannelHandlerContext ctx) {
            if (!this.handshakeDone) {
                ctx.read();
            }
            ctx.fireChannelReadComplete();
        }

        @Override
        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
            if (evt instanceof SslHandshakeCompletionEvent) {
                SslHandshakeCompletionEvent handshake;
                this.handshakeDone = true;
                if (ctx.pipeline().context(this) != null) {
                    ctx.pipeline().remove(this);
                }
                if ((handshake = (SslHandshakeCompletionEvent)evt).isSuccess()) {
                    ctx.fireChannelActive();
                } else {
                    ctx.fireExceptionCaught(handshake.cause());
                }
            }
            ctx.fireUserEventTriggered(evt);
        }
    }

    static final class Build
    implements SslContextSpec,
    Builder {
        static final long DEFAULT_SSL_HANDSHAKE_TIMEOUT = Long.parseLong(System.getProperty("reactor.netty.tcp.sslHandshakeTimeout", "10000"));
        @Nullable GenericSslContextSpec<?> genericSslContextSpec;
        @Nullable SslContext sslContext;
        @Nullable Consumer<? super SslHandler> handlerConfigurator;
        long handshakeTimeoutMillis = DEFAULT_SSL_HANDSHAKE_TIMEOUT;
        long closeNotifyFlushTimeoutMillis = 3000L;
        long closeNotifyReadTimeoutMillis;
        @Nullable List<SNIServerName> serverNames;
        final Map<String, SslProvider> confPerDomainName = new HashMap<String, SslProvider>();
        @Nullable AsyncMapping<String, SslProvider> sniMappings;

        Build() {
        }

        @Override
        public Builder sslContext(GenericSslContextSpec<?> genericSslContextSpec) {
            this.genericSslContextSpec = genericSslContextSpec;
            return this;
        }

        @Override
        public Builder sslContext(ProtocolSslContextSpec protocolSslContextSpec) {
            this.genericSslContextSpec = protocolSslContextSpec;
            return this;
        }

        @Override
        public final Builder sslContext(SslContext sslContext) {
            this.sslContext = Objects.requireNonNull(sslContext, "sslContext");
            return this;
        }

        @Override
        public final Builder handshakeTimeout(Duration handshakeTimeout) {
            Objects.requireNonNull(handshakeTimeout, "handshakeTimeout");
            return this.handshakeTimeoutMillis(handshakeTimeout.toMillis());
        }

        @Override
        public final Builder handlerConfigurator(Consumer<? super SslHandler> handlerConfigurator) {
            Objects.requireNonNull(handlerConfigurator, "handlerConfigurator");
            this.handlerConfigurator = handlerConfigurator;
            return this;
        }

        @Override
        public final Builder handshakeTimeoutMillis(long handshakeTimeoutMillis) {
            if (handshakeTimeoutMillis < 0L) {
                throw new IllegalArgumentException("ssl handshake timeout must be positive was: " + handshakeTimeoutMillis);
            }
            this.handshakeTimeoutMillis = handshakeTimeoutMillis;
            return this;
        }

        @Override
        public final Builder closeNotifyFlushTimeout(Duration closeNotifyFlushTimeout) {
            Objects.requireNonNull(closeNotifyFlushTimeout, "closeNotifyFlushTimeout");
            return this.closeNotifyFlushTimeoutMillis(closeNotifyFlushTimeout.toMillis());
        }

        @Override
        public final Builder closeNotifyFlushTimeoutMillis(long closeNotifyFlushTimeoutMillis) {
            if (closeNotifyFlushTimeoutMillis < 0L) {
                throw new IllegalArgumentException("ssl close_notify flush timeout must be positive, was: " + closeNotifyFlushTimeoutMillis);
            }
            this.closeNotifyFlushTimeoutMillis = closeNotifyFlushTimeoutMillis;
            return this;
        }

        @Override
        public final Builder closeNotifyReadTimeout(Duration closeNotifyReadTimeout) {
            Objects.requireNonNull(closeNotifyReadTimeout, "closeNotifyReadTimeout");
            return this.closeNotifyReadTimeoutMillis(closeNotifyReadTimeout.toMillis());
        }

        @Override
        public final Builder closeNotifyReadTimeoutMillis(long closeNotifyReadTimeoutMillis) {
            if (closeNotifyReadTimeoutMillis < 0L) {
                throw new IllegalArgumentException("ssl close_notify read timeout must be positive, was: " + closeNotifyReadTimeoutMillis);
            }
            this.closeNotifyReadTimeoutMillis = closeNotifyReadTimeoutMillis;
            return this;
        }

        @Override
        public Builder addSniMapping(String domainName, Consumer<? super SslContextSpec> sslProviderBuilder) {
            this.addInternal(domainName, sslProviderBuilder);
            this.sniMappings = null;
            return this;
        }

        @Override
        public Builder addSniMappings(Map<String, Consumer<? super SslContextSpec>> confPerDomainName) {
            Objects.requireNonNull(confPerDomainName);
            confPerDomainName.forEach(this::addInternal);
            this.sniMappings = null;
            return this;
        }

        @Override
        public Builder setSniMappings(Map<String, Consumer<? super SslContextSpec>> confPerDomainName) {
            Objects.requireNonNull(confPerDomainName);
            this.confPerDomainName.clear();
            confPerDomainName.forEach(this::addInternal);
            this.sniMappings = null;
            return this;
        }

        @Override
        public Builder setSniAsyncMappings(AsyncMapping<String, SslProvider> mappings) {
            this.sniMappings = Objects.requireNonNull(mappings);
            this.confPerDomainName.clear();
            return this;
        }

        @Override
        public Builder serverNames(SNIServerName ... serverNames) {
            Objects.requireNonNull(serverNames);
            this.serverNames = Arrays.asList(serverNames);
            return this;
        }

        @Override
        public SslProvider build() {
            return new SslProvider(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Build)) {
                return false;
            }
            Build build = (Build)o;
            return this.handshakeTimeoutMillis == build.handshakeTimeoutMillis && this.closeNotifyFlushTimeoutMillis == build.closeNotifyFlushTimeoutMillis && this.closeNotifyReadTimeoutMillis == build.closeNotifyReadTimeoutMillis && Objects.equals(this.sslContext, build.sslContext) && Objects.equals(this.handlerConfigurator, build.handlerConfigurator) && Objects.equals(this.serverNames, build.serverNames) && this.confPerDomainName.equals(build.confPerDomainName) && Objects.equals(this.genericSslContextSpec, build.genericSslContextSpec);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + Objects.hashCode(this.sslContext);
            result = 31 * result + Objects.hashCode(this.handlerConfigurator);
            result = 31 * result + Long.hashCode(this.handshakeTimeoutMillis);
            result = 31 * result + Long.hashCode(this.closeNotifyFlushTimeoutMillis);
            result = 31 * result + Long.hashCode(this.closeNotifyReadTimeoutMillis);
            result = 31 * result + Objects.hashCode(this.serverNames);
            result = 31 * result + Objects.hashCode(this.confPerDomainName);
            result = 31 * result + Objects.hashCode(this.genericSslContextSpec);
            return result;
        }

        void addInternal(String domainName, Consumer<? super SslContextSpec> sslProviderBuilder) {
            Objects.requireNonNull(domainName, "domainName");
            Objects.requireNonNull(sslProviderBuilder, "sslProviderBuilder");
            SslContextSpec builder = SslProvider.builder();
            sslProviderBuilder.accept(builder);
            this.confPerDomainName.put(domainName, ((Builder)((Object)builder)).build());
        }
    }

    public static interface ProtocolSslContextSpec
    extends GenericSslContextSpec<SslContextBuilder> {
        public ProtocolSslContextSpec configure(Consumer<SslContextBuilder> var1);
    }

    @Incubating
    public static interface GenericSslContextSpecWithSniSupport<B>
    extends GenericSslContextSpec<B> {
        @Override
        public GenericSslContextSpecWithSniSupport<B> configure(Consumer<B> var1);

        public SslContext sslContext(Map<String, SslProvider> var1) throws SSLException;
    }

    public static interface GenericSslContextSpec<B> {
        public GenericSslContextSpec<B> configure(Consumer<B> var1);

        public SslContext sslContext() throws SSLException;
    }

    public static interface SslContextSpec {
        public Builder sslContext(GenericSslContextSpec<?> var1);

        @Deprecated
        public Builder sslContext(ProtocolSslContextSpec var1);

        public Builder sslContext(SslContext var1);
    }

    public static interface Builder {
        public Builder handlerConfigurator(Consumer<? super SslHandler> var1);

        public Builder handshakeTimeout(Duration var1);

        public Builder handshakeTimeoutMillis(long var1);

        public Builder closeNotifyFlushTimeout(Duration var1);

        public Builder closeNotifyFlushTimeoutMillis(long var1);

        public Builder closeNotifyReadTimeout(Duration var1);

        public Builder closeNotifyReadTimeoutMillis(long var1);

        public Builder addSniMapping(String var1, Consumer<? super SslContextSpec> var2);

        public Builder addSniMappings(Map<String, Consumer<? super SslContextSpec>> var1);

        public Builder setSniMappings(Map<String, Consumer<? super SslContextSpec>> var1);

        public Builder setSniAsyncMappings(AsyncMapping<String, SslProvider> var1);

        public Builder serverNames(SNIServerName ... var1);

        public SslProvider build();
    }
}

