/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import io.netty.handler.codec.quic.QuicChannel;
import java.net.SocketAddress;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import org.jspecify.annotations.Nullable;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.http.logging.HttpMessageLogFactory;
import reactor.netty.http.server.ConnectionInfo;
import reactor.netty.http.server.HttpServerFormDecoderProvider;
import reactor.netty.http.server.HttpServerOperations;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;
import reactor.netty.http.server.compression.HttpCompressionOptionsSpec;

final class Http3ServerOperations
extends HttpServerOperations {
    static final HttpVersion H3 = HttpVersion.valueOf("HTTP/3.0");

    Http3ServerOperations(HttpServerOperations replaced) {
        super(replaced);
    }

    Http3ServerOperations(Connection c, ConnectionObserver listener, HttpRequest nettyRequest, @Nullable HttpCompressionOptionsSpec compressionOptions, @Nullable BiPredicate<HttpServerRequest, HttpServerResponse> compressionPredicate, ConnectionInfo connectionInfo, ServerCookieDecoder decoder, ServerCookieEncoder encoder, HttpServerFormDecoderProvider formDecoderProvider, HttpMessageLogFactory httpMessageLogFactory, boolean isHttp2, @Nullable BiFunction<? super Mono<Void>, ? super Connection, ? extends Mono<Void>> mapHandle, @Nullable Duration readTimeout, @Nullable Duration requestTimeout, boolean secured, ZonedDateTime timestamp) {
        super(c, listener, nettyRequest, compressionOptions, compressionPredicate, connectionInfo, decoder, encoder, formDecoderProvider, httpMessageLogFactory, isHttp2, mapHandle, readTimeout, requestTimeout, secured, timestamp, true);
    }

    @Override
    public @Nullable SocketAddress connectionHostAddress() {
        return ((QuicChannel)this.channel().parent()).localSocketAddress();
    }

    @Override
    public @Nullable SocketAddress connectionRemoteAddress() {
        return ((QuicChannel)this.channel().parent()).remoteSocketAddress();
    }

    @Override
    public String protocol() {
        return H3.text();
    }

    @Override
    public HttpVersion version() {
        if (this.nettyRequest != null) {
            return H3;
        }
        throw new IllegalStateException("request not parsed");
    }
}

