/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.compression.ZlibCodecFactory;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocket13FrameDecoder;
import io.netty.handler.codec.http.websocketx.WebSocket13FrameEncoder;
import io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import io.netty.handler.codec.http.websocketx.WebSocketDecoderConfig;
import io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import io.netty.handler.codec.http.websocketx.WebSocketFrameEncoder;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtension;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionData;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionDecoder;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionEncoder;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionUtil;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtension;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtensionHandshaker;
import io.netty.handler.codec.http.websocketx.extensions.compression.DeflateFrameServerExtensionHandshaker;
import io.netty.handler.codec.http.websocketx.extensions.compression.PerMessageDeflateServerExtensionHandshaker;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.EmptyArrays;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Subscriber;
import reactor.core.publisher.Mono;
import reactor.netty.FutureMono;
import reactor.netty.ReactorNetty;
import reactor.netty.http.server.AbstractHttpServerMetricsHandler;
import reactor.netty.http.server.HttpServerOperations;
import reactor.netty.http.server.WebsocketServerOperations;
import reactor.netty.http.server.WebsocketServerSpec;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

final class Http2WebsocketServerOperations
extends WebsocketServerOperations {
    WebsocketServerHandshaker handshakerHttp2;
    static final ChannelFutureListener EMPTY = f -> {};

    Http2WebsocketServerOperations(String wsUrl, WebsocketServerSpec websocketServerSpec, HttpServerOperations replaced) {
        super(wsUrl, websocketServerSpec, replaced);
    }

    @Override
    public @Nullable String selectedSubprotocol() {
        return this.handshakerHttp2.selectedSubProtocol;
    }

    @Override
    protected void onInboundCancel() {
        if (log.isDebugEnabled()) {
            log.debug(ReactorNetty.format(this.channel(), "WebSocket server inbound receiver cancelled, closing Websocket."));
        }
        this.sendCloseNow(new CloseWebSocketFrame(), WebSocketCloseStatus.ABNORMAL_CLOSURE, EMPTY);
    }

    @Override
    void initHandshaker(String wsUrl, WebsocketServerSpec websocketServerSpec, HttpServerOperations replaced) {
        this.handshakerResult = this.channel().newPromise();
        if (this.isValid()) {
            Channel channel = this.channel();
            this.removeHandler("reactor.left.accessLogHandler");
            ChannelHandler handler = channel.pipeline().get("reactor.left.httpMetricsHandler");
            if (handler != null) {
                this.replaceHandler("reactor.left.httpMetricsHandler", new WebsocketServerOperations.WebsocketHttpServerMetricsHandler((AbstractHttpServerMetricsHandler)handler));
            }
            DefaultHttpRequest request = new DefaultHttpRequest(replaced.version(), replaced.method(), replaced.uri());
            request.headers().set(replaced.nettyRequest.headers());
            if (websocketServerSpec.compress()) {
                this.removeHandler("reactor.left.compressionHandler");
                PerMessageDeflateServerExtensionHandshaker perMessageDeflateServerExtensionHandshaker = new PerMessageDeflateServerExtensionHandshaker(6, ZlibCodecFactory.isSupportingWindowSizeAndMemLevel(), 15, websocketServerSpec.compressionAllowServerNoContext(), websocketServerSpec.compressionPreferredClientNoContext(), 0);
                WebsocketServerExtensionHandler wsServerExtensionHandler = new WebsocketServerExtensionHandler(Arrays.asList(perMessageDeflateServerExtensionHandshaker, new DeflateFrameServerExtensionHandshaker(6, 0)));
                try {
                    ChannelPipeline pipeline = channel.pipeline();
                    wsServerExtensionHandler.channelRead(pipeline.context("reactor.right.reactiveBridge"), request);
                    if (pipeline.get("reactor.left.httpTrafficHandler") != null) {
                        pipeline.addAfter("reactor.left.httpTrafficHandler", "reactor.left.wsCompressionHandler", wsServerExtensionHandler);
                    }
                }
                catch (Throwable e) {
                    log.error(ReactorNetty.format(channel, ""), e);
                }
            }
            this.handshakerHttp2 = new WebsocketServerHandshaker(wsUrl, websocketServerSpec);
            this.handshakerHttp2.handshake(channel, request, this.responseHeaders.remove(HttpHeaderNames.TRANSFER_ENCODING), this.handshakerResult).addListener(f -> {
                if (replaced.rebind(this)) {
                    this.markPersistent(false);
                    channel.read();
                } else if (log.isDebugEnabled()) {
                    log.debug(ReactorNetty.format(channel, "Cannot bind Http2WebsocketServerOperations after the handshake."));
                }
            });
        }
    }

    boolean isValid() {
        String msg = null;
        if (this.nettyRequest instanceof FullHttpRequest) {
            msg = "Failed to upgrade to websocket. End of stream is received.";
        } else if (!HttpMethod.CONNECT.equals(this.method())) {
            msg = "Invalid websocket request handshake method [" + this.method() + "].";
        } else if (!this.requestHeaders().contains((CharSequence)"x-http2-protocol", HttpHeaderValues.WEBSOCKET, true)) {
            msg = "Invalid websocket request, missing [:protocol=websocket] header.";
        } else {
            String version = this.requestHeaders().get(HttpHeaderNames.SEC_WEBSOCKET_VERSION);
            if (version == null || !version.equals(WebSocketVersion.V13.toHttpHeaderValue())) {
                msg = "Websocket version [" + version + "] is not supported.";
            }
        }
        if (msg != null) {
            DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST, Unpooled.EMPTY_BUFFER);
            res.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)"0");
            WebSocketServerHandshakeException handshakeException = new WebSocketServerHandshakeException(msg, this.nettyRequest);
            this.channel().writeAndFlush(res).addListener(f -> this.handshakerResult.setFailure(handshakeException));
            return false;
        }
        return true;
    }

    @Override
    Mono<Void> sendClose(CloseWebSocketFrame frame) {
        if (CLOSE_SENT.get(this) == 0) {
            return FutureMono.deferFuture(() -> {
                if (CLOSE_SENT.getAndSet(this, 1) == 0) {
                    this.discard();
                    this.onCloseState.tryEmitValue(new WebSocketCloseStatus(frame.statusCode(), frame.reasonText()));
                    this.channel().write(frame);
                    return this.channel().writeAndFlush(LastHttpContent.EMPTY_LAST_CONTENT).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                }
                frame.release();
                return this.channel().newSucceededFuture();
            }).doOnCancel(() -> ReactorNetty.safeRelease(frame));
        }
        frame.release();
        return Mono.empty();
    }

    @Override
    void sendCloseNow(CloseWebSocketFrame frame, WebSocketCloseStatus closeStatus, ChannelFutureListener listener) {
        if (!frame.isFinalFragment()) {
            this.channel().writeAndFlush(frame);
            return;
        }
        if (CLOSE_SENT.getAndSet(this, 1) == 0) {
            this.onCloseState.tryEmitValue(closeStatus);
            this.channel().write(frame);
            this.channel().writeAndFlush(LastHttpContent.EMPTY_LAST_CONTENT).addListener((GenericFutureListener)listener);
        } else {
            frame.release();
        }
    }

    @Override
    Subscriber<Void> websocketSubscriber(ContextView contextView) {
        return new HttpServerOperations.WebsocketSubscriber(this, Context.of(contextView), EMPTY);
    }

    static final class WebsocketServerExtensionHandler
    extends ChannelDuplexHandler {
        final List<WebSocketServerExtensionHandshaker> extensionHandshakers;
        final Queue<List<WebSocketServerExtension>> validExtensions = new ArrayDeque<List<WebSocketServerExtension>>(4);
        static final String EXTENSION_SEPARATOR = ",";
        static final String PARAMETER_SEPARATOR = ";";
        static final char PARAMETER_EQUAL = '=';

        WebsocketServerExtensionHandler(List<WebSocketServerExtensionHandshaker> extensionHandshakers) {
            this.extensionHandshakers = extensionHandshakers;
        }

        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            if (msg != LastHttpContent.EMPTY_LAST_CONTENT) {
                if (msg instanceof DefaultHttpRequest) {
                    this.onHttpRequestChannelRead(ctx, (DefaultHttpRequest)msg);
                } else if (msg instanceof HttpRequest) {
                    this.onHttpRequestChannelRead(ctx, (HttpRequest)msg);
                } else {
                    ctx.fireChannelRead(msg);
                }
            } else {
                ctx.fireChannelRead(msg);
            }
        }

        void onHttpRequestChannelRead(ChannelHandlerContext ctx, HttpRequest request) {
            List validExtensionsList = null;
            String extensionsHeader = request.headers().getAsString(HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS);
            if (extensionsHeader != null) {
                List<WebSocketExtensionData> extensions = WebSocketExtensionUtil.extractExtensions(extensionsHeader);
                int rsv = 0;
                for (WebSocketExtensionData extensionData : extensions) {
                    Iterator<WebSocketServerExtensionHandshaker> extensionHandshakersIterator = this.extensionHandshakers.iterator();
                    WebSocketExtension validExtension = null;
                    while (validExtension == null && extensionHandshakersIterator.hasNext()) {
                        WebSocketServerExtensionHandshaker extensionHandshaker = extensionHandshakersIterator.next();
                        validExtension = extensionHandshaker.handshakeExtension(extensionData);
                    }
                    if (validExtension == null || (validExtension.rsv() & rsv) != 0) continue;
                    if (validExtensionsList == null) {
                        validExtensionsList = new ArrayList(1);
                    }
                    rsv |= validExtension.rsv();
                    validExtensionsList.add(validExtension);
                }
            }
            if (validExtensionsList == null) {
                validExtensionsList = Collections.emptyList();
            }
            this.validExtensions.offer(validExtensionsList);
            ctx.fireChannelRead(request);
        }

        @Override
        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
            if (msg != Unpooled.EMPTY_BUFFER && !(msg instanceof ByteBuf)) {
                if (msg.getClass() == DefaultHttpResponse.class) {
                    this.onHttpResponseWrite(ctx, (DefaultHttpResponse)msg, promise);
                } else if (msg instanceof HttpResponse) {
                    this.onHttpResponseWrite(ctx, (HttpResponse)msg, promise);
                } else {
                    ctx.write(msg, promise);
                }
            } else {
                ctx.write(msg, promise);
            }
        }

        void onHttpResponseWrite(ChannelHandlerContext ctx, HttpResponse response, ChannelPromise promise) {
            List<WebSocketServerExtension> validExtensionsList = this.validExtensions.poll();
            if (HttpResponseStatus.OK.equals(response.status())) {
                this.handlePotentialUpgrade(ctx, promise, response, validExtensionsList);
            }
            ctx.write(response, promise);
        }

        void handlePotentialUpgrade(ChannelHandlerContext ctx, ChannelPromise promise, HttpResponse httpResponse, @Nullable List<WebSocketServerExtension> validExtensionsList) {
            HttpHeaders headers = httpResponse.headers();
            if (validExtensionsList != null && !validExtensionsList.isEmpty()) {
                String headerValue = headers.getAsString(HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS);
                ArrayList<WebSocketExtensionData> extraExtensions = new ArrayList<WebSocketExtensionData>(this.extensionHandshakers.size());
                for (WebSocketServerExtension extension : validExtensionsList) {
                    extraExtensions.add(extension.newReponseData());
                }
                String newHeaderValue = WebsocketServerExtensionHandler.computeMergeExtensionsHeaderValue(headerValue, extraExtensions);
                promise.addListener(future -> {
                    if (future.isSuccess()) {
                        for (WebSocketServerExtension extension : validExtensionsList) {
                            WebSocketExtensionDecoder decoder = extension.newExtensionDecoder();
                            WebSocketExtensionEncoder encoder = extension.newExtensionEncoder();
                            String name = ctx.name();
                            ctx.pipeline().addAfter(name, decoder.getClass().getName(), decoder).addAfter(name, encoder.getClass().getName(), encoder);
                        }
                    }
                });
                if (!newHeaderValue.isEmpty()) {
                    headers.set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS, (Object)newHeaderValue);
                }
            }
            promise.addListener(future -> {
                if (future.isSuccess()) {
                    ctx.pipeline().remove(this);
                }
            });
        }

        static String computeMergeExtensionsHeaderValue(@Nullable String userDefinedHeaderValue, List<WebSocketExtensionData> extraExtensions) {
            List<Object> userDefinedExtensions = userDefinedHeaderValue != null ? WebSocketExtensionUtil.extractExtensions(userDefinedHeaderValue) : Collections.emptyList();
            for (WebSocketExtensionData webSocketExtensionData : userDefinedExtensions) {
                int i;
                WebSocketExtensionData matchingExtra = null;
                for (i = 0; i < extraExtensions.size(); ++i) {
                    WebSocketExtensionData extra = extraExtensions.get(i);
                    if (!extra.name().equals(webSocketExtensionData.name())) continue;
                    matchingExtra = extra;
                    break;
                }
                if (matchingExtra == null) {
                    extraExtensions.add(webSocketExtensionData);
                    continue;
                }
                HashMap<String, String> mergedParameters = new HashMap<String, String>(matchingExtra.parameters());
                mergedParameters.putAll(webSocketExtensionData.parameters());
                extraExtensions.set(i, new WebSocketExtensionData(matchingExtra.name(), mergedParameters));
            }
            StringBuilder sb = new StringBuilder(150);
            for (WebSocketExtensionData data : extraExtensions) {
                sb.append(data.name());
                for (Map.Entry<String, String> parameter : data.parameters().entrySet()) {
                    sb.append(PARAMETER_SEPARATOR);
                    sb.append(parameter.getKey());
                    if (parameter.getValue() == null) continue;
                    sb.append('=');
                    sb.append(parameter.getValue());
                }
                sb.append(EXTENSION_SEPARATOR);
            }
            if (!extraExtensions.isEmpty()) {
                sb.setLength(sb.length() - EXTENSION_SEPARATOR.length());
            }
            return sb.toString();
        }
    }

    static final class WebsocketServerHandshaker {
        static final String SUB_PROTOCOL_WILDCARD = "*";
        final String uri;
        final String[] subProtocols;
        final WebSocketDecoderConfig decoderConfig;
        @Nullable String selectedSubProtocol;

        WebsocketServerHandshaker(String uri, WebsocketServerSpec websocketServerSpec) {
            this.uri = uri;
            String protocols = websocketServerSpec.protocols();
            if (protocols != null) {
                String[] subProtocolArray = protocols.split(",");
                for (int i = 0; i < subProtocolArray.length; ++i) {
                    subProtocolArray[i] = subProtocolArray[i].trim();
                }
                this.subProtocols = subProtocolArray;
            } else {
                this.subProtocols = EmptyArrays.EMPTY_STRINGS;
            }
            this.decoderConfig = WebSocketDecoderConfig.newBuilder().allowExtensions(true).maxFramePayloadLength(websocketServerSpec.maxFramePayloadLength()).allowMaskMismatch(false).build();
        }

        ChannelFuture handshake(Channel channel, HttpRequest req, HttpHeaders responseHeaders, ChannelPromise promise) {
            HttpResponse response = this.newHandshakeResponse(req.headers().get(HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL), responseHeaders);
            ChannelPipeline p = channel.pipeline();
            channel.writeAndFlush(response).addListener(future -> {
                if (future.isSuccess()) {
                    ChannelHandlerContext ctx = p.context("reactor.left.httpTrafficHandler");
                    p.addAfter(ctx.name(), "wsdecoder", WebsocketServerHandshaker.newWebsocketDecoder(this.decoderConfig));
                    p.addAfter(ctx.name(), "wsencoder", WebsocketServerHandshaker.newWebsocketEncoder());
                    p.replace(ctx.name(), "reactor.left.websocketStreamBridgeServerHandler", (ChannelHandler)WebsocketStreamBridgeServerHandler.INSTANCE);
                    promise.setSuccess();
                } else {
                    promise.setFailure(future.cause());
                }
            });
            return promise;
        }

        @Nullable String selectSubProtocol(@Nullable String requestedSubProtocols) {
            String[] requestedSubProtocolArray;
            if (requestedSubProtocols == null || this.subProtocols.length == 0) {
                return null;
            }
            for (String p : requestedSubProtocolArray = requestedSubProtocols.split(",")) {
                String requestedSubProtocol = p.trim();
                for (String supportedSubProtocol : this.subProtocols) {
                    if (!SUB_PROTOCOL_WILDCARD.equals(supportedSubProtocol) && !requestedSubProtocol.equals(supportedSubProtocol)) continue;
                    this.selectedSubProtocol = requestedSubProtocol;
                    return requestedSubProtocol;
                }
            }
            return null;
        }

        HttpResponse newHandshakeResponse(@Nullable String subProtocols, HttpHeaders headers) {
            DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            res.headers().add(headers);
            if (subProtocols != null) {
                String selectedSubProtocol = this.selectSubProtocol(subProtocols);
                if (selectedSubProtocol == null) {
                    if (HttpServerOperations.log.isDebugEnabled()) {
                        HttpServerOperations.log.debug("Requested subprotocol(s) not supported: {}", subProtocols);
                    }
                } else {
                    res.headers().set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL, (Object)selectedSubProtocol);
                }
            }
            return res;
        }

        static WebSocketFrameDecoder newWebsocketDecoder(WebSocketDecoderConfig decoderConfig) {
            return new WebSocket13FrameDecoder(decoderConfig);
        }

        static WebSocketFrameEncoder newWebsocketEncoder() {
            return new WebSocket13FrameEncoder(false);
        }

        static final class WebsocketStreamBridgeServerHandler
        extends ChannelDuplexHandler {
            static final WebsocketStreamBridgeServerHandler INSTANCE = new WebsocketStreamBridgeServerHandler();
            static final String NAME = "reactor.left.websocketStreamBridgeServerHandler";

            WebsocketStreamBridgeServerHandler() {
            }

            @Override
            public void channelRead(ChannelHandlerContext ctx, Object msg) {
                if (!(msg instanceof FullHttpRequest) && msg instanceof HttpContent) {
                    ctx.fireChannelRead(((HttpContent)msg).content());
                } else {
                    ctx.fireChannelRead(msg);
                }
            }

            @Override
            public boolean isSharable() {
                return true;
            }

            @Override
            public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
                if (msg instanceof ByteBuf) {
                    ctx.write(new DefaultHttpContent((ByteBuf)msg), promise);
                } else {
                    ctx.write(msg, promise);
                }
            }
        }
    }
}

