/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.quic.QuicStreamChannel;
import io.netty.util.concurrent.GenericFutureListener;

final class Http3StreamBridgeClientHandler
extends ChannelOutboundHandlerAdapter {
    Http3StreamBridgeClientHandler() {
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (msg instanceof ByteBuf) {
            ctx.write(new DefaultHttpContent((ByteBuf)msg), promise);
        } else {
            ChannelFuture f = ctx.write(msg, promise);
            if (msg instanceof LastHttpContent) {
                f.addListener((GenericFutureListener)QuicStreamChannel.SHUTDOWN_OUTPUT);
            }
        }
    }

    @Override
    public boolean isSharable() {
        return true;
    }
}

