/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http;

import io.netty.handler.codec.http3.Http3;
import io.netty.handler.codec.quic.QuicSslContext;
import io.netty.handler.codec.quic.QuicSslContextBuilder;
import io.netty.handler.ssl.SslContext;
import io.netty.util.DomainWildcardMappingBuilder;
import java.io.File;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import org.jspecify.annotations.Nullable;
import reactor.netty.tcp.SslProvider;

public final class Http3SslContextSpec
implements SslProvider.GenericSslContextSpecWithSniSupport<QuicSslContextBuilder> {
    final QuicSslContextBuilder sslContextBuilder;
    static final Consumer<QuicSslContextBuilder> DEFAULT_CONFIGURATOR = sslCtxBuilder -> sslCtxBuilder.applicationProtocols(Http3.supportedApplicationProtocols());

    public static Http3SslContextSpec forClient() {
        return new Http3SslContextSpec(QuicSslContextBuilder.forClient());
    }

    public static Http3SslContextSpec forServer(File keyFile, @Nullable String keyPassword, File certChainFile) {
        return new Http3SslContextSpec(QuicSslContextBuilder.forServer((File)keyFile, (String)keyPassword, (File)certChainFile));
    }

    public static Http3SslContextSpec forServer(KeyManager keyManager, @Nullable String keyPassword) {
        return new Http3SslContextSpec(QuicSslContextBuilder.forServer((KeyManager)keyManager, (String)keyPassword));
    }

    public static Http3SslContextSpec forServer(KeyManagerFactory keyManagerFactory, @Nullable String password) {
        return new Http3SslContextSpec(QuicSslContextBuilder.forServer((KeyManagerFactory)keyManagerFactory, (String)password));
    }

    public static Http3SslContextSpec forServer(PrivateKey key, @Nullable String keyPassword, X509Certificate ... certChain) {
        return new Http3SslContextSpec(QuicSslContextBuilder.forServer((PrivateKey)key, (String)keyPassword, (X509Certificate[])certChain));
    }

    public Http3SslContextSpec configure(Consumer<QuicSslContextBuilder> sslCtxBuilder) {
        Objects.requireNonNull(sslCtxBuilder, "sslCtxBuilder");
        sslCtxBuilder.accept(this.sslContextBuilder);
        return this;
    }

    @Override
    public SslContext sslContext() throws SSLException {
        return this.sslContextBuilder.build();
    }

    @Override
    public SslContext sslContext(Map<String, SslProvider> sniMappings) throws SSLException {
        DomainWildcardMappingBuilder<QuicSslContext> mappingsSslProviderBuilder = new DomainWildcardMappingBuilder<QuicSslContext>((QuicSslContext)this.sslContext());
        sniMappings.forEach((s, sslProvider) -> mappingsSslProviderBuilder.add((String)s, (QuicSslContext)sslProvider.getSslContext()));
        return QuicSslContextBuilder.buildForServerWithSni(mappingsSslProviderBuilder.build());
    }

    Http3SslContextSpec(QuicSslContextBuilder sslContextBuilder) {
        this.sslContextBuilder = sslContextBuilder;
        this.configure((Consumer)DEFAULT_CONFIGURATOR);
    }
}

