/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import io.netty.incubator.codec.http3.Http3FrameToHttpObjectCodec;
import io.netty.incubator.codec.http3.Http3ServerConnectionHandler;
import io.netty.incubator.codec.quic.QuicStreamChannel;
import java.time.Duration;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.ReactorNetty;
import reactor.netty.channel.ChannelMetricsRecorder;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.http.logging.HttpMessageLogFactory;
import reactor.netty.http.server.AbstractHttpServerMetricsHandler;
import reactor.netty.http.server.ConnectionInfo;
import reactor.netty.http.server.ContextAwareHttpServerMetricsHandler;
import reactor.netty.http.server.ContextAwareHttpServerMetricsRecorder;
import reactor.netty.http.server.Http3StreamBridgeServerHandler;
import reactor.netty.http.server.HttpServerFormDecoderProvider;
import reactor.netty.http.server.HttpServerMetricsHandler;
import reactor.netty.http.server.HttpServerMetricsRecorder;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;
import reactor.netty.http.server.MicrometerHttpServerMetricsHandler;
import reactor.netty.http.server.MicrometerHttpServerMetricsRecorder;
import reactor.netty.http.server.SimpleCompressionHandler;
import reactor.netty.http.server.compression.HttpCompressionOptionsSpec;
import reactor.netty.http.server.logging.AccessLog;
import reactor.netty.http.server.logging.AccessLogArgProvider;
import reactor.netty.http.server.logging.AccessLogHandlerFactory;
import reactor.netty.http.server.logging.error.DefaultErrorLogHandler;
import reactor.netty.http.server.logging.error.ErrorLog;
import reactor.netty.http.server.logging.error.ErrorLogArgProvider;
import reactor.util.Logger;
import reactor.util.Loggers;

final class Http3Codec
extends ChannelInitializer<QuicStreamChannel> {
    static final Logger log = Loggers.getLogger(Http3Codec.class);
    final boolean accessLogEnabled;
    final @Nullable Function<AccessLogArgProvider, @Nullable AccessLog> accessLog;
    final @Nullable HttpCompressionOptionsSpec compressionOptions;
    final @Nullable BiPredicate<HttpServerRequest, HttpServerResponse> compressPredicate;
    final ServerCookieDecoder cookieDecoder;
    final ServerCookieEncoder cookieEncoder;
    final boolean errorLogEnabled;
    final @Nullable Function<ErrorLogArgProvider, @Nullable ErrorLog> errorLog;
    final HttpServerFormDecoderProvider formDecoderProvider;
    final @Nullable BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler;
    final HttpMessageLogFactory httpMessageLogFactory;
    final ConnectionObserver listener;
    final @Nullable BiFunction<? super Mono<Void>, ? super Connection, ? extends Mono<Void>> mapHandle;
    final @Nullable Function<String, String> methodTagValue;
    final @Nullable ChannelMetricsRecorder metricsRecorder;
    final int minCompressionSize;
    final ChannelOperations.OnSetup opsFactory;
    final @Nullable Duration readTimeout;
    final @Nullable Duration requestTimeout;
    final @Nullable Function<String, String> uriTagValue;
    final boolean validate;

    Http3Codec(boolean accessLogEnabled, @Nullable Function<AccessLogArgProvider, @Nullable AccessLog> accessLog, @Nullable HttpCompressionOptionsSpec compressionOptions, @Nullable BiPredicate<HttpServerRequest, HttpServerResponse> compressPredicate, ServerCookieDecoder decoder, ServerCookieEncoder encoder, boolean errorLogEnabled, @Nullable Function<ErrorLogArgProvider, @Nullable ErrorLog> errorLog, HttpServerFormDecoderProvider formDecoderProvider, @Nullable BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler, HttpMessageLogFactory httpMessageLogFactory, ConnectionObserver listener, @Nullable BiFunction<? super Mono<Void>, ? super Connection, ? extends Mono<Void>> mapHandle, @Nullable Function<String, String> methodTagValue, @Nullable ChannelMetricsRecorder metricsRecorder, int minCompressionSize, ChannelOperations.OnSetup opsFactory, @Nullable Duration readTimeout, @Nullable Duration requestTimeout, @Nullable Function<String, String> uriTagValue, boolean validate) {
        this.accessLogEnabled = accessLogEnabled;
        this.accessLog = accessLog;
        this.compressionOptions = compressionOptions;
        this.compressPredicate = compressPredicate;
        this.cookieDecoder = decoder;
        this.cookieEncoder = encoder;
        this.errorLogEnabled = errorLogEnabled;
        this.errorLog = errorLog;
        this.formDecoderProvider = formDecoderProvider;
        this.forwardedHeaderHandler = forwardedHeaderHandler;
        this.httpMessageLogFactory = httpMessageLogFactory;
        this.listener = listener;
        this.mapHandle = mapHandle;
        this.methodTagValue = methodTagValue;
        this.metricsRecorder = metricsRecorder;
        this.minCompressionSize = minCompressionSize;
        this.opsFactory = opsFactory;
        this.readTimeout = readTimeout;
        this.requestTimeout = requestTimeout;
        this.uriTagValue = uriTagValue;
        this.validate = validate;
    }

    @Override
    protected void initChannel(QuicStreamChannel channel) {
        boolean alwaysCompress;
        ChannelPipeline p = channel.pipeline();
        if (this.accessLogEnabled) {
            p.addLast("reactor.left.accessLogHandler", AccessLogHandlerFactory.H3.create(this.accessLog));
        }
        p.addLast("reactor.left.h3ToHttp11Codec", (ChannelHandler)new Http3FrameToHttpObjectCodec(true, this.validate)).addLast("reactor.left.httpTrafficHandler", (ChannelHandler)new Http3StreamBridgeServerHandler(this.compressPredicate, this.compressionOptions, this.cookieDecoder, this.cookieEncoder, this.formDecoderProvider, this.forwardedHeaderHandler, this.httpMessageLogFactory, this.listener, this.mapHandle, this.readTimeout, this.requestTimeout));
        boolean bl = alwaysCompress = this.compressPredicate == null && this.minCompressionSize == 0;
        if (alwaysCompress) {
            p.addLast("reactor.left.compressionHandler", (ChannelHandler)SimpleCompressionHandler.create(this.compressionOptions));
        }
        ChannelOperations.addReactiveBridge((Channel)channel, this.opsFactory, this.listener);
        if (this.metricsRecorder != null && this.metricsRecorder instanceof HttpServerMetricsRecorder) {
            AbstractHttpServerMetricsHandler handler = this.metricsRecorder instanceof MicrometerHttpServerMetricsRecorder ? new MicrometerHttpServerMetricsHandler((MicrometerHttpServerMetricsRecorder)this.metricsRecorder, this.methodTagValue, this.uriTagValue) : (this.metricsRecorder instanceof ContextAwareHttpServerMetricsRecorder ? new ContextAwareHttpServerMetricsHandler((ContextAwareHttpServerMetricsRecorder)this.metricsRecorder, this.methodTagValue, this.uriTagValue) : new HttpServerMetricsHandler((HttpServerMetricsRecorder)this.metricsRecorder, this.methodTagValue, this.uriTagValue));
            p.addBefore("reactor.right.reactiveBridge", "reactor.left.httpMetricsHandler", handler);
        }
        if (this.errorLogEnabled) {
            p.addBefore("reactor.right.reactiveBridge", "reactor.left.errorLogHandler", new DefaultErrorLogHandler(this.errorLog));
        }
        channel.pipeline().remove(this);
        if (log.isDebugEnabled()) {
            log.debug(ReactorNetty.format((Channel)channel, "Initialized HTTP/3 stream pipeline {}"), p);
        }
    }

    static ChannelHandler newHttp3ServerConnectionHandler(boolean accessLogEnabled, @Nullable Function<AccessLogArgProvider, @Nullable AccessLog> accessLog, @Nullable HttpCompressionOptionsSpec compressionOptions, @Nullable BiPredicate<HttpServerRequest, HttpServerResponse> compressPredicate, ServerCookieDecoder decoder, ServerCookieEncoder encoder, boolean errorLogEnabled, @Nullable Function<ErrorLogArgProvider, @Nullable ErrorLog> errorLog, HttpServerFormDecoderProvider formDecoderProvider, @Nullable BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler, HttpMessageLogFactory httpMessageLogFactory, ConnectionObserver listener, @Nullable BiFunction<? super Mono<Void>, ? super Connection, ? extends Mono<Void>> mapHandle, @Nullable Function<String, String> methodTagValue, @Nullable ChannelMetricsRecorder metricsRecorder, int minCompressionSize, ChannelOperations.OnSetup opsFactory, @Nullable Duration readTimeout, @Nullable Duration requestTimeout, @Nullable Function<String, String> uriTagValue, boolean validate) {
        return new Http3ServerConnectionHandler((ChannelHandler)new Http3Codec(accessLogEnabled, accessLog, compressionOptions, compressPredicate, decoder, encoder, errorLogEnabled, errorLog, formDecoderProvider, forwardedHeaderHandler, httpMessageLogFactory, listener, mapHandle, methodTagValue, metricsRecorder, minCompressionSize, opsFactory, readTimeout, requestTimeout, uriTagValue, validate));
    }
}

